/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.sftp;

import com.sshtools.common.sftp.SftpFileAttributes;
import java.util.Objects;

public final class SftpFile {
    private final String filename;
    private final String absolutePath;
    private final String longname;
    private final SftpFileAttributes attrs;

    SftpFile(String path, SftpFileAttributes attrs, String longname) {
        if (path == null || attrs == null) {
            throw new NullPointerException();
        }
        this.attrs = attrs;
        this.longname = longname;
        String absolutePath = path;
        if (absolutePath.equals("/")) {
            this.filename = "/";
        } else {
            int i;
            if (!Boolean.getBoolean("maverick.disableSlashRemoval") && absolutePath.endsWith("/")) {
                absolutePath = absolutePath.substring(0, absolutePath.length() - 1);
            }
            this.filename = (i = absolutePath.lastIndexOf(47)) > -1 ? absolutePath.substring(i + 1) : absolutePath;
        }
        this.absolutePath = absolutePath;
    }

    public SftpFileAttributes attributes() {
        return this.attrs;
    }

    public String toString() {
        return this.absolutePath;
    }

    public int hashCode() {
        return Objects.hash(this.absolutePath);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SftpFile other = (SftpFile)obj;
        return Objects.equals(this.absolutePath, other.absolutePath);
    }

    public String getLongname() {
        return this.longname;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }
}

