/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.sftp;

import com.sshtools.client.SshClient;
import com.sshtools.client.sftp.DirectoryOperation;
import com.sshtools.client.sftp.GlobRegExpMatching;
import com.sshtools.client.sftp.NoRegExpMatching;
import com.sshtools.client.sftp.RegExpMatching;
import com.sshtools.client.sftp.RegularExpressionMatching;
import com.sshtools.client.sftp.RemoteHash;
import com.sshtools.client.sftp.SftpChannel;
import com.sshtools.client.sftp.SftpFile;
import com.sshtools.client.sftp.SftpFileInputStream;
import com.sshtools.client.sftp.SftpFileOutputStream;
import com.sshtools.client.sftp.SftpHandle;
import com.sshtools.client.sftp.SftpMessage;
import com.sshtools.client.sftp.StatVfs;
import com.sshtools.client.sftp.TransferCancelledException;
import com.sshtools.client.tasks.FileTransferProgress;
import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileFactory;
import com.sshtools.common.files.direct.NioFileFactory;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.GlobSftpFileFilter;
import com.sshtools.common.sftp.PosixPermissions;
import com.sshtools.common.sftp.RegexSftpFileFilter;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.SshIOException;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.common.util.EOLProcessor;
import com.sshtools.common.util.FileUtils;
import com.sshtools.common.util.IOUtils;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.common.util.Utils;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class SftpClient
implements Closeable {
    public static final int DEFAULT_BUFFER_SIZE = 1024000;
    private final SftpChannel sftp;
    private String cwd = "";
    private AbstractFile lcwd;
    private int blocksize;
    private int asyncRequests;
    private int buffersize;
    int umask = 18;
    boolean applyUmask = false;
    public static final int MODE_BINARY = 1;
    public static final int MODE_TEXT = 2;
    public static final int EOL_CRLF = 1;
    public static final int EOL_LF = 2;
    public static final int EOL_CR = 3;
    private int outputEOL = 1;
    private int inputEOL = 0;
    private boolean stripEOL = false;
    private boolean forceRemoteEOL;
    private int transferMode = 1;
    private Vector<String> customRoots = new Vector();
    public static final int NoSyntax = 0;
    public static final int GlobSyntax = 1;
    public static final int Perl5Syntax = 2;
    private int RegExpSyntax = 1;

    SftpClient(SftpClientBuilder builder) throws SshException, PermissionDeniedException, IOException {
        AbstractFileFactory fileFactory = builder.fileFactory.orElseGet(() -> NioFileFactory.NioFileFactoryBuilder.create().withHome(builder.localHome.orElseGet(() -> Paths.get(System.getProperty("user.home"), new String[0]))).withSandbox(builder.localHomeSandbox).build());
        this.asyncRequests = builder.asyncRequests.orElse(-1);
        this.buffersize = builder.bufferSize;
        this.blocksize = builder.blockSize.orElse(-1);
        this.sftp = new SftpChannel(builder.connection.orElseThrow(() -> new IllegalStateException("Either an existing connection or an existing client must be provided.")));
        this.lcwd = fileFactory.getFile(builder.localPath.orElse(""));
        this.cwd = builder.remotePath.orElse("");
        this.customRoots.addAll(builder.customRoots);
        if (builder.charset.isPresent()) {
            this.sftp.setCharsetEncoding(builder.charset.get());
        }
    }

    public void setBlockSize(int blocksize) {
        if (blocksize < 512) {
            throw new IllegalArgumentException("Block size must be greater than 512");
        }
        this.blocksize = blocksize;
    }

    public SftpChannel getSubsystemChannel() {
        return this.sftp;
    }

    public void setTransferMode(int transferMode) {
        if (transferMode != 1 && transferMode != 2) {
            throw new IllegalArgumentException("Mode can only be either binary or text");
        }
        this.transferMode = transferMode;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Transfer mode set to " + (transferMode == 1 ? "binary" : "text")), (Object[])new Object[0]);
        }
    }

    public void setStripEOL(boolean stripEOL) {
        this.stripEOL = stripEOL;
    }

    public void setRemoteEOL(int eolMode) {
        this.outputEOL = eolMode;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Remote EOL set to " + (eolMode == 1 ? "CRLF" : (eolMode == 3 ? "CR" : "LF"))), (Object[])new Object[0]);
        }
    }

    public void setLocalEOL(int eolMode) {
        this.inputEOL = eolMode;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Input EOL set to " + (eolMode == 1 ? "CRLF" : (eolMode == 3 ? "CR" : "LF"))), (Object[])new Object[0]);
        }
    }

    public void setForceRemoteEOL(boolean forceRemoteEOL) {
        this.forceRemoteEOL = forceRemoteEOL;
    }

    public int getTransferMode() {
        return this.transferMode;
    }

    public void setBufferSize(int buffersize) {
        this.buffersize = buffersize;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Buffer size set to " + buffersize), (Object[])new Object[0]);
        }
    }

    public void setMaxAsyncRequests(int asyncRequests) {
        if (asyncRequests < 1) {
            throw new IllegalArgumentException("Maximum asynchronous requests must be greater or equal to 1");
        }
        this.asyncRequests = asyncRequests;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Max async requests set to " + asyncRequests), (Object[])new Object[0]);
        }
    }

    public int umask(int umask) {
        this.applyUmask = true;
        int old = this.umask;
        this.umask = umask;
        if (Log.isDebugEnabled()) {
            Log.debug((String)("umask " + umask), (Object[])new Object[0]);
        }
        return old;
    }

    public SftpHandle openFile(String fileName) throws SftpStatusException, SshException {
        return this.openFile(fileName, 1);
    }

    public SftpHandle openFile(String fileName, int flags) throws SftpStatusException, SshException {
        if (this.transferMode == 2 && this.sftp.getVersion() > 3) {
            return this.sftp.openFile(this.resolveRemotePath(fileName), flags | 0x40);
        }
        return this.sftp.openFile(this.resolveRemotePath(fileName), flags);
    }

    public SftpHandle openDirectory(String path) throws SftpStatusException, SshException {
        return this.sftp.openDirectory(path);
    }

    public List<SftpFile> readDirectory(SftpHandle dir) throws SftpStatusException, SshException {
        ArrayList<SftpFile> results = new ArrayList<SftpFile>();
        if (dir.listChildren(results) == -1) {
            return null;
        }
        return results;
    }

    public void cd(String dir) throws SftpStatusException, SshException {
        SftpFileAttributes attr;
        String actual;
        if (dir == null || dir.equals("")) {
            actual = this.sftp.getDefaultDirectory();
        } else {
            actual = this.resolveRemotePath(dir);
            actual = this.sftp.getAbsolutePath(actual);
        }
        if (!actual.equals("") && !(attr = this.sftp.getAttributes(actual)).isDirectory()) {
            throw new SftpStatusException(4, dir + " is not a directory");
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Changing dir from " + this.cwd + " to " + (actual.equals("") ? "user default dir" : actual)), (Object[])new Object[0]);
        }
        this.cwd = actual;
    }

    public String getDefaultDirectory() throws SftpStatusException, SshException {
        return this.sftp.getDefaultDirectory();
    }

    public void cdup() throws SftpStatusException, SshException {
        String parent = FileUtils.stripLastPathElement((String)this.cwd);
        if (parent != null) {
            this.cwd = parent;
        }
    }

    private AbstractFile resolveLocalPath(String path) throws IOException, PermissionDeniedException {
        return this.lcwd.resolveFile(path);
    }

    private boolean isWindowsRoot(String path) {
        return path.length() > 2 && ((path.charAt(0) >= 'a' && path.charAt(0) <= 'z' || path.charAt(0) >= 'A' && path.charAt(0) <= 'Z') && path.charAt(1) == ':' && path.charAt(2) == '/' || path.charAt(2) == '\\');
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void addCustomRoot(String rootPath) {
        this.customRoots.addElement(rootPath);
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    public void removeCustomRoot(String rootPath) {
        this.customRoots.removeElement(rootPath);
    }

    private boolean startsWithCustomRoot(String path) {
        Enumeration<String> it = this.customRoots.elements();
        while (it != null && it.hasMoreElements()) {
            if (!path.startsWith(it.nextElement())) continue;
            return true;
        }
        return false;
    }

    private String resolveRemotePath(String path) throws SftpStatusException, SshException {
        this.verifyConnection();
        Object actual = !path.startsWith("/") && !path.startsWith(this.cwd) && !this.isWindowsRoot(path) && !this.startsWithCustomRoot(path) ? this.cwd + (this.cwd.endsWith("/") ? "" : "/") + path : path;
        if (!Boolean.getBoolean("maverick.disableSlashRemoval") && !((String)actual).equals("/") && ((String)actual).endsWith("/")) {
            return ((String)actual).substring(0, ((String)actual).length() - 1);
        }
        return actual;
    }

    private void verifyConnection() throws SshException {
        if (this.sftp.isClosed()) {
            throw new SshException("The SFTP connection has been closed", 2);
        }
    }

    public void mkdir(String dir) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(dir);
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Creating dir " + dir), (Object[])new Object[0]);
        }
        SftpFileAttributes attrs = null;
        try {
            attrs = this.sftp.getAttributes(actual);
        }
        catch (SftpStatusException ex) {
            SftpFileAttributes.SftpFileAttributesBuilder newattrs = SftpFileAttributes.SftpFileAttributesBuilder.ofType((int)2, (String)this.sftp.getCharsetEncoding());
            if (this.applyUmask) {
                newattrs.withPermissions(PosixPermissions.PosixPermissionsBuilder.create().fromBitmask((long)(0x1FF ^ this.umask)).build());
            }
            this.sftp.makeDirectory(actual, newattrs.build());
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("File with name " + dir + " already exists!"), (Object[])new Object[0]);
        }
        throw new SftpStatusException(4, (attrs.isDirectory() ? "Directory" : "File") + " already exists named " + dir);
    }

    public void mkdirs(String dir) throws SftpStatusException, SshException {
        Object path;
        StringTokenizer tokens = new StringTokenizer(dir, "/");
        Object object = path = dir.startsWith("/") ? "/" : "";
        while (tokens.hasMoreElements()) {
            block5: {
                path = (String)path + (String)tokens.nextElement();
                try {
                    this.stat((String)path);
                }
                catch (SftpStatusException ex) {
                    try {
                        this.mkdir((String)path);
                    }
                    catch (SftpStatusException ex2) {
                        if (ex2.getStatus() != 3) break block5;
                        throw ex2;
                    }
                }
            }
            path = (String)path + "/";
        }
    }

    public boolean isDirectoryOrLinkedDirectory(SftpFile file) throws SftpStatusException, SshException {
        return file.attributes().isDirectory() || file.attributes().isLink() && this.stat(file.getAbsolutePath()).isDirectory();
    }

    public boolean exists(String path) throws SftpStatusException, SshException {
        try {
            this.stat(path);
            return true;
        }
        catch (SftpStatusException sse) {
            if (sse.getStatus() == 2) {
                return false;
            }
            throw sse;
        }
    }

    public String pwd() throws SftpStatusException, SshException {
        return this.getAbsolutePath(this.cwd);
    }

    public SftpFile[] ls() throws SftpStatusException, SshException {
        return this.ls(this.cwd);
    }

    public SftpFile[] ls(String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Listing files for " + actual), (Object[])new Object[0]);
        }
        Vector<SftpFile> children = new Vector<SftpFile>();
        try (SftpHandle file = this.sftp.openDirectory(actual);){
            while (file.listChildren(children) > -1) {
            }
        }
        catch (IOException e) {
            throw new SshException(5, (Throwable)e);
        }
        SftpFile[] files = new SftpFile[children.size()];
        int index = 0;
        Enumeration<SftpFile> e = children.elements();
        while (e.hasMoreElements()) {
            files[index++] = e.nextElement();
        }
        return files;
    }

    public SftpFile[] ls(String filter, boolean regexFilter, int maximumFiles) throws SftpStatusException, SshException {
        return this.ls("", filter, regexFilter, maximumFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SftpFile[] ls(String path, String filter, boolean regexFilter, int maximumFiles) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Listing files for {} with filter {}", (Object[])new Object[0]);
        }
        ByteArrayWriter msg = new ByteArrayWriter();
        try {
            SftpHandle handleObject;
            msg.writeString(actual);
            msg.writeString(filter);
            msg.writeBoolean(regexFilter);
            boolean localFiltering = false;
            Vector<SftpFile> children = new Vector<SftpFile>();
            Vector<SftpFile> tmp = new Vector<SftpFile>();
            SftpFileAttributes attrs = this.sftp.getAttributes(path);
            SftpFile file = new SftpFile(path, attrs, SftpClient.formatLongname(attrs, FileUtils.getFilename((String)path)));
            try {
                handleObject = this.sftp.getHandle(this.sftp.sendExtensionMessage("open-directory-with-filter@sshtools.com", msg.toByteArray()), file);
                localFiltering = false;
            }
            catch (SftpStatusException e) {
                if (Boolean.getBoolean("maverick.disableLocalFiltering")) {
                    throw new SshException("Remote server does not support server side filtering", 57351);
                }
                handleObject = new SftpHandle(this.sftp.openDirectory(path).getHandle(), this.sftp, file);
            }
            RegexSftpFileFilter f = null;
            if (localFiltering) {
                f = regexFilter ? new RegexSftpFileFilter(filter) : new GlobSftpFileFilter(filter);
            }
            try {
                int pageCount;
                do {
                    if ((pageCount = handleObject.listChildren(tmp)) <= -1) continue;
                    if (!localFiltering) {
                        if (pageCount > -1 && Log.isDebugEnabled()) {
                            Log.debug((String)"Got page of {} files for {} with filter {}", (Object[])new Object[]{pageCount, actual, filter});
                        }
                        children.addAll(tmp);
                        continue;
                    }
                    if (pageCount > -1 && Log.isDebugEnabled()) {
                        Log.debug((String)"Got page of {} files for {} before local filtering for {}", (Object[])new Object[]{pageCount, actual, filter});
                    }
                    int count = 0;
                    for (SftpFile t : tmp) {
                        if (!f.matches(t.getFilename())) continue;
                        children.add(t);
                        ++count;
                    }
                    if (pageCount <= -1 || !Log.isDebugEnabled()) continue;
                    Log.debug((String)"Got page of {} files for {} after local filtering {}", (Object[])new Object[]{count, actual, filter});
                } while (pageCount > -1 && (maximumFiles == 0 || children.size() < maximumFiles));
            }
            finally {
                handleObject.close();
            }
            SftpFile[] files = new SftpFile[children.size()];
            int index = 0;
            Enumeration e = children.elements();
            while (e.hasMoreElements()) {
                files[index++] = (SftpFile)e.nextElement();
            }
            SftpFile[] sftpFileArray = files;
            return sftpFileArray;
        }
        catch (IOException e) {
            throw new SshException(5, (Throwable)e);
        }
        finally {
            try {
                msg.close();
            }
            catch (IOException iOException) {}
        }
    }

    private SftpHandle openDirectoryHandle(String path, ByteArrayWriter msg) throws SshException, SftpStatusException {
        SftpFile file = new SftpFile(path, this.sftp.getAttributes(path), null);
        try {
            return this.sftp.getHandle(this.sftp.sendExtensionMessage("open-directory-with-filter@sshtools.com", msg.toByteArray()), file);
        }
        catch (SftpStatusException e) {
            if (Boolean.getBoolean("maverick.disableLocalFiltering")) {
                throw new SshException("Remote server does not support server side filtering", 57351);
            }
            return this.sftp.openDirectory(path);
        }
    }

    public Iterator<SftpFile> lsIterator() throws SftpStatusException, SshException {
        return this.lsIterator(this.cwd);
    }

    public Iterator<SftpFile> lsIterator(String path) throws SftpStatusException, SshException {
        return new DirectoryIterator(path);
    }

    public void lcd(String path) throws SftpStatusException, IOException, PermissionDeniedException {
        AbstractFile actual = this.lcwd.resolveFile(path);
        if (!actual.isDirectory()) {
            throw new SftpStatusException(4, path + " is not a directory");
        }
        this.lcwd = actual;
    }

    public String lpwd() throws IOException, PermissionDeniedException {
        return this.lcwd.getAbsolutePath();
    }

    public AbstractFile getCurrentWorkingDirectory() {
        return this.lcwd;
    }

    public SftpFileAttributes get(String path, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        return this.get(path, progress, false);
    }

    public SftpFileAttributes get(String path, FileTransferProgress progress, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        String localfile = path.lastIndexOf("/") > -1 ? path.substring(path.lastIndexOf("/") + 1) : path;
        return this.get(path, localfile, progress, resume);
    }

    public SftpFileAttributes get(String path, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        return this.get(path, (FileTransferProgress)null, resume);
    }

    public SftpFileAttributes get(String path) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        return this.get(path, (FileTransferProgress)null);
    }

    public String getSymbolicLinkTarget(String linkpath) throws SftpStatusException, SshException {
        return this.sftp.getSymbolicLinkTarget(linkpath);
    }

    public SftpFileAttributes get(String remote, String local, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        return this.get(remote, local, progress, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SftpFileAttributes get(String remote, String local, FileTransferProgress progress, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        SftpFileAttributes sftpFileAttributes;
        OutputStream out = null;
        SftpFileAttributes attrs = null;
        AbstractFile localPath = this.resolveLocalPath(local);
        if (!localPath.exists()) {
            AbstractFile parent = localPath.resolveFile(FileUtils.getParentPath((String)localPath.getAbsolutePath()));
            parent.createFolder();
        }
        if (localPath.isDirectory()) {
            localPath = localPath.resolveFile(FileUtils.getFilename((String)remote));
        }
        this.stat(remote);
        long position = 0L;
        try {
            if (resume && localPath.exists()) {
                out = localPath.getOutputStream(true);
                position = localPath.length();
            } else {
                out = localPath.getOutputStream();
            }
            sftpFileAttributes = attrs = this.get(remote, out, progress, position);
        }
        catch (IOException ex) {
            try {
                throw new SftpStatusException(4, "Failed to open outputstream to " + local);
            }
            catch (Throwable throwable) {
                try {
                    if (out != null) {
                        out.close();
                    }
                    if (attrs == null) throw throwable;
                    localPath.setAttributes(attrs);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            if (out != null) {
                out.close();
            }
            if (attrs == null) return sftpFileAttributes;
            localPath.setAttributes(attrs);
            return sftpFileAttributes;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return sftpFileAttributes;
    }

    public String getRemoteNewline() throws SftpStatusException {
        return new String(this.sftp.getCanonicalNewline());
    }

    public int getRemoteEOL() throws SftpStatusException {
        return this.getEOL(this.sftp.getCanonicalNewline());
    }

    public int getEOL(String line) throws SftpStatusException {
        byte[] nl = line.getBytes();
        return this.getEOL(nl);
    }

    public int getEOL(byte[] nl) throws SftpStatusException {
        switch (nl.length) {
            case 1: {
                if (nl[0] == 13) {
                    return 3;
                }
                if (nl[0] == 10) {
                    return 2;
                }
                throw new SftpStatusException(100, "Unsupported text mode: invalid newline character");
            }
            case 2: {
                if (nl[0] == 13 && nl[1] == 10) {
                    return 1;
                }
                throw new SftpStatusException(100, "Unsupported text mode: invalid newline characters");
            }
        }
        throw new SftpStatusException(100, "Unsupported text mode: newline length > 2");
    }

    public SftpFileAttributes get(String remote, String local, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        return this.get(remote, local, null, resume);
    }

    public SftpFileAttributes get(String remote, String local) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        return this.get(remote, local, false);
    }

    public SftpFileAttributes get(String remote, OutputStream local, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException {
        return this.get(remote, local, progress, 0L);
    }

    public void setRegularExpressionSyntax(int syntax) {
        this.RegExpSyntax = syntax;
    }

    public SftpFile[] matchRemoteFiles(String remote) throws SftpStatusException, SshException {
        SftpFile[] files;
        RegularExpressionMatching matcher;
        String actualSearch;
        String actualDir;
        int fileSeparatorIndex = remote.lastIndexOf("/");
        if (fileSeparatorIndex > -1) {
            actualDir = remote.substring(0, fileSeparatorIndex);
            actualSearch = remote.length() > fileSeparatorIndex + 1 ? remote.substring(fileSeparatorIndex + 1) : "";
        } else {
            actualDir = this.cwd;
            actualSearch = remote;
        }
        switch (this.RegExpSyntax) {
            case 1: {
                matcher = new GlobRegExpMatching();
                files = this.ls(actualDir);
                break;
            }
            case 2: {
                matcher = new RegExpMatching();
                files = this.ls(actualDir);
                break;
            }
            default: {
                matcher = new NoRegExpMatching();
                files = new SftpFile[1];
                String actual = this.resolveRemotePath(remote);
                files[0] = this.getSubsystemChannel().getFile(actual);
            }
        }
        return matcher.matchFilesWithPattern(files, actualSearch);
    }

    private SftpFile[] getFileMatches(String remote, String local, FileTransferProgress progress, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        SftpFile[] matchedFiles = this.matchRemoteFiles(remote);
        Vector<SftpFile> retrievedFiles = new Vector<SftpFile>();
        for (int i = 0; i < matchedFiles.length; ++i) {
            this.get(matchedFiles[i].getAbsolutePath(), local, progress, resume);
            retrievedFiles.addElement(matchedFiles[i]);
        }
        Object[] retrievedSftpFiles = new SftpFile[retrievedFiles.size()];
        retrievedFiles.copyInto(retrievedSftpFiles);
        return retrievedSftpFiles;
    }

    private String[] matchLocalFiles(String local) throws SftpStatusException, SshException, IOException, PermissionDeniedException {
        AbstractFile[] files;
        RegularExpressionMatching matcher;
        String actualSearch;
        AbstractFile actualDir;
        if (FileUtils.hasParents((String)local)) {
            actualDir = this.resolveLocalPath(FileUtils.getParentPath((String)local));
            actualSearch = FileUtils.getFilename((String)local);
        } else {
            actualDir = this.lcwd;
            actualSearch = local;
        }
        switch (this.RegExpSyntax) {
            case 1: {
                matcher = new GlobRegExpMatching();
                files = this.listFiles(actualDir);
                break;
            }
            case 2: {
                matcher = new RegExpMatching();
                files = this.listFiles(actualDir);
                break;
            }
            default: {
                matcher = new NoRegExpMatching();
                files = new AbstractFile[]{this.lcwd.resolveFile(local)};
            }
        }
        return matcher.matchFileNamesWithPattern(files, actualSearch);
    }

    private AbstractFile[] listFiles(AbstractFile f) throws IOException, PermissionDeniedException {
        return f.getChildren().toArray(new AbstractFile[0]);
    }

    private void putFileMatches(String local, String remote, FileTransferProgress progress, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        String remotePath = this.resolveRemotePath(remote);
        SftpFileAttributes attrs = null;
        try {
            attrs = this.stat(remotePath);
        }
        catch (SftpStatusException ex) {
            throw new SftpStatusException(ex.getStatus(), "Remote path '" + remote + "' does not exist. It must be a valid directory and must already exist!");
        }
        if (!attrs.isDirectory()) {
            throw new SftpStatusException(10, "Remote path '" + remote + "' is not a directory!");
        }
        String[] matchedFiles = this.matchLocalFiles(local);
        if (Log.isDebugEnabled()) {
            Log.debug((String)"Matched {} files for {}", (Object[])new Object[]{matchedFiles.length, local});
        }
        for (int i = 0; i < matchedFiles.length; ++i) {
            try {
                this.put(matchedFiles[i], remotePath, progress, resume);
                continue;
            }
            catch (SftpStatusException ex) {
                throw new SftpStatusException(ex.getStatus(), "Failed to put " + matchedFiles[i] + " to " + remote + " [" + ex.getMessage() + "]");
            }
        }
    }

    public SftpFileAttributes get(String remote, OutputStream local, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        String remotePath = this.resolveRemotePath(remote);
        SftpFileAttributes attrs = this.sftp.getAttributes(remotePath);
        if (position > attrs.size().longValue()) {
            throw new SftpStatusException(101, "The local file size is greater than the remote file");
        }
        if (progress != null) {
            progress.started(attrs.size().longValue() - position, remotePath);
        }
        SftpHandle file = this.transferMode == 2 && this.sftp.getVersion() > 3 ? this.sftp.openFile(remotePath, 65) : this.sftp.openFile(remotePath, 1);
        try {
            if (this.transferMode == 2) {
                int inputStyle = this.outputEOL;
                int outputStyle = this.stripEOL ? 4 : this.inputEOL;
                byte[] nl = null;
                if (this.sftp.getVersion() <= 3 && this.sftp.getExtension("newline@vandyke.com") != null) {
                    nl = this.sftp.getExtension("newline@vandyke.com");
                } else if (this.sftp.getVersion() > 3) {
                    nl = this.sftp.getCanonicalNewline();
                }
                if (nl != null && !this.forceRemoteEOL) {
                    inputStyle = this.getEOL(new String(nl));
                }
                local = EOLProcessor.createOutputStream((int)inputStyle, (int)outputStyle, (OutputStream)local);
            }
            file.performOptimizedRead(attrs.size().longValue(), this.blocksize, local, this.asyncRequests, progress, position);
        }
        catch (IOException ex) {
            throw new SftpStatusException(4, "Failed to open text conversion outputstream");
        }
        catch (TransferCancelledException tce) {
            throw tce;
        }
        finally {
            try {
                local.close();
            }
            catch (Throwable throwable) {}
            try {
                file.close();
            }
            catch (IOException iOException) {}
        }
        if (progress != null) {
            progress.completed();
        }
        return attrs;
    }

    public InputStream getInputStream(String remotefile, long position) throws SftpStatusException, SshException {
        String remotePath = this.resolveRemotePath(remotefile);
        this.sftp.getAttributes(remotePath);
        return new SftpFileInputStream(this.sftp.openFile(remotePath, 1), position);
    }

    public InputStream getInputStream(String remotefile) throws SftpStatusException, SshException {
        return this.getInputStream(remotefile, 0L);
    }

    public SftpFileAttributes get(String remote, OutputStream local, long position) throws SftpStatusException, SshException, TransferCancelledException {
        return this.get(remote, local, null, position);
    }

    public SftpFileAttributes get(String remote, OutputStream local) throws SftpStatusException, SshException, TransferCancelledException {
        return this.get(remote, local, null, 0L);
    }

    public boolean isClosed() {
        return this.sftp.isClosed();
    }

    public void put(String local, FileTransferProgress progress, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        AbstractFile f = this.resolveLocalPath(local);
        this.put(local, f.getName(), progress, resume);
    }

    public void put(String local, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        this.put(local, progress, false);
    }

    public void put(String local) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        this.put(local, false);
    }

    public void put(String local, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        this.put(local, (FileTransferProgress)null, resume);
    }

    public void put(String local, String remote, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        this.put(local, remote, progress, false);
    }

    public void append(InputStream in, String remote) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(in, remote, null, -1L, -1L);
    }

    @Deprecated
    public void append(InputStream in, String remote, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException {
        this.append(in, remote, progress, -1L);
    }

    public void append(InputStream in, String remote, FileTransferProgress progress, long length) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(in, remote, progress, -1L, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String local, String remote, FileTransferProgress progress, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        AbstractFile localPath = this.resolveLocalPath(local);
        InputStream in = localPath.getInputStream();
        long position = 0L;
        long length = localPath.length();
        SftpFileAttributes attrs = null;
        try {
            attrs = this.stat((String)remote);
            if (attrs.isDirectory()) {
                remote = (String)remote + (((String)remote).endsWith("/") ? "" : "/") + localPath.getName();
                attrs = this.stat((String)remote);
            }
        }
        catch (SftpStatusException ex) {
            resume = false;
        }
        if (resume) {
            if (localPath.length() <= attrs.size().longValue()) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw new SftpStatusException(101, "The remote file size is greater than the local file");
            }
            try {
                position = attrs.size().longValue();
                in.skip(position);
            }
            catch (IOException ex) {
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new SftpStatusException(2, ex.getMessage());
            }
        }
        try {
            this.put(in, (String)remote, progress, position, length);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void append(String local, String remote) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        this.append(local, remote, null);
    }

    @Deprecated
    public void append(String local, String remote, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        this.append(local, remote, progress, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(String local, String remote, FileTransferProgress progress, long length) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        AbstractFile localPath = this.resolveLocalPath(local);
        String remotePath = this.resolveRemotePath(remote);
        this.stat(remotePath);
        InputStream in = localPath.getInputStream();
        try {
            this.append(in, remotePath, progress, length);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void put(String local, String remote, boolean resume) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        this.put(local, remote, null, resume);
    }

    public void put(String local, String remote) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException {
        this.put(local, remote, null, false);
    }

    public void put(InputStream in, String remote, FileTransferProgress progress) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(in, remote, progress, 0L, -1L);
    }

    @Deprecated
    public void put(InputStream in, String remote, FileTransferProgress progress, long position) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(in, remote, progress, position, -1L);
    }

    public void put(InputStream in, String remote, FileTransferProgress progress, long position, long length) throws SftpStatusException, SshException, TransferCancelledException {
        String remotePath = this.resolveRemotePath(remote);
        SftpFileAttributes.SftpFileAttributesBuilder attrs = null;
        if (this.transferMode == 2) {
            int inputStyle = this.stripEOL ? 4 : this.inputEOL;
            int outputStyle = this.outputEOL;
            byte[] nl = null;
            if (this.sftp.getVersion() <= 3 && this.sftp.getExtension("newline@vandyke.com") != null) {
                nl = this.sftp.getExtension("newline@vandyke.com");
            } else if (this.sftp.getVersion() > 3) {
                nl = this.sftp.getCanonicalNewline();
            }
            if (nl != null & !this.forceRemoteEOL) {
                outputStyle = this.getEOL(nl);
            }
            try {
                in = EOLProcessor.createInputStream((int)inputStyle, (int)outputStyle, (InputStream)in);
            }
            catch (IOException ex) {
                throw new SshException("Failed to create EOL processing stream", 5);
            }
        }
        attrs = SftpFileAttributes.SftpFileAttributesBuilder.ofType((int)1, (String)"UTF-8");
        if (this.applyUmask) {
            attrs.withPermissions(PosixPermissions.PosixPermissionsBuilder.create().fromBitmask((long)(0x1B6 ^ this.umask)).build());
        }
        try {
            if (position > 0L) {
                if (this.transferMode == 2 && this.sftp.getVersion() > 3) {
                    throw new SftpStatusException(8, "Resume on text mode files is not supported");
                }
                this.internalPut(length, in, remotePath, progress, position, 2, attrs.build());
            } else if (position == 0L) {
                if (this.transferMode == 2 && this.sftp.getVersion() > 3) {
                    this.internalPut(length, in, remotePath, progress, position, 90, attrs.build());
                } else {
                    this.internalPut(length, in, remotePath, progress, position, 26, attrs.build());
                }
            } else if (this.transferMode == 2 && this.sftp.getVersion() > 3) {
                this.internalPut(length, in, remotePath, progress, position, 70, attrs.build());
            } else {
                this.internalPut(length, in, remotePath, progress, position, 6, attrs.build());
            }
        }
        catch (IOException ioe) {
            throw new SshException((Throwable)ioe);
        }
    }

    private void internalPut(long length, InputStream in, String remotePath, FileTransferProgress progress, long position, int flags, SftpFileAttributes attrs) throws SftpStatusException, SshException, TransferCancelledException, IOException {
        try (SftpHandle handle = this.sftp.openFile(remotePath, flags, attrs);){
            if (progress != null) {
                progress.started(length, remotePath);
            }
            handle.performOptimizedWrite(remotePath, this.blocksize, this.asyncRequests, in, this.buffersize, progress, position < 0L ? 0L : position);
        }
        catch (SftpStatusException e) {
            Log.error((String)("SFTP status exception during transfer [" + e.getStatus() + "]"), (Throwable)e, (Object[])new Object[0]);
            throw e;
        }
        catch (SshException e) {
            Log.error((String)("SSH exception during transfer [" + e.getReason() + "]"), (Throwable)e, (Object[])new Object[0]);
            if (e.getCause() != null) {
                Log.error((String)"SSH exception cause", (Throwable)e.getCause(), (Object[])new Object[0]);
            }
            throw e;
        }
        catch (TransferCancelledException e) {
            Log.error((String)"Transfer cancelled", (Throwable)e, (Object[])new Object[0]);
            throw e;
        }
        finally {
            try {
                in.close();
            }
            catch (Throwable throwable) {}
        }
        if (progress != null) {
            progress.completed();
        }
    }

    public OutputStream getOutputStream(String remotefile) throws SftpStatusException, SshException {
        String remotePath = this.resolveRemotePath(remotefile);
        return new SftpFileOutputStream(this.sftp.openFile(remotePath, 26));
    }

    public void put(InputStream in, String remote, long position) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(in, remote, null, position, -1L);
    }

    public void put(InputStream in, String remote) throws SftpStatusException, SshException, TransferCancelledException {
        this.put(in, remote, null, 0L, -1L);
    }

    public void chown(String uid, String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        SftpFileAttributes attrs = this.sftp.getAttributes(actual);
        SftpFileAttributes.SftpFileAttributesBuilder newAttrs = SftpFileAttributes.SftpFileAttributesBuilder.ofType((int)attrs.type(), (String)this.sftp.getCharsetEncoding());
        newAttrs.withUidOrUsername(uid);
        if (this.sftp.getVersion() <= 3) {
            newAttrs.withGid(attrs.gid());
        }
        this.sftp.setAttributes(actual, newAttrs.build());
    }

    public void setAttributes(String path, SftpFileAttributes attrs) throws SftpStatusException, SshException {
        this.sftp.setAttributes(this.resolveRemotePath(path), attrs);
    }

    public void chown(String uid, String gid, String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        SftpFileAttributes attrs = this.sftp.getAttributes(actual);
        SftpFileAttributes.SftpFileAttributesBuilder newAttrs = SftpFileAttributes.SftpFileAttributesBuilder.ofType((int)attrs.type(), (String)this.sftp.getCharsetEncoding());
        newAttrs.withUidOrUsername(uid);
        newAttrs.withGidOrGroup(gid);
        this.sftp.setAttributes(actual, newAttrs.build());
    }

    public void chgrp(String gid, String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        SftpFileAttributes attrs = this.sftp.getAttributes(actual);
        SftpFileAttributes.SftpFileAttributesBuilder newAttrs = SftpFileAttributes.SftpFileAttributesBuilder.ofType((int)attrs.type(), (String)this.sftp.getCharsetEncoding());
        newAttrs.withGidOrGroup(gid);
        if (this.sftp.getVersion() <= 3) {
            newAttrs.withUid(attrs.uid());
        }
        this.sftp.setAttributes(actual, newAttrs.build());
    }

    public void chmod(PosixPermissions permissions, String path) throws SftpStatusException, SshException {
        this.chmod(permissions.asInt(), path);
    }

    @Deprecated(since="3.1.0")
    public void chmod(int permissions, String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        this.sftp.changePermissions(actual, permissions);
    }

    public void umask(String umask) throws SshException {
        try {
            this.umask = Integer.parseInt(umask, 8);
            this.applyUmask = true;
        }
        catch (NumberFormatException ex) {
            throw new SshException("umask must be 4 digit octal number e.g. 0022", 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String oldpath, String newpath, boolean posix) throws IOException, SftpStatusException, SshException {
        if (posix) {
            try (ByteArrayWriter msg = new ByteArrayWriter();){
                msg.writeString(this.resolveRemotePath(oldpath));
                msg.writeString(this.resolveRemotePath(newpath));
                this.sftp.getOKRequestStatus(this.sftp.sendExtensionMessage("posix-rename@openssh.com", msg.toByteArray()), newpath);
            }
        } else {
            this.rename(oldpath, newpath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyRemoteFile(String sourceFile, String destinationFile, boolean overwriteDestination) throws SftpStatusException, SshException, IOException {
        try (ByteArrayWriter msg = new ByteArrayWriter();){
            msg.writeString(this.resolveRemotePath(sourceFile));
            msg.writeString(this.resolveRemotePath(destinationFile));
            msg.writeBoolean(overwriteDestination);
            this.sftp.getOKRequestStatus(this.sftp.sendExtensionMessage("copy-file", msg.toByteArray()), destinationFile);
        }
    }

    public void rename(String oldpath, String newpath) throws SftpStatusException, SshException {
        String from = this.resolveRemotePath(oldpath);
        String to = this.resolveRemotePath(newpath);
        SftpFileAttributes attrs = null;
        try {
            attrs = this.sftp.getAttributes(to);
        }
        catch (SftpStatusException ex) {
            this.sftp.renameFile(from, to);
            return;
        }
        if (attrs == null || !attrs.isDirectory()) {
            throw new SftpStatusException(11, newpath + " already exists on the remote filesystem");
        }
        this.sftp.renameFile(from, FileUtils.checkEndsWithSlash((String)to) + FileUtils.lastPathElement((String)from));
    }

    public void rm(String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        try {
            SftpFileAttributes attrs = this.sftp.getAttributes(actual);
            if (attrs.isDirectory()) {
                this.sftp.removeDirectory(actual);
            } else {
                this.sftp.removeFile(actual);
            }
        }
        catch (SftpStatusException sse) {
            if (sse.getStatus() == 2) {
                try {
                    SftpFileAttributes linkAttrs = this.statLink(path);
                    if (!linkAttrs.isLink()) {
                        throw sse;
                    }
                    this.sftp.removeFile(actual);
                }
                catch (SftpStatusException sse2) {
                    throw sse;
                }
            }
            throw sse;
        }
    }

    public void rm(String path, boolean force, boolean recurse) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        SftpFileAttributes attrs = this.sftp.getAttributes(actual);
        if (attrs.isDirectory()) {
            SftpFile[] list = this.ls(path);
            if (!force && list.length > 0) {
                throw new SftpStatusException(4, "You cannot delete non-empty directory, use force=true to overide");
            }
            for (int i = 0; i < list.length; ++i) {
                SftpFile file = list[i];
                if (file.attributes().isDirectory() && !file.getFilename().equals(".") && !file.getFilename().equals("..")) {
                    if (recurse) {
                        this.rm(file.getAbsolutePath(), force, recurse);
                        continue;
                    }
                    throw new SftpStatusException(4, "Directory has contents, cannot delete without recurse=true");
                }
                if (!file.attributes().isFile() && !file.attributes().isLink()) continue;
                this.sftp.removeFile(file.getAbsolutePath());
            }
            this.sftp.removeDirectory(actual);
        } else {
            this.sftp.removeFile(actual);
        }
    }

    public void rmdir(String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        SftpFileAttributes attrs = this.sftp.getAttributes(actual);
        if (!attrs.isDirectory()) {
            throw new SftpStatusException(19, "File is not a directory");
        }
        this.sftp.removeDirectory(actual);
    }

    public void symlink(String path, String link) throws SftpStatusException, SshException {
        this.relativeSymlink(this.resolveRemotePath(path), link);
    }

    public void relativeSymlink(String path, String link) throws SftpStatusException, SshException {
        String actualLink = this.resolveRemotePath(link);
        this.sftp.createSymbolicLink(actualLink, path);
    }

    public SftpFileAttributes stat(String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        return this.sftp.getAttributes(actual);
    }

    public SftpFileAttributes statLink(String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        return this.sftp.getLinkAttributes(actual);
    }

    public String getAbsolutePath(String path) throws SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        return this.sftp.getAbsolutePath(actual);
    }

    public boolean verifyFiles(String localFile, String remoteFile) throws SftpStatusException, SshException, IOException, PermissionDeniedException {
        return this.verifyFiles(localFile, remoteFile, 0L, 0L);
    }

    public boolean verifyFiles(String localFile, String remoteFile, RemoteHash algorithm) throws SftpStatusException, SshException, IOException, PermissionDeniedException {
        return this.verifyFiles(localFile, remoteFile, 0L, 0L, algorithm);
    }

    public boolean verifyFiles(String localFile, String remoteFile, long offset, long length) throws SftpStatusException, SshException, IOException, PermissionDeniedException {
        return this.verifyFiles(localFile, remoteFile, offset, length, RemoteHash.md5);
    }

    public boolean verifyFiles(String localFile, String remoteFile, long offset, long length, RemoteHash algorithm) throws SftpStatusException, SshException, IOException, PermissionDeniedException {
        AbstractFile local = this.resolveLocalPath(localFile);
        if (!local.exists()) {
            throw new IOException("Local file " + localFile + " does not exist!");
        }
        try {
            MessageDigest md = null;
            switch (algorithm) {
                case md5: {
                    md = MessageDigest.getInstance("MD5");
                    break;
                }
                case sha1: {
                    md = MessageDigest.getInstance("SHA-1");
                    break;
                }
                case sha256: {
                    md = MessageDigest.getInstance("SHA-256");
                    break;
                }
                case sha512: {
                    md = MessageDigest.getInstance("SHA-512");
                }
            }
            byte[] remoteHash = this.getRemoteHash(remoteFile, offset, length, algorithm);
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Remote hash for {} is {}", (Object[])new Object[]{remoteFile, Utils.bytesToHex((byte[])remoteHash)});
            }
            try (DigestInputStream dis = new DigestInputStream(local.getInputStream(), md);){
                if (offset > 0L) {
                    dis.skip(offset);
                }
                if (length > 0L) {
                    IOUtils.copy((InputStream)dis, (OutputStream)OutputStream.nullOutputStream(), (long)length);
                } else {
                    IOUtils.copy((InputStream)dis, (OutputStream)OutputStream.nullOutputStream());
                }
            }
            byte[] localHash = md.digest();
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Local hash for {} is {}", (Object[])new Object[]{localFile, Utils.bytesToHex((byte[])localHash)});
            }
            return Arrays.equals(remoteHash, localHash);
        }
        catch (NoSuchAlgorithmException e1) {
            throw new SshException(5, (Throwable)e1);
        }
        catch (IOException e1) {
            throw new SshException(5, (Throwable)e1);
        }
    }

    @Deprecated
    public byte[] getRemoteHash(String remoteFile) throws IOException, SftpStatusException, SshException {
        return this.getRemoteHash(remoteFile, 0L, 0L, new byte[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public byte[] getRemoteHash(String remoteFile, long offset, long length, byte[] quickCheck) throws IOException, SftpStatusException, SshException {
        try (ByteArrayWriter msg = new ByteArrayWriter();){
            msg.writeString(this.resolveRemotePath(remoteFile));
            msg.writeUINT64(offset);
            msg.writeUINT64(length);
            msg.writeBinaryString(quickCheck);
            SftpMessage resp = this.sftp.getExtensionResponse(this.sftp.sendExtensionMessage("md5-hash", msg.toByteArray()), remoteFile);
            resp.readString();
            byte[] byArray = resp.readBinaryString();
            return byArray;
        }
    }

    @Deprecated
    public byte[] getRemoteHash(byte[] handle) throws IOException, SftpStatusException, SshException {
        return this.getRemoteHash(handle, 0L, 0L, new byte[0]);
    }

    @Deprecated
    public byte[] getRemoteHash(byte[] handle, long offset, long length, byte[] quickCheck) throws IOException, SftpStatusException, SshException {
        return this.doMD5HashHandle(handle, offset, length, quickCheck);
    }

    public byte[] getRemoteHash(byte[] handle, RemoteHash algorithm) throws IOException, SftpStatusException, SshException {
        return this.getRemoteHash(handle, 0L, 0L, algorithm);
    }

    public byte[] getRemoteHash(byte[] handle, long offset, long length, RemoteHash algorithm) throws IOException, SftpStatusException, SshException {
        return this.doCheckHashHandle(handle, offset, length, algorithm);
    }

    public byte[] getRemoteHash(String path, RemoteHash algorithm) throws IOException, SftpStatusException, SshException {
        return this.getRemoteHash(path, 0L, 0L, algorithm);
    }

    public byte[] getRemoteHash(String path, long offset, long length, RemoteHash algorithm) throws IOException, SftpStatusException, SshException {
        String actual = this.resolveRemotePath(path);
        return this.doCheckFileHandle(actual, offset, length, algorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doCheckHashHandle(byte[] handle, long offset, long length, RemoteHash algorithm) throws IOException, SftpStatusException, SshException {
        try (ByteArrayWriter msg = new ByteArrayWriter();){
            msg.writeBinaryString(handle);
            msg.writeString(algorithm.name());
            msg.writeUINT64(offset);
            msg.writeUINT64(length);
            msg.writeInt(0L);
            SftpHandle h = this.sftp.getBestHandle(handle);
            byte[] byArray = this.processCheckFileResponse(this.sftp.getExtensionResponse(this.sftp.sendExtensionMessage("check-file-handle", msg.toByteArray()), h.getFile().getAbsolutePath()), algorithm);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doCheckFileHandle(String path, long offset, long length, RemoteHash algorithm) throws IOException, SftpStatusException, SshException {
        try (ByteArrayWriter msg = new ByteArrayWriter();){
            msg.writeString(path);
            msg.writeString(algorithm.name());
            msg.writeUINT64(offset);
            msg.writeUINT64(length);
            msg.writeInt(0L);
            byte[] byArray = this.processCheckFileResponse(this.sftp.getExtensionResponse(this.sftp.sendExtensionMessage("check-file-name", msg.toByteArray()), path), algorithm);
            return byArray;
        }
    }

    protected byte[] processCheckFileResponse(SftpMessage resp, RemoteHash algorithm) throws IOException {
        int hashLength;
        String processedAlgorithm = resp.readString();
        if (!processedAlgorithm.equals(algorithm.name())) {
            throw new IOException("Remote server returned a hash in an unsupported algorithm");
        }
        switch (algorithm) {
            case md5: {
                hashLength = 16;
                break;
            }
            case sha1: {
                hashLength = 20;
                break;
            }
            case sha256: {
                hashLength = 32;
                break;
            }
            case sha512: {
                hashLength = 64;
                break;
            }
            default: {
                throw new IOException("Unsupported hash algorihm " + processedAlgorithm);
            }
        }
        byte[] hash = new byte[hashLength];
        if (resp.available() < hash.length) {
            throw new IOException("Unexpected hash length returned by remote server");
        }
        resp.readFully(hash);
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doMD5HashHandle(byte[] handle, long offset, long length, byte[] quickCheck) throws IOException, SftpStatusException, SshException {
        try (ByteArrayWriter msg = new ByteArrayWriter();){
            msg.writeBinaryString(handle);
            msg.writeUINT64(offset);
            msg.writeUINT64(length);
            msg.writeBinaryString(quickCheck);
            SftpHandle h = this.sftp.getBestHandle(handle);
            SftpMessage resp = this.sftp.getExtensionResponse(this.sftp.sendExtensionMessage("md5-hash-handle", msg.toByteArray()), h.getFile().getAbsolutePath());
            resp.readString();
            byte[] byArray = resp.readBinaryString();
            return byArray;
        }
    }

    public void quit() throws SshException {
        this.sftp.close();
    }

    public void exit() throws SshException {
        this.sftp.close();
    }

    public DirectoryOperation putLocalDirectory(String localdir, String remotedir, boolean recurse, boolean sync, boolean commit, FileTransferProgress progress) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        AbstractFile[] sources;
        DirectoryOperation op = new DirectoryOperation();
        AbstractFile local = this.resolveLocalPath(localdir);
        remotedir = (String)remotedir + (((String)(remotedir = this.resolveRemotePath((String)remotedir))).endsWith("/") ? "" : "/");
        if (commit) {
            try {
                this.sftp.getAttributes((String)remotedir);
            }
            catch (SftpStatusException ex) {
                this.mkdirs((String)remotedir);
            }
        }
        for (AbstractFile source : sources = this.listFiles(local)) {
            SftpFileAttributes attrs;
            if (source.isDirectory() && !source.getName().equals(".") && !source.getName().equals("..")) {
                if (!recurse) continue;
                op.addDirectoryOperation(this.putLocalDirectory(source.getAbsolutePath(), (String)remotedir + source.getName(), recurse, sync, commit, progress), source);
                continue;
            }
            if (!source.isFile()) continue;
            boolean newFile = false;
            boolean unchangedFile = false;
            try {
                attrs = this.sftp.getAttributes((String)remotedir + source.getName());
                unchangedFile = source.length() == attrs.size().longValue() && source.lastModified() / 1000L == attrs.lastModifiedTime().toMillis();
                System.out.println(source.getName() + " is " + (unchangedFile ? "unchanged" : "changed"));
            }
            catch (SftpStatusException ex) {
                System.out.println(source.getName() + " is new");
                newFile = true;
            }
            try {
                if (commit && !unchangedFile) {
                    this.put(source.getAbsolutePath(), (String)remotedir + source.getName(), progress);
                    attrs = SftpFileAttributes.SftpFileAttributesBuilder.createWith((SftpFileAttributes)this.sftp.getAttributes((String)remotedir + source.getName()));
                    attrs.withLastModifiedTime(source.lastModified() / 1000L);
                    this.sftp.setAttributes((String)remotedir + source.getName(), attrs.build());
                }
                if (unchangedFile) {
                    op.addUnchangedFile(source);
                    continue;
                }
                if (!newFile) {
                    op.addUpdatedFile(source);
                    continue;
                }
                op.addNewFile(source);
            }
            catch (SftpStatusException ex) {
                op.addFailedTransfer(source, ex);
            }
        }
        if (sync) {
            try {
                SftpFile[] files = this.ls((String)remotedir);
                for (int i = 0; i < files.length; ++i) {
                    SftpFile file = files[i];
                    AbstractFile f = local.resolveFile(file.getFilename());
                    if (op.containsFile(f) || file.getFilename().equals(".") || file.getFilename().equals("..")) continue;
                    op.addDeletedFile(file);
                    if (!commit) continue;
                    if (file.attributes().isDirectory()) {
                        this.recurseMarkForDeletion(file, op);
                        if (!commit) continue;
                        this.rm(file.getAbsolutePath(), true, true);
                        continue;
                    }
                    if (!file.attributes().isFile()) continue;
                    this.rm(file.getAbsolutePath());
                }
            }
            catch (SftpStatusException sftpStatusException) {
                // empty catch block
            }
        }
        return op;
    }

    private String[] getChildNames(AbstractFile local) throws IOException, PermissionDeniedException {
        ArrayList<String> children = new ArrayList<String>();
        for (AbstractFile child : local.getChildren()) {
            children.add(child.getName());
        }
        return children.toArray(new String[0]);
    }

    private void recurseMarkForDeletion(SftpFile file, DirectoryOperation op) throws SftpStatusException, SshException {
        SftpFile[] list = this.ls(file.getAbsolutePath());
        op.addDeletedFile(file);
        for (int i = 0; i < list.length; ++i) {
            file = list[i];
            if (file.attributes().isDirectory() && !file.getFilename().equals(".") && !file.getFilename().equals("..")) {
                this.recurseMarkForDeletion(file, op);
                continue;
            }
            if (!file.attributes().isFile()) continue;
            op.addDeletedFile(file);
        }
    }

    private void recurseMarkForDeletion(AbstractFile file, DirectoryOperation op) throws SftpStatusException, SshException, IOException, PermissionDeniedException {
        String[] list = this.getChildNames(file);
        op.addDeletedFile(file);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                if ((file = file.resolveFile(list[i])).isDirectory() && !file.getName().equals(".") && !file.getName().equals("..")) {
                    this.recurseMarkForDeletion(file, op);
                    continue;
                }
                if (!file.isFile()) continue;
                op.addDeletedFile(file);
            }
        }
    }

    public static String formatLongname(SftpFile file) throws SftpStatusException, SshException {
        return SftpClient.formatLongname(file.attributes(), file.getFilename());
    }

    public static String formatLongname(SftpFileAttributes attrs, String filename) {
        return String.format("%9s %d %-9s %-9s %10d %12s %s", attrs.toPermissionsString(), attrs.linkCount(), attrs.bestUsername(), attrs.bestGroup(), attrs.size().longValue(), SftpClient.getModTimeString(attrs.lastModifiedTime()), filename);
    }

    private static String getModTimeString(FileTime mtime) {
        if (mtime == null) {
            return "";
        }
        long mt = mtime.toMillis();
        long now = System.currentTimeMillis();
        SimpleDateFormat df = now - mt > 15552000000L ? new SimpleDateFormat("MMM dd  yyyy") : new SimpleDateFormat("MMM dd hh:mm");
        return df.format(new Date(mt));
    }

    public DirectoryOperation getRemoteDirectory(String remotedir, String localdir, boolean recurse, boolean sync, boolean commit, FileTransferProgress progress) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        String[] contents;
        AbstractFile local;
        int idx;
        DirectoryOperation op = new DirectoryOperation();
        String pwd = this.pwd();
        this.cd(remotedir);
        String base = remotedir;
        if (base.endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        if ((idx = base.lastIndexOf(47)) != -1) {
            base = base.substring(idx + 1);
        }
        if (!(local = this.resolveLocalPath(localdir)).exists() && commit) {
            local.createFolder();
        }
        SftpFile[] files = this.ls();
        for (int i = 0; i < files.length; ++i) {
            AbstractFile f;
            SftpFile file = files[i];
            if (file.attributes().isDirectory() && !file.getFilename().equals(".") && !file.getFilename().equals("..")) {
                if (!recurse) continue;
                f = local.resolveFile(file.getFilename());
                op.addDirectoryOperation(this.getRemoteDirectory(file.getFilename(), local.getAbsolutePath() + "/" + file.getFilename(), recurse, sync, commit, progress), f);
                continue;
            }
            if (!file.attributes().isFile()) continue;
            f = local.resolveFile(file.getFilename());
            if (f.exists() && f.length() == file.attributes().size().longValue() && f.lastModified() / 1000L == file.attributes().lastModifiedTime().toMillis()) {
                if (commit) {
                    op.addUnchangedFile(f);
                    continue;
                }
                op.addUnchangedFile(file);
                continue;
            }
            try {
                if (f.exists()) {
                    if (commit) {
                        op.addUpdatedFile(f);
                    } else {
                        op.addUpdatedFile(file);
                    }
                } else if (commit) {
                    op.addNewFile(f);
                } else {
                    op.addNewFile(file);
                }
                if (!commit) continue;
                this.get(file.getFilename(), f.getAbsolutePath(), progress);
                continue;
            }
            catch (SftpStatusException ex) {
                op.addFailedTransfer(f, ex);
            }
        }
        if (sync && (contents = this.getChildNames(local)) != null) {
            for (int i = 0; i < contents.length; ++i) {
                AbstractFile f2 = local.resolveFile(contents[i]);
                if (op.containsFile(f2)) continue;
                op.addDeletedFile(f2);
                if (f2.isDirectory() && !f2.getName().equals(".") && !f2.getName().equals("..")) {
                    this.recurseMarkForDeletion(f2, op);
                    if (!commit) continue;
                    f2.delete(true);
                    continue;
                }
                if (!commit) continue;
                f2.delete(false);
            }
        }
        this.cd(pwd);
        return op;
    }

    public SftpFile[] getFiles(String remote) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        return this.getFiles(remote, (FileTransferProgress)null);
    }

    public SftpFile[] getFiles(String remote, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        return this.getFiles(remote, (FileTransferProgress)null, resume);
    }

    public SftpFile[] getFiles(String remote, FileTransferProgress progress) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        return this.getFiles(remote, progress, false);
    }

    public SftpFile[] getFiles(String remote, FileTransferProgress progress, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        return this.getFiles(remote, this.lcwd.getAbsolutePath(), progress, resume);
    }

    public SftpFile[] getFiles(String remote, String local) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        return this.getFiles(remote, local, false);
    }

    public SftpFile[] getFiles(String remote, String local, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        return this.getFiles(remote, local, null, resume);
    }

    public SftpFile[] getFiles(String remote, String local, FileTransferProgress progress, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        return this.getFileMatches(remote, local, progress, resume);
    }

    public void putFiles(String local) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        this.putFiles(local, false);
    }

    public void putFiles(String local, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        this.putFiles(local, (FileTransferProgress)null, resume);
    }

    public void putFiles(String local, FileTransferProgress progress) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        this.putFiles(local, progress, false);
    }

    public void putFiles(String local, FileTransferProgress progress, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        this.putFiles(local, this.pwd(), progress, resume);
    }

    public void putFiles(String local, String remote) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        this.putFiles(local, remote, null, false);
    }

    public void putFiles(String local, String remote, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        this.putFiles(local, remote, null, resume);
    }

    public void putFiles(String local, String remote, FileTransferProgress progress) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        this.putFiles(local, remote, progress, false);
    }

    public void putFiles(String local, String remote, FileTransferProgress progress, boolean resume) throws IOException, SftpStatusException, SshException, TransferCancelledException, PermissionDeniedException {
        this.putFileMatches(local, remote, progress, resume);
    }

    public boolean isConnected() {
        return this.sftp.isClosed();
    }

    public void hardlink(String src, String dst) throws SshException, SftpStatusException {
        try (ByteArrayWriter msg = new ByteArrayWriter();){
            msg.writeString(src);
            msg.writeString(dst);
            SftpChannel channel = this.getSubsystemChannel();
            UnsignedInteger32 requestId = channel.sendExtensionMessage("hardlink@openssh.com", msg.toByteArray());
            channel.getOKRequestStatus(requestId, dst);
        }
        catch (IOException e) {
            throw new SshException((Throwable)e);
        }
    }

    public String getHomeDirectory(String username) throws SshException, SftpStatusException {
        String string;
        ByteArrayWriter msg = new ByteArrayWriter();
        try {
            msg.writeString(username);
            SftpChannel channel = this.getSubsystemChannel();
            UnsignedInteger32 requestId = channel.sendExtensionMessage("home-directory", msg.toByteArray());
            string = channel.getSingleFileResponse(channel.getResponse(requestId), "SSH_FXP_NAME", "<username>", requestId).getAbsolutePath();
        }
        catch (Throwable throwable) {
            try {
                try {
                    msg.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SshException((Throwable)e);
            }
        }
        msg.close();
        return string;
    }

    public String makeTemporaryFolder() throws SshException, SftpStatusException {
        SftpChannel channel = this.getSubsystemChannel();
        UnsignedInteger32 requestId = channel.sendExtensionMessage("make-temp-folder", null);
        return channel.getSingleFileResponse(channel.getResponse(requestId), "SSH_FXP_NAME", "<make-tmp-folder>", requestId).getAbsolutePath();
    }

    public String getTemporaryFolder() throws SshException, SftpStatusException {
        SftpChannel channel = this.getSubsystemChannel();
        UnsignedInteger32 requestId = channel.sendExtensionMessage("get-temp-folder", null);
        return channel.getSingleFileResponse(channel.getResponse(requestId), "SSH_FXP_NAME", "<get-temp-folder>", requestId).getAbsolutePath();
    }

    public StatVfs statVFS(String path) throws SshException, SftpStatusException {
        StatVfs statVfs;
        ByteArrayWriter msg = new ByteArrayWriter();
        try {
            msg.writeString(path);
            SftpChannel channel = this.getSubsystemChannel();
            UnsignedInteger32 requestId = channel.sendExtensionMessage("statvfs@openssh.com", msg.toByteArray());
            SftpMessage response = channel.getResponse(requestId);
            if (response.getType() == 101) {
                this.sftp.processStatusResponse(response, path, requestId);
                throw new IllegalStateException("Received unexpected SSH_FX_OK in status response!");
            }
            statVfs = new StatVfs(response);
        }
        catch (Throwable throwable) {
            try {
                try {
                    msg.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new SshException((Throwable)e);
            }
        }
        msg.close();
        return statVfs;
    }

    public String getHome() throws SftpStatusException, SshException {
        return this.getAbsolutePath("");
    }

    @Override
    public void close() throws IOException {
        try {
            this.quit();
        }
        catch (SshException e) {
            throw new SshIOException(e);
        }
    }

    public FileVisitResult visit(String path, FileVisitor<SftpFile> visitor) throws SshException, SftpStatusException {
        block15: {
            SftpFileAttributes attrs = this.stat(path);
            SftpFile file = new SftpFile(path, attrs, null);
            try {
                if (attrs.isDirectory()) {
                    FileVisitResult preVisitResult = visitor.preVisitDirectory(file, this.fileToBasicAttributes(file));
                    try {
                        if (preVisitResult != FileVisitResult.CONTINUE) {
                            return preVisitResult;
                        }
                        block8: for (SftpFile child : this.ls(path)) {
                            if (child.attributes().isLink() || child.attributes().isFile()) {
                                FileVisitResult fileVisitResult = visitor.visitFile(child, this.fileToBasicAttributes(child));
                                if (fileVisitResult == FileVisitResult.CONTINUE || fileVisitResult == FileVisitResult.SKIP_SUBTREE) continue;
                                return fileVisitResult;
                            }
                            if (!child.attributes().isDirectory() || child.getFilename().equals(".") || child.getFilename().equals("..")) continue;
                            switch (this.visit(child.getAbsolutePath(), visitor)) {
                                case SKIP_SIBLINGS: {
                                    continue block8;
                                }
                                case TERMINATE: {
                                    return FileVisitResult.TERMINATE;
                                }
                                default: {
                                    continue block8;
                                }
                            }
                        }
                        FileVisitResult postVisitResult = visitor.postVisitDirectory(file, null);
                        if (postVisitResult != FileVisitResult.CONTINUE && postVisitResult != FileVisitResult.SKIP_SUBTREE) {
                            return postVisitResult;
                        }
                        break block15;
                    }
                    catch (SftpStatusException ioe) {
                        FileVisitResult postVisitResult = visitor.postVisitDirectory(file, new IOException(ioe));
                        if (postVisitResult != FileVisitResult.CONTINUE && postVisitResult != FileVisitResult.SKIP_SUBTREE) {
                            return postVisitResult;
                        }
                        break block15;
                    }
                }
                FileVisitResult fileVisitResult = visitor.visitFile(file, this.fileToBasicAttributes(file));
                if (fileVisitResult != FileVisitResult.CONTINUE && fileVisitResult != FileVisitResult.SKIP_SUBTREE) {
                    return fileVisitResult;
                }
            }
            catch (IOException ioe) {
                throw new SshException((Throwable)ioe);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    private BasicFileAttributes fileToBasicAttributes(SftpFile file) {
        final SftpFileAttributes attrs = this.checkAttributes(file);
        return new BasicFileAttributes(){

            @Override
            public FileTime creationTime() {
                return attrs.createTimeOr().orElse(FileTime.fromMillis(0L));
            }

            @Override
            public Object fileKey() {
                return attrs;
            }

            @Override
            public boolean isDirectory() {
                return attrs.isDirectory();
            }

            @Override
            public boolean isOther() {
                return !attrs.isDirectory() && !attrs.isFile() && !attrs.isLink();
            }

            @Override
            public boolean isRegularFile() {
                return attrs.isFile();
            }

            @Override
            public boolean isSymbolicLink() {
                return attrs.isLink();
            }

            @Override
            public FileTime lastAccessTime() {
                return attrs.lastAccessTime();
            }

            @Override
            public FileTime lastModifiedTime() {
                return attrs.lastModifiedTime();
            }

            @Override
            public long size() {
                return attrs.size().longValue();
            }
        };
    }

    private SftpFileAttributes checkAttributes(SftpFile file) {
        return file.attributes();
    }

    public static final class SftpClientBuilder {
        private Optional<SshConnection> connection = Optional.empty();
        private Optional<AbstractFileFactory<?>> fileFactory = Optional.empty();
        private Optional<Integer> blockSize = Optional.empty();
        private Optional<Integer> asyncRequests = Optional.empty();
        private int bufferSize = 1024000;
        private Optional<Path> localHome = Optional.empty();
        private boolean localHomeSandbox;
        private Set<String> customRoots = new LinkedHashSet<String>();
        private Optional<String> localPath = Optional.empty();
        private Optional<String> remotePath = Optional.empty();
        private Optional<String> charset = Optional.empty();

        public static SftpClientBuilder create() {
            return new SftpClientBuilder();
        }

        public SftpClientBuilder withCustomRoots(String ... rootPaths) {
            this.customRoots.addAll(Arrays.asList(rootPaths));
            return this;
        }

        public SftpClientBuilder withCharset(String charset) {
            this.charset = Optional.of(charset);
            return this;
        }

        public SftpClientBuilder withConnection(SshConnection connection) {
            if (connection.isConnected() && !connection.isDisconnecting()) {
                this.connection = Optional.of(connection);
                return this;
            }
            throw new IllegalStateException("Not connected.");
        }

        public SftpClientBuilder withClient(SshClient client) {
            return this.withConnection((SshConnection)client.getConnection());
        }

        public SftpClientBuilder withFileFactory(AbstractFileFactory<?> fileFactory) {
            this.fileFactory = Optional.of(fileFactory);
            return this;
        }

        public SftpClientBuilder withLocalHomeSandbox(boolean localHomeSandbox) {
            this.localHomeSandbox = localHomeSandbox;
            return this;
        }

        public SftpClientBuilder withWithoutLocalHomeSandbox() {
            return this.withLocalHomeSandbox(false);
        }

        public SftpClientBuilder withRemotePath(String remotePath) {
            this.remotePath = Optional.of(remotePath);
            return this;
        }

        public SftpClientBuilder withLocalPath(String localPath) {
            this.localPath = Optional.of(localPath);
            return this;
        }

        public SftpClientBuilder withLocalHome(Path localHome) {
            this.localHome = Optional.of(localHome);
            return this;
        }

        public SftpClientBuilder withLocalHome(File localRoot) {
            return this.withLocalHome(localRoot.toPath());
        }

        public SftpClientBuilder withBlockSize(int blockSize) {
            this.blockSize = blockSize == -1 ? Optional.empty() : Optional.of(blockSize);
            return this;
        }

        public SftpClientBuilder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public SftpClientBuilder withAsyncRequests(int asyncRequests) {
            this.asyncRequests = asyncRequests == -1 ? Optional.empty() : Optional.of(asyncRequests);
            return this;
        }

        public SftpClient build() throws SshException, PermissionDeniedException, IOException {
            return new SftpClient(this);
        }
    }

    class DirectoryIterator
    implements Iterator<SftpFile> {
        SftpHandle currentFolder;
        Vector<SftpFile> currentPage = new Vector();
        Iterator<SftpFile> currentIterator;

        DirectoryIterator(String path) throws SftpStatusException, SshException {
            String actual = SftpClient.this.resolveRemotePath(path);
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Listing files for " + actual), (Object[])new Object[0]);
            }
            this.currentFolder = SftpClient.this.sftp.openDirectory(actual);
            try {
                this.getNextPage();
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }

        private void getNextPage() throws SftpStatusException, SshException, EOFException {
            this.currentPage.clear();
            int ret = this.currentFolder.listChildren(this.currentPage);
            if (ret == -1) {
                this.currentIterator = null;
                throw new EOFException();
            }
            this.currentIterator = this.currentPage.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.currentIterator != null && this.currentIterator.hasNext();
        }

        @Override
        public SftpFile next() {
            if (this.currentIterator == null) {
                throw new NoSuchElementException();
            }
            SftpFile ret = null;
            if (this.currentIterator.hasNext()) {
                ret = this.currentIterator.next();
            }
            if (!this.currentIterator.hasNext()) {
                try {
                    this.getNextPage();
                }
                catch (EOFException e) {
                    if (ret == null) {
                        throw new NoSuchElementException();
                    }
                }
                catch (SftpStatusException | SshException e) {
                    throw new NoSuchElementException(e.getMessage());
                }
                if (ret == null) {
                    ret = this.currentIterator.next();
                }
            }
            return ret;
        }
    }

    static class RandomAccessFileOutputStream
    extends OutputStream {
        RandomAccessFile file;

        RandomAccessFileOutputStream(RandomAccessFile file) {
            this.file = file;
        }

        @Override
        public void write(int b) throws IOException {
            this.file.write(b);
        }

        @Override
        public void write(byte[] buf, int off, int len) throws IOException {
            this.file.write(buf, off, len);
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }
    }
}

