/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.nio.ssl;

import com.sshtools.common.logger.Log;
import com.sshtools.common.util.Utils;
import com.sshtools.synergy.nio.SelectorThread;
import com.sshtools.synergy.nio.SocketConnection;
import com.sshtools.synergy.nio.SocketWriteCallback;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.KeyStore;
import java.util.Iterator;
import java.util.LinkedList;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;

public class SSLContextConnection
extends SocketConnection {
    static SSLContext sslContext = null;
    private SSLSession session;
    private SSLEngine engine;
    private ByteBuffer dummy;
    private SSLEngineResult.HandshakeStatus hsStatus;
    private SSLEngineResult.Status status;
    private boolean initialHandshake;
    private boolean wantsWrite = false;
    ByteBuffer sourceBuffer;
    ByteBuffer destinationBuffer;
    LinkedList<SocketWriteCallback> socketWriteCallbacks = new LinkedList();
    boolean requireClientCertificate;
    boolean allowClientCertificate;

    public SSLContextConnection() {
        this(true, false);
    }

    public SSLContextConnection(boolean allowClientCertificate, boolean requireClientCertificate) {
        this.allowClientCertificate = allowClientCertificate;
        this.requireClientCertificate = requireClientCertificate;
    }

    @Override
    public void registrationCompleted(SelectableChannel channel, SelectionKey key, SelectorThread selectorThread) {
        this.socketChannel = (SocketChannel)channel;
        this.selectorThread = selectorThread;
        this.key = key;
        try {
            this.engine = SSLContextConnection.getSSLContext().createSSLEngine();
            this.engine.setUseClientMode(false);
            this.engine.setWantClientAuth(this.allowClientCertificate);
            this.engine.setNeedClientAuth(this.requireClientCertificate);
            this.session = this.engine.getSession();
            this.engine.beginHandshake();
            this.hsStatus = this.engine.getHandshakeStatus();
            this.initialHandshake = true;
            this.dummy = ByteBuffer.allocate(0);
            this.wantsWrite = true;
        }
        catch (Exception ex) {
            this.closeConnection();
        }
    }

    public static SSLContext getSSLContext() throws IOException {
        if (sslContext != null) {
            return sslContext;
        }
        SSLContextConnection.initializeSSL();
        return sslContext;
    }

    public static void initializeSSL() throws FileNotFoundException, IOException {
        try {
            String password = System.getProperty("javax.net.ssl.keyStorePassword");
            if (password == null) {
                password = "";
            }
            char[] passphrase = password.toCharArray();
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(System.getProperty("javax.net.ssl.keyStore", "")), passphrase);
            sslContext = SSLContext.getInstance("TLS");
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, passphrase);
            password = System.getProperty("javax.net.ssl.trustStorePassword");
            if (password == null) {
                password = "";
            }
            passphrase = password.toCharArray();
            TrustManagerFactory tmf = null;
            String trustStore = System.getProperty("javax.net.ssl.trustStore", "");
            if (Utils.isNotBlank((String)trustStore)) {
                KeyStore tm = KeyStore.getInstance("JKS");
                tm.load(new FileInputStream(trustStore), passphrase);
                tmf = TrustManagerFactory.getInstance("SunX509");
                tmf.init(tm);
            }
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf != null ? tmf.getTrustManagers() : null, null);
        }
        catch (Exception ex) {
            throw new IOException("SSL initialization failed: " + ex.getMessage());
        }
    }

    @Override
    public boolean isConnected() {
        if (this.initialHandshake) {
            return this.socketChannel.isOpen();
        }
        return super.isConnected();
    }

    private void shutdown() throws SSLException {
        this.engine.closeInbound();
        this.engine.closeOutbound();
        this.closeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processReadEvent() {
        boolean bl;
        try {
            if (!this.isConnected()) {
                boolean bl2 = true;
                return bl2;
            }
            if (this.socketDataIn == null) {
                this.socketDataIn = this.daemonContext.getBufferPool().get();
            }
            int numBytesRead = this.socketChannel.read(this.socketDataIn);
            this.socketDataIn.flip();
            if (numBytesRead == -1) {
                this.shutdown();
                boolean bl3 = true;
                return bl3;
            }
            if (numBytesRead > 0) {
                if (this.destinationBuffer == null) {
                    this.destinationBuffer = this.daemon.getContext().getBufferPool().get();
                }
                int currentDestinationPos = this.destinationBuffer.position();
                int remaining = this.socketDataIn.remaining();
                int noUnwrap = 0;
                while (true) {
                    SSLEngineResult res = this.engine.unwrap(this.socketDataIn, this.destinationBuffer);
                    if (remaining == this.socketDataIn.remaining()) {
                        if (++noUnwrap > 50) {
                            this.shutdown();
                            boolean bl4 = true;
                            return bl4;
                        }
                    } else {
                        noUnwrap = 0;
                        remaining = this.socketDataIn.remaining();
                    }
                    this.destinationBuffer.flip();
                    if (this.destinationBuffer.hasRemaining() && !this.initialHandshake) {
                        this.protocolEngine.onSocketRead(this.destinationBuffer);
                    }
                    this.destinationBuffer.compact();
                    if (res.getStatus() == SSLEngineResult.Status.OK && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && res.bytesProduced() == 0) continue;
                    if (this.destinationBuffer.position() == currentDestinationPos && this.socketDataIn.hasRemaining()) {
                        res = this.engine.unwrap(this.socketDataIn, this.destinationBuffer);
                        this.destinationBuffer.flip();
                        if (this.destinationBuffer.hasRemaining() && !this.initialHandshake) {
                            this.protocolEngine.onSocketRead(this.destinationBuffer);
                        }
                        this.destinationBuffer.compact();
                    }
                    this.status = res.getStatus();
                    this.hsStatus = res.getHandshakeStatus();
                    if (this.status == SSLEngineResult.Status.CLOSED) {
                        this.shutdown();
                    }
                    if (this.hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK || this.hsStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP || this.hsStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                        this.doHandshake();
                    }
                    if (!this.socketDataIn.hasRemaining() || this.status == SSLEngineResult.Status.BUFFER_UNDERFLOW) break;
                }
            }
            this.socketDataIn.compact();
            if (!this.isConnected()) {
                // empty if block
            }
            bl = !this.isConnected();
            return bl;
        }
        catch (Throwable ex) {
            Log.error((String)"An error occured whilst trying to read from the socket", (Throwable)ex, (Object[])new Object[0]);
            this.closeConnection();
            bl = true;
            return bl;
        }
        finally {
            if (this.destinationBuffer != null && this.destinationBuffer.remaining() == this.destinationBuffer.capacity()) {
                this.daemonContext.getBufferPool().add(this.destinationBuffer);
                this.destinationBuffer = null;
            }
            if (this.socketDataIn != null && this.socketDataIn.remaining() == this.socketDataIn.capacity()) {
                this.daemonContext.getBufferPool().add(this.socketDataIn);
                this.socketDataIn = null;
            }
        }
    }

    private void finishInitialHandshake() {
        this.initialHandshake = false;
        Log.debug((String)"Completed handshake", (Object[])new Object[0]);
        this.protocolEngine.onSocketConnect(this);
    }

    private void doHandshake() throws SSLException {
        while (true) {
            switch (this.hsStatus) {
                case FINISHED: {
                    this.finishInitialHandshake();
                    return;
                }
                case NEED_TASK: {
                    Runnable task;
                    while ((task = this.engine.getDelegatedTask()) != null) {
                        task.run();
                    }
                    this.hsStatus = this.engine.getHandshakeStatus();
                    break;
                }
                case NEED_UNWRAP: 
                case NEED_UNWRAP_AGAIN: {
                    this.wantsWrite = false;
                    return;
                }
                case NEED_WRAP: {
                    this.wantsWrite = true;
                    return;
                }
                case NOT_HANDSHAKING: {
                    Log.error((String)"doHandshake has caught a NOT_HANDSHAKING state.. This is impossible!", (Object[])new Object[0]);
                    return;
                }
            }
        }
    }

    private void flush() throws IOException {
        if (this.socketDataOut != null) {
            try {
                this.socketChannel.write(this.socketDataOut);
            }
            catch (IOException ex) {
                this.closeConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processWriteEvent() {
        if (this.socketChannel == null || !this.socketChannel.isOpen()) {
            return true;
        }
        if (this.socketDataOut == null) {
            this.socketDataOut = this.daemonContext.getBufferPool().get();
        }
        try {
            SSLEngineResult res;
            if (!this.socketChannel.isOpen()) {
                boolean bl = true;
                return bl;
            }
            if (this.initialHandshake) {
                if (this.hsStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
                    res = this.engine.wrap(this.dummy, this.socketDataOut);
                    this.hsStatus = res.getHandshakeStatus();
                    this.socketDataOut.flip();
                    this.flush();
                }
                this.doHandshake();
                if (this.hsStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP && this.hsStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
                    this.wantsWrite = false;
                }
            } else {
                SocketWriteCallback c;
                if (this.sourceBuffer == null) {
                    this.sourceBuffer = this.daemon.getContext().getBufferPool().get();
                }
                if (this.sourceBuffer.remaining() == this.sourceBuffer.limit() && this.protocolEngine.isConnected() && (c = this.protocolEngine.onSocketWrite(this.sourceBuffer)) != null) {
                    this.socketWriteCallbacks.addLast(c);
                }
                this.sourceBuffer.flip();
                res = this.engine.wrap(this.sourceBuffer, this.socketDataOut);
                this.status = res.getStatus();
                this.hsStatus = res.getHandshakeStatus();
                this.socketDataOut.flip();
                this.flush();
                this.wantsWrite = this.protocolEngine.wantsToWrite() || this.sourceBuffer.hasRemaining() || this.socketDataOut.hasRemaining();
            }
            boolean res2 = !this.isConnected();
            return res2;
        }
        catch (Throwable ex) {
            Log.error((String)"An error occured whilst trying to write to the socket", (Throwable)ex, (Object[])new Object[0]);
            this.closeConnection();
            boolean bl = true;
            return bl;
        }
        finally {
            if (this.sourceBuffer != null) {
                if (!this.sourceBuffer.hasRemaining() || this.sourceBuffer.remaining() == this.sourceBuffer.capacity()) {
                    this.daemonContext.getBufferPool().add(this.sourceBuffer);
                    this.sourceBuffer = null;
                } else {
                    this.sourceBuffer.compact();
                }
            }
            if (this.socketDataOut != null) {
                if (!this.socketDataOut.hasRemaining() || this.socketDataOut.remaining() == this.socketDataOut.capacity()) {
                    this.daemonContext.getBufferPool().add(this.socketDataOut);
                    this.socketDataOut = null;
                    Iterator it = this.socketWriteCallbacks.iterator();
                    while (it.hasNext()) {
                        ((SocketWriteCallback)it.next()).completedWrite();
                    }
                    this.socketWriteCallbacks.clear();
                } else {
                    this.socketDataOut.compact();
                }
            }
        }
    }

    @Override
    public boolean wantsWrite() {
        return super.wantsWrite() && this.wantsWrite;
    }
}

