/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.retry;

import com.microsoft.azure.vmagent.exceptions.AzureCloudException;
import com.microsoft.azure.vmagent.retry.RetryStrategy;
import com.microsoft.azure.vmagent.util.AzureUtil;

public class DefaultRetryStrategy
implements RetryStrategy {
    private static final int DEFAULT_MAX_RETRIES = 3;
    private static final int DEFAULT_WAIT_INTERVAL_IN_SECONDS = 2;
    private static final int DEFAULT_TIMEOUT_IN_SECONDS = 240;
    private int currentRetryCount = 0;
    private int maxRetries = 3;
    private int waitInterval = 2;
    private int defaultTimeoutInSeconds = 240;

    public DefaultRetryStrategy() {
    }

    public DefaultRetryStrategy(int maxRetries, int waitInterval, int defaultTimeoutInSeconds) {
        this.maxRetries = maxRetries;
        this.waitInterval = waitInterval;
        this.defaultTimeoutInSeconds = defaultTimeoutInSeconds;
    }

    @Override
    public boolean canRetry(int retryCount, Exception e) throws AzureCloudException {
        if (retryCount >= this.maxRetries) {
            throw AzureCloudException.create("Exceeded maximum retry count " + this.maxRetries, e);
        }
        return AzureUtil.isHostNotFound(e.getMessage()) || AzureUtil.isConflictError(e.getLocalizedMessage());
    }

    @Override
    public void handleRetry(Exception e) throws AzureCloudException {
        ++this.currentRetryCount;
        if (this.canRetry(this.currentRetryCount, e)) {
            try {
                Thread.sleep(this.getWaitPeriodInSeconds(this.currentRetryCount, e) * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getWaitPeriodInSeconds(int retryCount, Exception e) {
        return this.waitInterval;
    }

    @Override
    public int getMaxTimeoutInSeconds() {
        return this.defaultTimeoutInSeconds;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Override
    public void reset() {
        this.currentRetryCount = 0;
        this.maxRetries = 3;
        this.waitInterval = 2;
        this.defaultTimeoutInSeconds = 240;
    }
}

