/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.availability;

import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.AzureResourceManager;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.availability.AzureAvailabilityType;
import com.microsoft.jenkins.credentials.AzureResourceManagerCache;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Descriptor;
import hudson.slaves.Cloud;
import hudson.util.ListBoxModel;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class AvailabilitySet
extends AzureAvailabilityType {
    private static final Logger LOGGER = Logger.getLogger(AvailabilitySet.class.getName());
    private final String name;

    @DataBoundConstructor
    public AvailabilitySet(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AvailabilitySet that = (AvailabilitySet)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hashCode(this.name);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<AzureAvailabilityType> {
        @NonNull
        public String getDisplayName() {
            return Messages.availabilitySet();
        }

        @POST
        public ListBoxModel doFillNameItems(@RelativePath(value="..") @QueryParameter(value="cloudName") String cloudName, @RelativePath(value="..") @QueryParameter String location) {
            Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
            ListBoxModel model = new ListBoxModel();
            model.add("--- Select Availability Set in current resource group and location ---", "");
            AzureVMCloud cloud = this.getAzureCloud(cloudName);
            if (cloud == null) {
                return model;
            }
            String azureCredentialsId = cloud.getAzureCredentialsId();
            if (StringUtils.isBlank((CharSequence)azureCredentialsId)) {
                return model;
            }
            String resourceGroupReferenceType = cloud.getResourceGroupReferenceType();
            String newResourceGroupName = cloud.getNewResourceGroupName();
            String existingResourceGroupName = cloud.getExistingResourceGroupName();
            try {
                AzureResourceManager azureClient = AzureResourceManagerCache.get((String)azureCredentialsId);
                if (azureClient == null) {
                    return model;
                }
                String resourceGroupName = AzureVMCloud.getResourceGroupName(resourceGroupReferenceType, newResourceGroupName, existingResourceGroupName);
                PagedIterable availabilitySets = azureClient.availabilitySets().listByResourceGroup(resourceGroupName);
                for (com.azure.resourcemanager.compute.models.AvailabilitySet set : availabilitySets) {
                    String label = set.region().label();
                    if (!label.equals(location)) continue;
                    model.add(set.name());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Cannot list availability set: ", e);
            }
            return model;
        }

        private AzureVMCloud getAzureCloud(String cloudName) {
            Cloud cloud = Jenkins.get().getCloud(cloudName);
            if (cloud instanceof AzureVMCloud) {
                return (AzureVMCloud)cloud;
            }
            return null;
        }
    }
}

