/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import org.kohsuke.stapler.DataBoundConstructor;

public class ProvisionStrategy {
    private static final long INIT_INTERVAL = 10000L;
    private static final long MAX_INTERVAL = 600000L;
    private long interval = 10000L;
    private long lastFailureTime = 0L;
    private String configurationStatus = "unverified";

    @DataBoundConstructor
    public ProvisionStrategy() {
    }

    public boolean isVerifiedPass() {
        return this.configurationStatus.equals("pass");
    }

    public boolean isVerifiedFailed() {
        return this.configurationStatus.equals("failed");
    }

    public synchronized void failure() {
        this.configurationStatus = "failed";
        this.interval = Math.min(this.interval * 2L, 600000L);
        this.lastFailureTime = System.currentTimeMillis();
    }

    public synchronized void success() {
        this.configurationStatus = "pass";
        this.interval = 10000L;
        this.lastFailureTime = 0L;
    }

    public synchronized void verifiedPass() {
        this.configurationStatus = "pass";
    }

    public synchronized boolean isEnabled() {
        return this.lastFailureTime + this.interval <= System.currentTimeMillis();
    }
}

