/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.AzureVMManagementServiceDelegate;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;

@Extension
public final class AzureVMCloudVerificationTask
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(AzureVMCloudVerificationTask.class.getName());
    private static final int RECURRENCE_PERIOD_IN_MILLIS = 3600000;

    public AzureVMCloudVerificationTask() {
        super("Azure VM Verification Task");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verify(String cloudName, String templateName) {
        if (StringUtils.isBlank((CharSequence)cloudName) || StringUtils.isBlank((CharSequence)templateName)) {
            return;
        }
        AzureVMCloudVerificationTask.verifyCloud(cloudName);
        AzureVMCloud cloud = AzureVMCloudVerificationTask.getCloud(cloudName);
        if (cloud == null) {
            LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: verify: parent cloud not found for {0} in {1}", new Object[]{templateName, cloudName});
            return;
        }
        AzureVMAgentTemplate agentTemplate = cloud.getAzureAgentTemplate(templateName);
        if (agentTemplate == null) {
            LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: verify: could not retrieve agent template named {0} in {1}", new Object[]{templateName, cloudName});
            return;
        }
        AzureVMAgentTemplate azureVMAgentTemplate = agentTemplate;
        synchronized (azureVMAgentTemplate) {
            if (!cloud.getConfigurationStatus().equals("pass")) {
                agentTemplate.retrieveTemplateProvisionStrategy().failure();
                return;
            }
            if (agentTemplate.retrieveTemplateProvisionStrategy().isVerifiedPass()) {
                return;
            }
            if (!agentTemplate.retrieveTemplateProvisionStrategy().isEnabled()) {
                return;
            }
            try {
                List<String> errors = agentTemplate.verifyTemplate();
                if (errors.isEmpty()) {
                    LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: verify: {0} verified successfully", templateName);
                    agentTemplate.retrieveTemplateProvisionStrategy().verifiedPass();
                    agentTemplate.setTemplateStatusDetails("");
                } else {
                    String details = StringUtils.join(errors, (String)"\n");
                    LOGGER.log(Level.WARNING, "AzureVMCloudVerificationTask: verify: {0} could not be verified:\n{1}", new Object[]{templateName, details});
                    agentTemplate.retrieveTemplateProvisionStrategy().failure();
                    agentTemplate.setTemplateStatusDetails(details);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "AzureVMCloudVerificationTask: verify: got exception while verifying {0}:\n{1}", new Object[]{templateName, e.toString()});
                agentTemplate.retrieveTemplateProvisionStrategy().failure();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void verifyCloud(String cloudName) {
        if (StringUtils.isBlank((CharSequence)cloudName)) {
            return;
        }
        LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: verify: verifying cloud {0}", cloudName);
        AzureVMCloud cloud = AzureVMCloudVerificationTask.getCloud(cloudName);
        if (cloud == null) {
            LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: verify: subscription {0} not found, skipping", cloudName);
            return;
        }
        AzureVMCloud azureVMCloud = cloud;
        synchronized (azureVMCloud) {
            if (cloud.getConfigurationStatus().equals("pass")) {
                LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: verify: cloud {0} already verified pass", cloudName);
                AzureVMCloudVerificationTask.updateCloudVirtualMachineCounts(cloud);
                return;
            }
            if (AzureVMCloudVerificationTask.verifyConfiguration(cloud)) {
                LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: validate: {0} verified pass", cloudName);
                AzureVMCloudVerificationTask.updateCloudVirtualMachineCounts(cloud);
                cloud.setConfigurationStatus("pass");
                return;
            }
            cloud.setConfigurationStatus("failed");
            LOGGER.log(Level.WARNING, "AzureVMCloudVerificationTask: verify: {0} not verified, has errors", cloudName);
        }
    }

    public static boolean verifyConfiguration(AzureVMCloud cloud) {
        LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: verifyConfiguration: start");
        String result = cloud.getServiceDelegate().verifyConfiguration(cloud.getResourceGroupName(), "existing".equals(cloud.getResourceGroupReferenceType()), Integer.toString(cloud.getDeploymentTimeout()));
        if (!"Success".equals(result)) {
            LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: verifyConfiguration: {0}", result);
            cloud.setConfigurationStatus("failed");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean updateCloudVirtualMachineCounts(AzureVMCloud cloud) {
        AzureVMCloud azureVMCloud = cloud;
        synchronized (azureVMCloud) {
            LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: updateCloudVirtualMachineCounts({0},{1}): start", new Object[]{cloud.getCloudName(), cloud.getResourceGroupName()});
            try {
                AzureVMManagementServiceDelegate sd = cloud.getServiceDelegate();
                Map<String, Integer> counts = sd.getVirtualMachineCountsByTemplate(cloud.getCloudName(), cloud.getResourceGroupName());
                cloud.setCurrentVirtualMachineCount(counts);
                LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: updateCloudVirtualMachineCounts({0},{1}): end", new Object[]{cloud.getCloudName(), cloud.getResourceGroupName()});
                return true;
            }
            catch (Exception e) {
                LOGGER.log(AzureVMCloudVerificationTask.getStaticNormalLoggingLevel(), "AzureVMCloudVerificationTask: updateCloudVirtualMachineCounts({0},{1}): failed\n{2}", new Object[]{cloud.getCloudName(), cloud.getResourceGroupName(), e});
                return false;
            }
        }
    }

    public static AzureVMCloud getCloud(String cloudName) {
        return Jenkins.getInstanceOrNull() == null ? null : (AzureVMCloud)Jenkins.get().getCloud(cloudName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TaskListener arg0) {
        for (Cloud anyTypeOfCloud : Jenkins.get().clouds) {
            AzureVMCloud cloud;
            if (!(anyTypeOfCloud instanceof AzureVMCloud)) continue;
            AzureVMCloud azureVMCloud = cloud = (AzureVMCloud)anyTypeOfCloud;
            synchronized (azureVMCloud) {
                AzureVMCloudVerificationTask.updateCloudVirtualMachineCounts(cloud);
            }
        }
    }

    public long getRecurrencePeriod() {
        return 3600000L;
    }

    protected Level getNormalLoggingLevel() {
        return Level.FINE;
    }

    private static Level getStaticNormalLoggingLevel() {
        return Level.FINE;
    }
}

