/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.compute.models.VirtualMachine;
import com.azure.resourcemanager.resources.models.Deployment;
import com.azure.resourcemanager.resources.models.GenericResource;
import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.AzureVMComputer;
import com.microsoft.azure.vmagent.AzureVMManagementServiceDelegate;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.exceptions.AzureCloudException;
import com.microsoft.azure.vmagent.retry.DefaultRetryStrategy;
import com.microsoft.azure.vmagent.util.AzureUtil;
import com.microsoft.azure.vmagent.util.CleanUpAction;
import com.microsoft.azure.vmagent.util.ExecutionEngine;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeProvisioner;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Paths;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.cloudstats.CloudStatistics;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;

@Extension
public class AzureVMAgentCleanUpTask
extends AsyncPeriodicWork {
    private static final int CLEAN_TIMEOUT_IN_MINUTES = 15;
    private static final int RECURRENCE_PERIOD_IN_MILLIS = 300000;
    private static final long SUCCESSFUL_DEPLOYMENT_TIMEOUT_IN_MINUTES = 60L;
    private static final long FAILING_DEPLOYMENT_TIMEOUT_IN_MINUTES = 480L;
    private static final int MAX_DELETE_ATTEMPTS = 3;
    private static final Logger LOGGER = Logger.getLogger(AzureVMAgentCleanUpTask.class.getName());

    public AzureVMAgentCleanUpTask() {
        super("Azure VM Agents Clean Task");
    }

    public void cleanDeployments() {
        this.cleanDeployments(60L, 480L);
    }

    public void cleanDeployments(long successTimeoutInMinutes, long failTimeoutInMinutes) {
        LOGGER.log(this.getNormalLoggingLevel(), "Cleaning deployments");
        DeploymentInfo firstBackInQueue = null;
        ConcurrentLinkedQueue<DeploymentInfo> deploymentsToClean = DeploymentRegistrar.getInstance().getDeploymentsToClean();
        while (!deploymentsToClean.isEmpty() && firstBackInQueue != deploymentsToClean.peek()) {
            DeploymentInfo info = (DeploymentInfo)deploymentsToClean.remove();
            LOGGER.log(this.getNormalLoggingLevel(), "Checking deployment {0}", info.getDeploymentName());
            AzureVMCloud cloud = this.getCloud(info.getCloudName());
            if (cloud == null) continue;
            try {
                AzureResourceManager azureClient = cloud.getAzureClient();
                AzureVMManagementServiceDelegate delegate = cloud.getServiceDelegate();
                Deployment deployment = (Deployment)azureClient.deployments().getByResourceGroup(info.getResourceGroupName(), info.getDeploymentName());
                if (deployment == null) {
                    LOGGER.log(this.getNormalLoggingLevel(), "Deployment " + info.getDeploymentName() + " not found, skipping");
                    continue;
                }
                OffsetDateTime deploymentTime = deployment.timestamp();
                LOGGER.log(this.getNormalLoggingLevel(), "Deployment created on {0}", deploymentTime.toString());
                long diffTimeInMinutes = ChronoUnit.MINUTES.between(deploymentTime, OffsetDateTime.now());
                String state = deployment.provisioningState();
                if (!state.equalsIgnoreCase("succeeded") && diffTimeInMinutes > failTimeoutInMinutes) {
                    LOGGER.log(this.getNormalLoggingLevel(), "Failed deployment older than {0} minutes, deleting", failTimeoutInMinutes);
                    azureClient.deployments().deleteByResourceGroup(info.getResourceGroupName(), info.getDeploymentName());
                    if (!StringUtils.isNotBlank((CharSequence)info.scriptUri)) continue;
                    delegate.removeStorageBlob(new URI(info.scriptUri), info.getResourceGroupName(), cloud.getAzureCredentialsId(), info.isUseEntraIdForStorageAccount());
                    continue;
                }
                if (state.equalsIgnoreCase("succeeded") && diffTimeInMinutes > successTimeoutInMinutes) {
                    LOGGER.log(this.getNormalLoggingLevel(), "Successful deployment older than {0} minutes, deleting", successTimeoutInMinutes);
                    azureClient.deployments().deleteByResourceGroup(info.getResourceGroupName(), info.getDeploymentName());
                    if (!StringUtils.isNotBlank((CharSequence)info.scriptUri)) continue;
                    delegate.removeStorageBlob(new URI(info.scriptUri), info.getResourceGroupName(), cloud.getAzureCredentialsId(), info.isUseEntraIdForStorageAccount());
                    continue;
                }
                LOGGER.log(this.getNormalLoggingLevel(), "Deployment newer than timeout, keeping");
                if (firstBackInQueue == null) {
                    firstBackInQueue = info;
                }
                deploymentsToClean.add(info);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, String.format("Failed to get/delete deployment: %s", info.getDeploymentName()), e);
                if (!info.hasAttemptsRemaining()) continue;
                info.decrementAttemptsRemaining();
                if (firstBackInQueue == null) {
                    firstBackInQueue = info;
                }
                deploymentsToClean.add(info);
            }
        }
        DeploymentRegistrar.getInstance().syncDeploymentsToClean();
        LOGGER.log(this.getNormalLoggingLevel(), "Done cleaning deployments");
    }

    public void cleanLeakedResources() {
        Jenkins instance = Jenkins.getInstanceOrNull();
        LOGGER.log(this.getNormalLoggingLevel(), "Beginning");
        if (instance == null) {
            LOGGER.log(this.getNormalLoggingLevel(), "Skipped as no Jenkins instance");
            return;
        }
        for (AzureVMCloud cloud : instance.clouds.getAll(AzureVMCloud.class)) {
            this.cleanLeakedResources(cloud, cloud.getResourceGroupName(), DeploymentRegistrar.getInstance());
        }
        LOGGER.log(this.getNormalLoggingLevel(), "Completed");
    }

    public List<String> getValidVMs() {
        ArrayList<String> vms = new ArrayList<String>();
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (instance != null) {
            for (Computer computer : instance.getComputers()) {
                if (!(computer instanceof AzureVMComputer)) continue;
                vms.add(computer.getName());
            }
        }
        return vms;
    }

    public void cleanLeakedResources(AzureVMCloud cloud, String resourceGroup, DeploymentRegistrar deploymentRegistrar) {
        try {
            List<String> validVMs = this.getValidVMs();
            AzureResourceManager azureClient = cloud.getAzureClient();
            if (azureClient == null) {
                LOGGER.log(this.getNormalLoggingLevel(), "cleanLeakedResources: Skipping cleanup as cloud is not configured with a valid credential");
                return;
            }
            AzureVMManagementServiceDelegate serviceDelegate = cloud.getServiceDelegate();
            PagedIterable resources = azureClient.genericResources().listByResourceGroup(resourceGroup);
            if (resources == null || !resources.iterator().hasNext()) {
                LOGGER.log(this.getNormalLoggingLevel(), "cleanLeakedResources: No resources found in rg: " + resourceGroup);
                return;
            }
            PriorityQueue<GenericResource> resourcesMarkedForDeletion = new PriorityQueue<GenericResource>(10, new Comparator<GenericResource>(){

                @Override
                public int compare(GenericResource o1, GenericResource o2) {
                    int o2Priority;
                    int o1Priority = this.getPriority(o1);
                    if (o1Priority == (o2Priority = this.getPriority(o2))) {
                        return 0;
                    }
                    return o1Priority < o2Priority ? -1 : 1;
                }

                private int getPriority(GenericResource resource) {
                    String type = resource.type();
                    if (StringUtils.containsIgnoreCase((CharSequence)type, (CharSequence)"virtualMachine")) {
                        return 1;
                    }
                    if (StringUtils.containsIgnoreCase((CharSequence)type, (CharSequence)"networkInterface")) {
                        return 2;
                    }
                    if (StringUtils.containsIgnoreCase((CharSequence)type, (CharSequence)"IPAddress")) {
                        return 3;
                    }
                    return 4;
                }
            });
            LOGGER.log(this.getNormalLoggingLevel(), String.format("cleanLeakedResources: beginning to look at leaked resources in rg: %s", resourceGroup));
            for (GenericResource resource : resources) {
                Map tags = resource.tags();
                if (!tags.containsKey("JenkinsResourceTag") || !deploymentRegistrar.getDeploymentTag().matches(new AzureUtil.DeploymentTag((String)tags.get("JenkinsResourceTag")))) continue;
                boolean shouldSkipDeletion = false;
                for (String validVM : validVMs) {
                    if (!resource.name().contains(validVM)) continue;
                    shouldSkipDeletion = true;
                    break;
                }
                if (shouldSkipDeletion || StringUtils.containsIgnoreCase((CharSequence)resource.type(), (CharSequence)"StorageAccounts") || StringUtils.containsIgnoreCase((CharSequence)resource.type(), (CharSequence)"virtualNetworks")) continue;
                resourcesMarkedForDeletion.add(resource);
            }
            LOGGER.log(this.getNormalLoggingLevel(), String.format("cleanLeakedResources: %d resources marked for deletion", resourcesMarkedForDeletion.size()));
            while (!resourcesMarkedForDeletion.isEmpty()) {
                try {
                    GenericResource resource = resourcesMarkedForDeletion.poll();
                    if (resource == null) {
                        LOGGER.log(this.getNormalLoggingLevel(), "cleanLeakedResources: resource was null continuing");
                        continue;
                    }
                    LOGGER.log(this.getNormalLoggingLevel(), "cleanLeakedResources: looking at {0} from resource group {1}", new Object[]{resource.name(), resourceGroup});
                    URI osDiskURI = null;
                    String managedOsDiskId = null;
                    if (StringUtils.containsIgnoreCase((CharSequence)resource.type(), (CharSequence)"virtualMachine")) {
                        LOGGER.log(this.getNormalLoggingLevel(), "cleanLeakedResources: retrieving VM {0} from resource group {1}", new Object[]{resource.name(), resourceGroup});
                        VirtualMachine virtualMachine = (VirtualMachine)azureClient.virtualMachines().getById(resource.id());
                        if (!virtualMachine.isManagedDiskEnabled()) {
                            osDiskURI = new URI(virtualMachine.osUnmanagedDiskVhdUri());
                        } else {
                            managedOsDiskId = virtualMachine.osDiskId();
                        }
                        LOGGER.log(this.getNormalLoggingLevel(), "cleanLeakedResources: completed retrieving VM {0} from resource group {1}", new Object[]{resource.name(), resourceGroup});
                    }
                    LOGGER.log(this.getNormalLoggingLevel(), "cleanLeakedResources: deleting {0} from resource group {1}", new Object[]{resource.name(), resourceGroup});
                    azureClient.genericResources().deleteById(resource.id());
                    if (osDiskURI != null) {
                        String jenkinsTemplateTag = (String)resource.tags().get("JenkinsTemplateTag");
                        boolean useEntraIdForStorageAccount = cloud.getTemplate(jenkinsTemplateTag).isUseEntraIdForStorageAccount();
                        serviceDelegate.removeStorageBlob(osDiskURI, resourceGroup, cloud.getAzureCredentialsId(), useEntraIdForStorageAccount);
                    }
                    if (managedOsDiskId != null) {
                        azureClient.disks().deleteById(managedOsDiskId);
                        serviceDelegate.removeImage(azureClient, resource.name(), resourceGroup);
                    }
                    LOGGER.log(this.getNormalLoggingLevel(), "cleanLeakedResources: deleted {0} from resource group {1}", new Object[]{resource.name(), resourceGroup});
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to clean resource ", e);
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to clean leaked resources ", e);
        }
    }

    private void cleanVMs() {
        this.cleanVMs(new ExecutionEngine());
    }

    private void cleanVMs(ExecutionEngine executionEngine) {
        LOGGER.log(this.getNormalLoggingLevel(), "Beginning");
        for (Computer computer : Jenkins.get().getComputers()) {
            if (!(computer instanceof AzureVMComputer)) continue;
            AzureVMComputer azureComputer = (AzureVMComputer)computer;
            AzureVMAgent agentNode = (AzureVMAgent)azureComputer.getNode();
            if (!azureComputer.isOffline()) continue;
            if (agentNode == null) {
                LOGGER.log(this.getNormalLoggingLevel(), "Node {0} is missing, skipping", azureComputer.getDisplayName());
                continue;
            }
            if (azureComputer.isSetOfflineByUser()) {
                LOGGER.log(this.getNormalLoggingLevel(), "Node {0} was set offline by user, skipping", agentNode.getDisplayName());
                continue;
            }
            if (agentNode.isCleanUpBlocked()) {
                LOGGER.log(this.getNormalLoggingLevel(), "Node {0} blocked to cleanup", agentNode.getDisplayName());
                continue;
            }
            if (!AzureVMManagementServiceDelegate.virtualMachineExists(agentNode)) {
                LOGGER.log(this.getNormalLoggingLevel(), "Node {0} doesn't exist, removing", agentNode.getDisplayName());
                try {
                    Jenkins.get().removeNode((Node)agentNode);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Node {0} could not be removed: {1}", new Object[]{agentNode.getDisplayName(), e.getMessage()});
                }
                continue;
            }
            if (!azureComputer.isIdle()) continue;
            Callable<Void> task = () -> {
                if (agentNode.getCleanUpAction() == CleanUpAction.DELETE) {
                    LOGGER.log(this.getNormalLoggingLevel(), "Deleting {0}", agentNode.getDisplayName());
                    agentNode.deprovision(agentNode.getCleanUpReason());
                } else if (agentNode.getCleanUpAction() == CleanUpAction.SHUTDOWN) {
                    LOGGER.log(this.getNormalLoggingLevel(), "Shutting down {0}", agentNode.getDisplayName());
                    agentNode.shutdown(agentNode.getCleanUpReason());
                    agentNode.blockCleanUpAction();
                } else {
                    throw new IllegalStateException("Unknown cleanup action");
                }
                return null;
            };
            try {
                int maxRetries = 3;
                int waitInterval = 10;
                int defaultTimeOutInSeconds = 1800;
                executionEngine.executeAsync(task, new DefaultRetryStrategy(3, 10, 1800));
            }
            catch (AzureCloudException exception) {
                LOGGER.log(Level.WARNING, "Failed to shutdown/delete " + agentNode.getDisplayName(), exception);
                agentNode.setCleanUpAction(CleanUpAction.DELETE, Messages._Failed_Initial_Shutdown_Or_Delete());
            }
        }
        LOGGER.log(this.getNormalLoggingLevel(), "Completed");
    }

    public void cleanCloudStatistics() {
        Jenkins jenkins = Jenkins.get();
        LOGGER.log(this.getNormalLoggingLevel(), "Beginning");
        HashSet<ProvisioningActivity.Id> plannedNodesSet = new HashSet<ProvisioningActivity.Id>();
        for (NodeProvisioner.PlannedNode node : jenkins.unlabeledNodeProvisioner.getPendingLaunches()) {
            if (!(node instanceof TrackedItem)) continue;
            plannedNodesSet.add(((TrackedItem)node).getId());
        }
        for (Label l : jenkins.getLabels()) {
            for (NodeProvisioner.PlannedNode node : l.nodeProvisioner.getPendingLaunches()) {
                if (!(node instanceof TrackedItem)) continue;
                plannedNodesSet.add(((TrackedItem)node).getId());
            }
        }
        for (NodeProvisioner.PlannedNode node : jenkins.getNodes()) {
            if (!(node instanceof TrackedItem)) continue;
            plannedNodesSet.add(((TrackedItem)node).getId());
        }
        Collection activities = CloudStatistics.get().getNotCompletedActivities();
        for (ProvisioningActivity activity : activities) {
            if (!activity.getCurrentPhase().equals((Object)ProvisioningActivity.Phase.PROVISIONING) || plannedNodesSet.contains(activity.getId())) continue;
            Exception e = new Exception(String.format("Node %s has lost. Mark as failure", activity.getId()));
            CloudStatistics.ProvisioningListener.get().onFailure(activity.getId(), (Throwable)e);
        }
        LOGGER.log(this.getNormalLoggingLevel(), "Completed");
    }

    public AzureVMCloud getCloud(String cloudName) {
        return Jenkins.getInstanceOrNull() == null ? null : (AzureVMCloud)Jenkins.get().getCloud(cloudName);
    }

    private void clean() {
        this.cleanVMs();
        this.cleanDeployments();
        this.cleanLeakedResources();
        this.cleanCloudStatistics();
    }

    public void execute(TaskListener arg0) throws InterruptedException {
        LOGGER.log(this.getNormalLoggingLevel(), "Start");
        Callable<Void> callClean = () -> {
            this.clean();
            return null;
        };
        Future<Void> result = AzureVMCloud.getThreadPool().submit(callClean);
        try {
            LOGGER.log(this.getNormalLoggingLevel(), String.format("Running clean with %s minute timeout", 15));
            result.get(15L, TimeUnit.MINUTES);
        }
        catch (ExecutionException executionException) {
            LOGGER.log(Level.SEVERE, "Got execution exception while cleaning", executionException);
        }
        catch (TimeoutException timeoutException) {
            LOGGER.log(Level.SEVERE, "Hit timeout while cleaning", timeoutException);
        }
        catch (Exception others) {
            LOGGER.log(Level.SEVERE, "Hit other exception while cleaning", others);
        }
        LOGGER.log(this.getNormalLoggingLevel(), "End");
    }

    public long getRecurrencePeriod() {
        return 300000L;
    }

    protected Level getNormalLoggingLevel() {
        return Level.FINE;
    }

    public static String loadProperty(String name) {
        String value = System.getProperty(name);
        if (StringUtils.isBlank((CharSequence)value)) {
            return AzureVMAgentCleanUpTask.loadEnv(name);
        }
        return value;
    }

    public static String loadEnv(String name) {
        String value = System.getenv(name);
        if (StringUtils.isBlank((CharSequence)value)) {
            return "";
        }
        return value;
    }

    public static class DeploymentRegistrar {
        private static final String OUTPUT_FILE = Paths.get(AzureVMAgentCleanUpTask.loadProperty("JENKINS_HOME"), "deployment.out").toString();
        private static DeploymentRegistrar deploymentRegistrar = null;
        private ConcurrentLinkedQueue<DeploymentInfo> deploymentsToClean;

        protected DeploymentRegistrar() {
            try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(OUTPUT_FILE));){
                this.deploymentsToClean = (ConcurrentLinkedQueue)ois.readObject();
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.WARNING, "Cannot open deployment output file");
                this.deploymentsToClean = new ConcurrentLinkedQueue();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Cannot deserialize deploymentsToClean", e);
                this.deploymentsToClean = new ConcurrentLinkedQueue();
            }
        }

        public static synchronized DeploymentRegistrar getInstance() {
            if (deploymentRegistrar == null) {
                deploymentRegistrar = new DeploymentRegistrar();
            }
            return deploymentRegistrar;
        }

        public ConcurrentLinkedQueue<DeploymentInfo> getDeploymentsToClean() {
            return this.deploymentsToClean;
        }

        public void registerDeployment(String cloudName, String resourceGroupName, String deploymentName, String scriptUri, boolean isUseEntraIdForStorageAccount) {
            LOGGER.log(Level.FINE, "Registering deployment {0} in {1}", new Object[]{deploymentName, resourceGroupName});
            DeploymentInfo newDeploymentToClean = new DeploymentInfo(cloudName, resourceGroupName, deploymentName, scriptUri, 3, isUseEntraIdForStorageAccount);
            this.deploymentsToClean.add(newDeploymentToClean);
            this.syncDeploymentsToClean();
        }

        public synchronized void syncDeploymentsToClean() {
            try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(OUTPUT_FILE));){
                oos.writeObject(this.deploymentsToClean);
            }
            catch (FileNotFoundException e) {
                LOGGER.log(Level.WARNING, "Cannot open deployment output file" + OUTPUT_FILE);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Serialize failed", e);
            }
        }

        public AzureUtil.DeploymentTag getDeploymentTag() {
            return new AzureUtil.DeploymentTag();
        }
    }

    private static class DeploymentInfo
    implements Serializable {
        private static final long serialVersionUID = 888154365L;
        private final String cloudName;
        private final String deploymentName;
        private final String resourceGroupName;
        private final String scriptUri;
        private int attemptsRemaining;
        private final boolean isUseEntraIdForStorageAccount;

        DeploymentInfo(String cloudName, String resourceGroupName, String deploymentName, String scriptUri, int deleteAttempts, boolean isUseEntraIdForStorageAccount) {
            this.cloudName = cloudName;
            this.deploymentName = deploymentName;
            this.resourceGroupName = resourceGroupName;
            this.scriptUri = scriptUri;
            this.attemptsRemaining = deleteAttempts;
            this.isUseEntraIdForStorageAccount = isUseEntraIdForStorageAccount;
        }

        String getCloudName() {
            return this.cloudName;
        }

        String getDeploymentName() {
            return this.deploymentName;
        }

        String getResourceGroupName() {
            return this.resourceGroupName;
        }

        String getScriptUri() {
            return this.scriptUri;
        }

        public boolean isUseEntraIdForStorageAccount() {
            return this.isUseEntraIdForStorageAccount;
        }

        boolean hasAttemptsRemaining() {
            return this.attemptsRemaining > 0;
        }

        void decrementAttemptsRemaining() {
            --this.attemptsRemaining;
        }
    }
}

