/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.microsoft.azure.util.AzureCredentials;
import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.AzureVMComputer;
import com.microsoft.azure.vmagent.AzureVMManagementServiceDelegate;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.remote.AzureVMAgentSSHLauncher;
import com.microsoft.azure.vmagent.util.CleanUpAction;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.AbstractCloudSlave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.JNLPLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.LogTaskListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.cloudstats.CloudStatistics;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedItem;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class AzureVMAgent
extends AbstractCloudSlave
implements TrackedItem {
    private static final long serialVersionUID = -760014706860995557L;
    private static final String REMOTE_TERMINATE_FILE_NAME = "terminate.sh";
    private static final String REMOTE_TERMINATE_FILE_NAME_WINDOWS = "/terminate.ps1";
    private ProvisioningActivity.Id provisioningId;
    private final String cloudName;
    private final String vmCredentialsId;
    private final String azureCredentialsId;
    private final String sshPrivateKey;
    private final String sshPassPhrase;
    private final String jvmOptions;
    private boolean shutdownOnIdle;
    private final int retentionTimeInMin;
    private final String agentLaunchMethod;
    private final String initScript;
    private final String terminateScript;
    private final String deploymentName;
    private final OperatingSystemTypes osType;
    private String publicDNSName;
    private String publicIP;
    private String privateIP;
    private int sshPort;
    private String sshConfig;
    private final Node.Mode mode;
    private String templateName;
    private CleanUpAction cleanUpAction;
    private Localizable cleanUpReason;
    private String resourceGroupName;
    private static final Logger LOGGER = Logger.getLogger(AzureVMAgent.class.getName());
    private final boolean executeInitScriptAsRoot;
    private final boolean doNotUseMachineIfInitFails;
    private final boolean enableMSI;
    private final boolean enableUAMI;
    private final boolean ephemeralOSDisk;
    private final boolean encryptionAtHost;
    private final String uamiID;
    private String javaPath;
    private String remotingOptions;
    private boolean eligibleForReuse;
    private final AzureVMAgentTemplate template;
    private long creationTime;
    private final Object publicIPAttachLock = new Object();

    @DataBoundConstructor
    public AzureVMAgent(String name, String templateName, String nodeDescription, OperatingSystemTypes osType, String remoteFS, int numExecutors, Node.Mode mode, String label, ComputerLauncher launcher, RetentionStrategy<AzureVMComputer> retentionStrategy, String fqdn, String cloudName, String vmCredentialsId, String sshPrivateKey, String sshPassPhrase, String sshConfig, String jvmOptions, boolean shutdownOnIdle, boolean eligibleForReuse, String deploymentName, int retentionTimeInMin, String initScript, String terminateScript, String azureCredentialsId, AzureCredentials.ServicePrincipal servicePrincipal, String agentLaunchMethod, CleanUpAction cleanUpAction, Localizable cleanUpReason, String resourceGroupName, boolean executeInitScriptAsRoot, boolean doNotUseMachineIfInitFails, boolean enableMSI, boolean enableUAMI, boolean ephemeralOSDisk, boolean encryptionAtHost, String uamiID, String javaPath, String remotingOptions, AzureVMAgentTemplate template) throws Descriptor.FormException, IOException {
        super(name, remoteFS, launcher);
        this.setNodeDescription(nodeDescription);
        this.setNumExecutors(numExecutors);
        this.setMode(mode);
        this.setLabelString(label);
        this.setRetentionStrategy(retentionStrategy);
        this.setNodeProperties(AzureVMAgent.getNodeProperties(fqdn, template));
        this.cloudName = cloudName;
        this.templateName = templateName;
        this.vmCredentialsId = vmCredentialsId;
        this.azureCredentialsId = azureCredentialsId;
        this.sshPrivateKey = sshPrivateKey;
        this.sshPassPhrase = sshPassPhrase;
        this.sshConfig = sshConfig;
        this.jvmOptions = jvmOptions;
        this.shutdownOnIdle = shutdownOnIdle;
        this.eligibleForReuse = eligibleForReuse;
        this.deploymentName = deploymentName;
        this.retentionTimeInMin = retentionTimeInMin;
        this.initScript = initScript;
        this.terminateScript = terminateScript;
        this.osType = osType;
        this.mode = mode;
        this.agentLaunchMethod = agentLaunchMethod;
        this.javaPath = javaPath == null ? "java" : javaPath;
        this.remotingOptions = remotingOptions;
        this.setCleanUpAction(cleanUpAction);
        this.setCleanUpReason(cleanUpReason);
        this.resourceGroupName = resourceGroupName;
        this.executeInitScriptAsRoot = executeInitScriptAsRoot;
        this.doNotUseMachineIfInitFails = doNotUseMachineIfInitFails;
        this.enableMSI = enableMSI;
        this.enableUAMI = enableUAMI;
        this.ephemeralOSDisk = ephemeralOSDisk;
        this.encryptionAtHost = encryptionAtHost;
        this.uamiID = uamiID;
        this.template = template;
        this.creationTime = System.currentTimeMillis();
    }

    private static List<NodeProperty<?>> getNodeProperties(String fqdn, AzureVMAgentTemplate template) {
        ArrayList nodeProperties = new ArrayList((Collection<NodeProperty<?>>)template.getNodeProperties());
        DescribableList<NodeProperty<?>, NodePropertyDescriptor> templateNodeProperties = template.getNodeProperties();
        EnvironmentVariablesNodeProperty envVarsNodeProperty = (EnvironmentVariablesNodeProperty)templateNodeProperties.get(EnvironmentVariablesNodeProperty.class);
        ArrayList<EnvironmentVariablesNodeProperty.Entry> newEntries = new ArrayList<EnvironmentVariablesNodeProperty.Entry>();
        if (envVarsNodeProperty != null) {
            nodeProperties.remove(envVarsNodeProperty);
            newEntries.addAll(envVarsNodeProperty.getEnv());
        }
        newEntries.add(new EnvironmentVariablesNodeProperty.Entry("FQDN", fqdn));
        nodeProperties.add((NodeProperty<?>)new EnvironmentVariablesNodeProperty(newEntries));
        return nodeProperties;
    }

    public AzureVMAgent(ProvisioningActivity.Id id, String name, String templateName, String nodeDescription, OperatingSystemTypes osType, String remoteFS, int numExecutors, Node.Mode mode, String label, String cloudName, String vmCredentialsId, String sshPrivateKey, String sshPassPhrase, String sshConfig, String jvmOptions, boolean shutdownOnIdle, boolean eligibleForReuse, String deploymentName, RetentionStrategy<AzureVMComputer> retentionStrategy, String initScript, String terminateScript, String azureCredentialsId, String agentLaunchMethod, CleanUpAction cleanUpAction, Localizable cleanUpReason, String resourceGroupName, boolean executeInitScriptAsRoot, boolean doNotUseMachineIfInitFails, boolean enableMSI, boolean enableUAMI, boolean ephemeralOSDisk, boolean encryptionAtHost, String uamiID, AzureVMAgentTemplate template, String fqdn, String javaPath, String remotingOptions) throws Descriptor.FormException, IOException {
        this(name, templateName, nodeDescription, osType, remoteFS, numExecutors, mode, label, agentLaunchMethod.equalsIgnoreCase("SSH") ? new AzureVMAgentSSHLauncher() : new JNLPLauncher(), retentionStrategy, fqdn, cloudName, vmCredentialsId, sshPrivateKey, sshPassPhrase, sshConfig, jvmOptions, shutdownOnIdle, eligibleForReuse, deploymentName, template.getRetentionTimeInMin(), initScript, terminateScript, azureCredentialsId, null, agentLaunchMethod, cleanUpAction, cleanUpReason, resourceGroupName, executeInitScriptAsRoot, doNotUseMachineIfInitFails, enableMSI, enableUAMI, ephemeralOSDisk, encryptionAtHost, uamiID, javaPath, remotingOptions, template);
        this.provisioningId = id;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    public String getJavaPath() {
        if (this.javaPath == null) {
            return "java";
        }
        return this.javaPath;
    }

    public String getRemotingOptions() {
        return this.remotingOptions;
    }

    public String getVMCredentialsId() {
        return this.vmCredentialsId;
    }

    public String getSshPrivateKey() {
        return this.sshPrivateKey;
    }

    public OperatingSystemTypes getOsType() {
        return this.osType;
    }

    public String getSshPassPhrase() {
        return this.sshPassPhrase;
    }

    public String getDeploymentName() {
        return this.deploymentName;
    }

    public CleanUpAction getCleanUpAction() {
        return this.cleanUpAction;
    }

    public Localizable getCleanUpReason() {
        return this.cleanUpReason;
    }

    private void setCleanUpAction(CleanUpAction cleanUpAction) {
        if (cleanUpAction == CleanUpAction.DEFAULT) {
            cleanUpAction = this.isShutdownOnIdle() ? CleanUpAction.SHUTDOWN : CleanUpAction.DELETE;
        }
        this.cleanUpAction = cleanUpAction;
    }

    private void setCleanUpReason(Localizable cleanUpReason) {
        this.cleanUpReason = cleanUpReason;
    }

    public void clearCleanUpAction() {
        this.setCleanUpAction(CleanUpAction.DEFAULT);
        this.setCleanUpReason(null);
        Computer computer = this.toComputer();
        if (computer != null) {
            computer.setTemporaryOfflineCause(null);
        }
    }

    public void blockCleanUpAction() {
        this.setCleanUpAction(CleanUpAction.BLOCK);
        this.setCleanUpReason(null);
    }

    public boolean isCleanUpBlocked() {
        return this.getCleanUpAction() == CleanUpAction.BLOCK;
    }

    public void setCleanUpAction(CleanUpAction action, Localizable reason) {
        if (action != CleanUpAction.DELETE && action != CleanUpAction.SHUTDOWN) {
            throw new IllegalStateException("Only use this method to set explicit cleanup operations");
        }
        AzureVMComputer computer = (AzureVMComputer)this.toComputer();
        if (computer != null) {
            if (action == CleanUpAction.SHUTDOWN) {
                computer.setTemporaryOfflineCause((OfflineCause)new OfflineCause.IdleOfflineCause());
            } else {
                computer.setTemporaryOfflineCause(OfflineCause.create((Localizable)reason));
            }
        }
        this.setCleanUpAction(action);
        this.setCleanUpReason(reason);
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public boolean isShutdownOnIdle() {
        return this.shutdownOnIdle;
    }

    public void setShutdownOnIdle(boolean shutdownOnIdle) {
        this.shutdownOnIdle = shutdownOnIdle;
    }

    public boolean isEligibleForReuse() {
        return this.eligibleForReuse;
    }

    public void setEligibleForReuse(boolean eligibleForReuse) {
        this.eligibleForReuse = eligibleForReuse;
    }

    public String getPublicDNSName() {
        return this.publicDNSName;
    }

    public void setPublicDNSName(String publicDNSName) {
        this.publicDNSName = publicDNSName;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public String getSshConfig() {
        return this.sshConfig;
    }

    public String getPublicIP() {
        return this.publicIP;
    }

    public void setPublicIP(String publicIP) {
        this.publicIP = publicIP;
    }

    public String getPrivateIP() {
        return this.privateIP;
    }

    public void setPrivateIP(String privateIP) {
        this.privateIP = privateIP;
    }

    public int getRetentionTimeInMin() {
        return this.retentionTimeInMin;
    }

    public String getInitScript() {
        return this.initScript;
    }

    public String getTerminateScript() {
        return this.terminateScript;
    }

    public String getAgentLaunchMethod() {
        return this.agentLaunchMethod;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    public boolean getExecuteInitScriptAsRoot() {
        return this.executeInitScriptAsRoot;
    }

    public boolean getDoNotUseMachineIfInitFails() {
        return this.doNotUseMachineIfInitFails;
    }

    public boolean isEnableMSI() {
        return this.enableMSI;
    }

    public boolean isEnableUAMI() {
        return this.enableUAMI;
    }

    public boolean isEphemeralOSDisk() {
        return this.ephemeralOSDisk;
    }

    public boolean isEncryptionAtHost() {
        return this.encryptionAtHost;
    }

    public AzureVMAgentTemplate getTemplate() {
        return this.template;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    protected void _terminate(TaskListener arg0) throws IOException, InterruptedException {
        LOGGER.log(Level.INFO, "Terminate called for agent {0}", this.getNodeName());
        ProvisioningActivity activity = CloudStatistics.get().getActivityFor((TrackedItem)this);
        if (activity != null) {
            activity.enterIfNotAlready(ProvisioningActivity.Phase.COMPLETED);
        }
    }

    public AbstractCloudComputer<AzureVMAgent> createComputer() {
        LOGGER.log(Level.FINE, "Starting agent {0}", this.getDisplayName());
        return new AzureVMComputer(this);
    }

    @CheckForNull
    public AzureVMCloud getCloud() {
        return (AzureVMCloud)Jenkins.get().getCloud(this.cloudName);
    }

    public synchronized void shutdown(Localizable reason) {
        if (this.isEligibleForReuse()) {
            LOGGER.log(Level.INFO, "Agent {0} is shut down", this.getDisplayName());
            return;
        }
        LOGGER.log(Level.INFO, "Add suspended status for node {0}", this.getNodeName());
        SlaveComputer computer = this.getComputer();
        if (computer == null) {
            LOGGER.log(Level.INFO, "Could not retrieve computer for agent {0}", this.getDisplayName());
            return;
        }
        computer.setAcceptingTasks(false);
        computer.setTemporaryOfflineCause((OfflineCause)new OfflineCause.IdleOfflineCause());
        LOGGER.log(Level.INFO, "Shutting down agent {0}", this.getDisplayName());
        AzureVMManagementServiceDelegate serviceDelegate = this.getServiceDelegate();
        if (serviceDelegate != null) {
            serviceDelegate.shutdownVirtualMachine(this);
        }
        this.setEligibleForReuse(true);
    }

    public synchronized void deprovision(Localizable reason) throws Exception {
        SlaveComputer computer = this.getComputer();
        if (Jenkins.get().getNode(this.name) == null || computer == null) {
            return;
        }
        LOGGER.log(Level.INFO, "Deprovision called for agent {0}, for reason: {1}", new Object[]{this.getDisplayName(), reason == null ? "Unknown reason" : reason.toString()});
        computer.setAcceptingTasks(false);
        ComputerLauncher launcher = computer.getLauncher();
        if (launcher instanceof AzureVMAgentSSHLauncher) {
            AzureVMAgentSSHLauncher azureLauncher = (AzureVMAgentSSHLauncher)launcher;
            PrintStream terminateStream = new LogTaskListener(LOGGER, Level.INFO).getLogger();
            boolean isUnix = this.getOsType().equals((Object)OperatingSystemTypes.LINUX);
            boolean skipTerminateScript = StringUtils.isBlank((CharSequence)this.terminateScript);
            try {
                if (!this.isVMAliveOrHealthy()) {
                    LOGGER.log(Level.INFO, "Agent {0} is shut down, deleted, etc. Not attempting to connect", computer.getName());
                    skipTerminateScript = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.fine("Template terminate script, " + this.template.getTerminateScript());
            try {
                String command = isUnix ? "test -e ~/.azure-agent-terminate" : "dir C:\\.azure-agent-terminate";
                if (!skipTerminateScript && azureLauncher.executeRemoteCommand(this, command, terminateStream, isUnix) != 0) {
                    LOGGER.info("Terminate script present for " + computer.getName() + " preparing to execute script remotely");
                    if (isUnix) {
                        azureLauncher.copyFileToRemote(this, (InputStream)new ByteArrayInputStream(this.terminateScript.getBytes(StandardCharsets.UTF_8)), REMOTE_TERMINATE_FILE_NAME);
                    } else {
                        azureLauncher.copyFileToRemote(this, (InputStream)new ByteArrayInputStream(this.terminateScript.getBytes(StandardCharsets.UTF_8)), REMOTE_TERMINATE_FILE_NAME_WINDOWS);
                    }
                    command = isUnix ? "sh terminate.sh" : "powershell /terminate.ps1";
                    int exitStatus = azureLauncher.executeRemoteCommand(this, command, terminateStream, isUnix, this.executeInitScriptAsRoot);
                    if (exitStatus != 0) {
                        LOGGER.log(Level.SEVERE, "Terminate script failed: exit code={0} ", exitStatus);
                    } else {
                        LOGGER.fine("Terminate script was executed successfully");
                    }
                } else {
                    LOGGER.log(Level.FINE, "Skipping terminate script execution.");
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Got exception while deprovisioning", e);
            }
        }
        computer.disconnect(OfflineCause.create((Localizable)reason));
        AzureVMManagementServiceDelegate.terminateVirtualMachine(this);
        LOGGER.log(Level.INFO, "{0} has been deprovisioned. Remove node ...", this.getDisplayName());
        AzureVMCloud parentCloud = this.getCloud();
        if (parentCloud != null) {
            parentCloud.adjustApproximateVirtualMachineCount(-1, this.template);
        }
        Jenkins.get().removeNode((Node)this);
    }

    @CheckForNull
    public AzureVMManagementServiceDelegate getServiceDelegate() {
        AzureVMCloud cloud = this.getCloud();
        if (cloud != null) {
            return cloud.getServiceDelegate();
        }
        return null;
    }

    public boolean isVMAliveOrHealthy() throws Exception {
        AzureVMManagementServiceDelegate serviceDelegate = this.getServiceDelegate();
        if (serviceDelegate != null) {
            return serviceDelegate.isVMAliveOrHealthy(this);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String attachPublicIP() {
        if (!this.publicIP.isEmpty()) {
            return this.publicIP;
        }
        Object object = this.publicIPAttachLock;
        synchronized (object) {
            try {
                AzureVMCloud azureVMCloud = this.getCloud();
                AzureVMManagementServiceDelegate serviceDelegate = this.getServiceDelegate();
                if (azureVMCloud != null && serviceDelegate != null) {
                    serviceDelegate.attachPublicIP(this, azureVMCloud.getAzureAgentTemplate(this.templateName));
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, String.format("Error while trying to attach a public IP to %s", this.getNodeName()), e);
            }
            return this.publicIP;
        }
    }

    public String toString() {
        return "AzureVMAgent [\n\tcloudName=" + this.cloudName + "\n\tVMCredentialsId=" + this.vmCredentialsId + "\n\tjvmOptions=" + this.jvmOptions + "\n\tshutdownOnIdle=" + this.shutdownOnIdle + "\n\tretentionTimeInMin=" + this.retentionTimeInMin + "\n\tagentLaunchMethod=" + this.agentLaunchMethod + "\n\tinitScript=" + this.initScript + "\n\tdeploymentName=" + this.deploymentName + "\n\tosType=" + String.valueOf(this.osType) + "\n\tpublicDNSName=" + this.publicDNSName + "\n\tsshPort=" + this.sshPort + "\n\tmode=" + String.valueOf(this.mode) + "\n\ttemplateName=" + this.templateName + "\n\tcleanUpAction=" + String.valueOf((Object)this.cleanUpAction) + "\n]";
    }

    @Nullable
    public ProvisioningActivity.Id getId() {
        return this.provisioningId;
    }

    @Extension
    public static final class AzureVMAgentDescriptor
    extends Slave.SlaveDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Azure VM Agent";
        }

        public boolean isInstantiable() {
            return false;
        }

        @RequirePOST
        public FormValidation doAttachPublicIP(@QueryParameter String vmAgentName) {
            Jenkins.get().checkPermission(Computer.CONFIGURE);
            AzureVMAgent vmAgent = (AzureVMAgent)Jenkins.get().getNode(vmAgentName);
            String publicIP = "";
            if (vmAgent != null) {
                publicIP = vmAgent.attachPublicIP();
            }
            if (publicIP.isEmpty()) {
                return FormValidation.error((String)Messages.Azure_VM_Agent_Attach_Public_IP_Failure());
            }
            return FormValidation.ok((String)(Messages.Azure_VM_Agent_Attach_Public_IP_Success() + " ( " + publicIP + " ) "));
        }
    }
}

