/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.ClientStateListener;
import com.sshtools.client.SshClientContext;
import com.sshtools.common.events.Event;
import com.sshtools.common.events.EventServiceImplementation;
import com.sshtools.common.logger.Log;
import com.sshtools.common.publickey.SshPublicKeyFileFactory;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.synergy.nio.ConnectRequestFuture;
import com.sshtools.synergy.nio.LicenseException;
import com.sshtools.synergy.nio.SocketConnection;
import com.sshtools.synergy.ssh.ConnectionTaskWrapper;
import com.sshtools.synergy.ssh.Service;
import com.sshtools.synergy.ssh.SshContext;
import com.sshtools.synergy.ssh.SshTransport;
import com.sshtools.synergy.ssh.TransportProtocol;
import com.sshtools.synergy.ssh.components.SshKeyExchange;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;

public class TransportProtocolClient
extends TransportProtocol<SshClientContext> {
    Service pendingService;
    boolean proxyDone;

    public TransportProtocolClient(SshClientContext sshContext, ConnectRequestFuture connectFuture) throws LicenseException {
        super((SshContext)sshContext, connectFuture);
    }

    protected boolean canConnect(SocketConnection connection) {
        return true;
    }

    public boolean onSocketRead(ByteBuffer incomingData) {
        if (((SshClientContext)this.sshContext).isProxyEnabled() && !this.proxyDone) {
            return super.onSocketRead(incomingData);
        }
        return super.onSocketRead(incomingData);
    }

    protected void initializeKeyExchange(SshKeyExchange<SshClientContext> keyExchange, boolean firstPacketFollows, boolean useFirstPacket) throws IOException, SshException {
        keyExchange.init((SshTransport)this, this.localIdentification.toString().trim(), this.remoteIdentification.toString().trim(), this.localkex, this.remotekex, null, null, firstPacketFollows, useFirstPacket);
    }

    protected void onKeyExchangeInit() {
    }

    protected void completeKeyExchange(SshKeyExchange<SshClientContext> keyExchange) {
        block7: {
            try {
                this.hostKey = SshPublicKeyFileFactory.decodeSSH2PublicKey((byte[])keyExchange.getHostKey());
                if (((SshClientContext)this.getContext()).getHostKeyVerification() != null) {
                    Object host = this.getConnectFuture().getHost();
                    if (!Boolean.getBoolean("maverick.knownHosts.disablePortValidate") && this.getConnectFuture().getPort() != 22) {
                        host = "[" + (String)host + "]:" + this.getConnectFuture().getPort();
                    }
                    if (!((SshClientContext)this.getContext()).getHostKeyVerification().verifyHost((String)host, this.hostKey)) {
                        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777213, false).addAttribute("CONNECTION", (Object)this.getConnection()).addAttribute("HOST_KEY", (Object)new String(keyExchange.getHostKey())).addAttribute("HOST_PUBLIC_KEY", (Object)this.hostKey));
                        this.disconnect(9, "Host key not accepted");
                        throw new SshException("The host key was not accepted", 8);
                    }
                    if (!this.hostKey.verifySignature(keyExchange.getSignature(), keyExchange.getExchangeHash())) {
                        EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777213, false).addAttribute("CONNECTION", (Object)this.getConnection()).addAttribute("HOST_KEY", (Object)new String(keyExchange.getHostKey())).addAttribute("HOST_PUBLIC_KEY", (Object)this.hostKey));
                        this.disconnect(9, "Invalid host key signature");
                        throw new SshException("The host key signature is invalid", 3);
                    }
                }
                EventServiceImplementation.getInstance().fireEvent(new Event((Object)this, -16777212, true).addAttribute("CONNECTION", (Object)this.getConnection()).addAttribute("HOST_KEY", (Object)new String(keyExchange.getHostKey())).addAttribute("HOST_PUBLIC_KEY", (Object)this.hostKey));
                boolean first = !this.completedFirstKeyExchange;
                super.completeKeyExchange(keyExchange);
                ((SshClientContext)this.sshContext).keysExchanged(first);
            }
            catch (SshException | IOException e) {
                if (Log.isErrorEnabled()) {
                    Log.error((String)"Could not verify host key", (Throwable)e, (Object[])new Object[0]);
                }
                this.getConnectFuture().setLastError(e);
                this.getConnectFuture().done(false);
                if (this.disconnectStarted == null) break block7;
                this.disconnect(9, "The host key could not be verified.");
            }
        }
    }

    protected void onNewKeysReceived() {
        this.generateNewKeysClientIn();
    }

    protected void onNewKeysSent() {
        this.generateNewKeysClientOut();
    }

    protected String selectNegotiatedComponent(String remotelist, String locallist) throws IOException {
        return super.selectNegotiatedComponent(locallist, remotelist);
    }

    protected boolean processTransportMessage(int msgid, byte[] msg) throws IOException, SshException {
        switch (msgid) {
            case 6: {
                if (this.pendingService != null) {
                    this.activeService = this.pendingService;
                    this.pendingService = null;
                    this.activeService.start();
                }
                return true;
            }
        }
        return false;
    }

    public void setActiveService(Service service) {
        this.activeService = service;
    }

    public Service getActiveService() {
        return this.activeService;
    }

    public void startService(final Service service) {
        this.pendingService = service;
        this.postMessage(new SshMessage(){
            byte[] serviceNameBytes;
            {
                this.serviceNameBytes = TransportProtocol.getBytes((String)service.getName(), (String)TransportProtocol.CHARSET_ENCODING);
            }

            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                buf.put((byte)5);
                buf.putInt(this.serviceNameBytes.length);
                buf.put(this.serviceNameBytes);
                return true;
            }

            public void messageSent(Long sequenceNo) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Sent SSH_MSG_SERVICE_REQUEST {}", (Object[])new Object[]{service.getName()});
                }
            }
        });
    }

    protected void disconnected() {
        this.addTask(EVENTS, (ConnectionAwareTask)new ConnectionTaskWrapper((SshConnection)this.getConnection(), new Runnable(){

            @Override
            public void run() {
                for (ClientStateListener stateListener : ((SshClientContext)TransportProtocolClient.this.sshContext).getStateListeners()) {
                    stateListener.disconnected((SshConnection)TransportProtocolClient.this.con);
                }
            }
        }));
    }

    protected void onConnected() {
        if (Objects.isNull(this.con)) {
            this.con = ((SshClientContext)this.getContext()).getConnectionManager().registerTransport((TransportProtocol)this, (SshContext)((SshClientContext)this.sshContext));
            this.addTask(EVENTS, (ConnectionAwareTask)new ConnectionTaskWrapper((SshConnection)this.getConnection(), new Runnable(){

                @Override
                public void run() {
                    for (ClientStateListener listener : ((SshClientContext)TransportProtocolClient.this.getContext()).getStateListeners()) {
                        listener.connected((SshConnection)TransportProtocolClient.this.con);
                    }
                }
            }));
        }
    }

    protected void onDisconnected() {
        ((SshClientContext)this.getContext()).getConnectionManager().unregisterTransport((TransportProtocol)this);
    }

    public String getName() {
        return "transport-client";
    }

    protected String getExtensionNegotiationString() {
        return "ext-info-c";
    }

    protected boolean isExtensionNegotiationSupported() {
        return true;
    }

    protected boolean isServerMode() {
        return false;
    }
}

