/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.AuthenticationMessage;
import com.sshtools.client.ClientAuthenticator;
import com.sshtools.client.KeyboardInteractiveCallback;
import com.sshtools.client.KeyboardInteractivePrompt;
import com.sshtools.client.KeyboardInteractivePromptCompletor;
import com.sshtools.client.SimpleClientAuthenticator;
import com.sshtools.client.TransportProtocolClient;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.ConnectionAwareTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.sshd.SshMessage;
import com.sshtools.common.util.ByteArrayReader;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.synergy.ssh.ByteArrayMessage;
import com.sshtools.synergy.ssh.ConnectionTaskWrapper;
import com.sshtools.synergy.ssh.TransportProtocol;
import java.io.IOException;
import java.nio.ByteBuffer;

public class KeyboardInteractiveAuthenticator
extends SimpleClientAuthenticator
implements ClientAuthenticator {
    static final int SSH_MSG_USERAUTH_INFO_REQUEST = 60;
    static final int SSH_MSG_USERAUTH_INFO_RESPONSE = 61;
    KeyboardInteractiveCallback callback;
    TransportProtocolClient transport;
    String username;
    boolean completeFutureOnFailure = true;

    public KeyboardInteractiveAuthenticator(KeyboardInteractiveCallback callback) {
        this.callback = callback;
    }

    @Override
    public void authenticate(TransportProtocolClient transport, String username) {
        this.transport = transport;
        this.username = username;
        this.callback.init((SshConnection)transport.getConnection());
        transport.postMessage(new AuthenticationMessage(username, "ssh-connection", "keyboard-interactive"){

            @Override
            public boolean writeMessageIntoBuffer(ByteBuffer buf) {
                super.writeMessageIntoBuffer(buf);
                buf.putInt(0);
                buf.putInt(0);
                return true;
            }
        });
    }

    @Override
    public boolean processMessage(ByteArrayReader msg) throws IOException {
        switch (msg.read()) {
            case 60: {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"SSH_MSG_USERAUTH_INFO_REQUEST received", (Object[])new Object[0]);
                }
                final String name = msg.readString();
                final String instruction = msg.readString();
                String langtag = msg.readString();
                int num = (int)msg.readInt();
                final KeyboardInteractivePrompt[] prompts = new KeyboardInteractivePrompt[num];
                for (int i = 0; i < num; ++i) {
                    String prompt = msg.readString();
                    boolean echo = msg.read() == 1;
                    prompts[i] = new KeyboardInteractivePrompt(prompt, echo);
                }
                this.transport.addTask(TransportProtocol.CALLBACKS, (ConnectionAwareTask)new ConnectionTaskWrapper((SshConnection)this.transport.getConnection(), new Runnable(){

                    @Override
                    public void run() {
                        KeyboardInteractiveAuthenticator.this.callback.showPrompts(name, instruction, prompts, new KeyboardInteractivePromptCompletor(){

                            @Override
                            public void complete() {
                                ByteArrayWriter baw = new ByteArrayWriter();
                                try {
                                    baw.write(61);
                                    baw.writeInt(prompts.length);
                                    for (int i = 0; i < prompts.length; ++i) {
                                        baw.writeString(prompts[i].getResponse());
                                    }
                                    KeyboardInteractiveAuthenticator.this.transport.postMessage((SshMessage)new ByteArrayMessage(baw.toByteArray()){

                                        public void messageSent(Long sequenceNo) {
                                            if (Log.isDebugEnabled()) {
                                                Log.debug((String)"SSH_MSG_USERAUTH_INFO_RESPONSE sent", (Object[])new Object[0]);
                                            }
                                        }
                                    });
                                }
                                catch (IOException e) {
                                    Log.error((String)"Error during showPrompts", (Throwable)e, (Object[])new Object[0]);
                                    KeyboardInteractiveAuthenticator.this.failure();
                                    KeyboardInteractiveAuthenticator.this.transport.disconnect(13, "User cancelled auth.");
                                }
                                finally {
                                    try {
                                        baw.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }

                            @Override
                            public void cancel() {
                                KeyboardInteractiveAuthenticator.this.cancel();
                                KeyboardInteractiveAuthenticator.this.failure();
                                KeyboardInteractiveAuthenticator.this.transport.disconnect(13, "User cancelled auth.");
                            }
                        });
                    }
                }));
                return true;
            }
        }
        return false;
    }

    @Override
    public String getName() {
        return "keyboard-interactive";
    }
}

