/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.PublicKeyAuthenticator;
import com.sshtools.common.logger.Log;
import com.sshtools.common.publickey.InvalidPassphraseException;
import com.sshtools.common.publickey.SignatureGenerator;
import com.sshtools.common.publickey.SshKeyUtils;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ExternalKeyAuthenticator
extends PublicKeyAuthenticator {
    SignatureGenerator signatureGenerator;
    List<SshPublicKey> publickeys;
    SshPublicKey authenticatingKey = null;

    public ExternalKeyAuthenticator(SignatureGenerator signatureGenerator) throws IOException {
        this.signatureGenerator = signatureGenerator;
        this.publickeys = new ArrayList<SshPublicKey>(signatureGenerator.getPublicKeys());
    }

    @Override
    protected SignatureGenerator getSignatureGenerator() throws IOException, InvalidPassphraseException {
        return this.signatureGenerator;
    }

    @Override
    protected SshPublicKey getNextKey() throws IOException {
        return this.authenticatingKey;
    }

    @Override
    protected SshKeyPair getAuthenticatingKey() throws IOException, InvalidPassphraseException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean hasCredentialsRemaining() {
        if (!this.publickeys.isEmpty()) {
            this.authenticatingKey = this.publickeys.remove(0);
            if (Log.isDebugEnabled()) {
                try {
                    Log.debug((String)"Using key {}", (Object[])new Object[]{SshKeyUtils.getOpenSSHFormattedKey((SshPublicKey)this.authenticatingKey)});
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
            return true;
        }
        return false;
    }
}

