/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.net;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class CIDRNetwork {
    private int networkBits;
    private InetAddress networkAddress;
    private InetAddress startAddress;
    private InetAddress endAddress;

    public CIDRNetwork(String network) throws UnknownHostException {
        ByteBuffer maskBuffer;
        int index = ((String)network).indexOf("/");
        if (index == -1) {
            index = ((String)network).indexOf("\\");
        }
        if (index == -1) {
            network = ((String)network).indexOf(58) > -1 ? (String)network + "/128" : (String)network + "/32";
            index = ((String)network).indexOf("/");
        }
        try {
            this.networkBits = Integer.parseInt(((String)network).substring(index + 1));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("CIDR network setting invalid! " + (String)network);
        }
        this.networkAddress = InetAddress.getByName(((String)network).substring(0, index));
        int addressSize = this.networkAddress.getAddress().length;
        switch (addressSize) {
            case 4: {
                maskBuffer = ByteBuffer.allocate(addressSize);
                maskBuffer.putInt(-1);
                break;
            }
            case 16: {
                maskBuffer = ByteBuffer.allocate(addressSize);
                maskBuffer.putLong(-1L);
                maskBuffer.putLong(-1L);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid IP address format %s", network));
            }
        }
        BigInteger subnetMask = new BigInteger(1, maskBuffer.array()).not().shiftRight(this.networkBits);
        ByteBuffer b = ByteBuffer.wrap(this.networkAddress.getAddress());
        BigInteger ip = new BigInteger(1, b.array());
        BigInteger start = ip.and(subnetMask);
        BigInteger end = start.add(subnetMask.not());
        this.startAddress = InetAddress.getByAddress(CIDRNetwork.toBytes(start.toByteArray(), addressSize));
        this.endAddress = InetAddress.getByAddress(CIDRNetwork.toBytes(end.toByteArray(), addressSize));
    }

    private static byte[] toBytes(byte[] array, int targetSize) {
        ArrayList<Byte> newArr = new ArrayList<Byte>();
        for (int counter = 0; counter < targetSize && array.length - 1 - counter >= 0; ++counter) {
            newArr.add(0, array[array.length - 1 - counter]);
        }
        int size = newArr.size();
        for (int i = 0; i < targetSize - size; ++i) {
            newArr.add(0, (byte)0);
        }
        byte[] ret = new byte[newArr.size()];
        for (int i = 0; i < newArr.size(); ++i) {
            ret[i] = (Byte)newArr.get(i);
        }
        return ret;
    }

    public boolean isValidAddressForNetwork(String ipAddress) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(ipAddress);
        BigInteger start = new BigInteger(1, this.startAddress.getAddress());
        BigInteger end = new BigInteger(1, this.endAddress.getAddress());
        BigInteger target = new BigInteger(1, address.getAddress());
        int st = start.compareTo(target);
        int te = target.compareTo(end);
        return !(st != -1 && st != 0 || te != -1 && te != 0);
    }
}

