/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.config;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.components.ComponentFactory;
import com.sshtools.common.util.IOUtils;
import com.sshtools.common.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class AdaptiveConfiguration {
    public static final AdaptiveConfiguration DEFAULT = new AdaptiveConfiguration(new File(System.getProperty("maverick.configFile", "maverick.cfg")), new File(System.getProperty("maverick.configDir", "conf.d")), false);
    public static final String KEY_EXCHANGE = "Kex";
    public static final String PUBLIC_KEYS = "Publickeys";
    public static final String CIPHERS = "Ciphers";
    public static final String MACS = "Macs";
    public static final String COMPRESSION = "Compressions";
    private Map<String, String> globalConfig = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Map<String, String>> patternConfigs = new TreeMap<String, Map<String, String>>(String.CASE_INSENSITIVE_ORDER);
    private final File configFile;
    private final File configDir;

    public AdaptiveConfiguration() {
        this(null, null, false);
    }

    public AdaptiveConfiguration(File configFile) {
        this(configFile, null, true);
    }

    public AdaptiveConfiguration(File configFile, File configDir) {
        this(configFile, configDir, true);
    }

    private AdaptiveConfiguration(File configFile, File configDir, boolean load) {
        this.configFile = configFile;
        this.configDir = configDir;
        if (load) {
            try {
                this.resetConfiguration();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public void resetConfiguration() throws IOException {
        this.globalConfig = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        this.patternConfigs = new TreeMap<String, Map<String, String>>(String.CASE_INSENSITIVE_ORDER);
        if (Objects.nonNull(this.configFile) && this.configFile.exists()) {
            this.loadConfigurationFile(this.configFile);
        }
        if (Objects.nonNull(this.configDir) && this.configDir.exists()) {
            for (File file : this.configDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File path) {
                    return path.getName().endsWith(".cfg");
                }
            })) {
                this.loadConfigurationFile(file);
            }
        }
    }

    private void loadConfigurationFile(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            this.loadConfiguration(in);
        }
    }

    public void saveMatchingConfiguration(String match, String keyexchange, String publickey, String cipher, String mac, String compression) throws IOException {
        if (this.getBoolean("LastKnownGoodConfiguration", false, match)) {
            this.setPatternConfig(match, KEY_EXCHANGE, keyexchange);
            this.setPatternConfig(match, PUBLIC_KEYS, publickey);
            this.setPatternConfig(match, CIPHERS, cipher);
            this.setPatternConfig(match, MACS, mac);
            this.setPatternConfig(match, COMPRESSION, compression);
            this.saveConfig();
        }
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        for (String key : this.globalConfig.keySet()) {
            writer.write(key);
            writer.write(" ");
            writer.write(this.globalConfig.get(key));
            writer.write(System.lineSeparator());
        }
        writer.write(System.lineSeparator());
        for (String key : this.patternConfigs.keySet()) {
            writer.write("Match ");
            writer.write(key);
            writer.write(System.lineSeparator());
            Map<String, String> pattern = this.patternConfigs.get(key);
            for (String k : pattern.keySet()) {
                writer.write(" ");
                writer.write(k);
                writer.write(" ");
                writer.write(pattern.get(k));
                writer.write(System.lineSeparator());
            }
            writer.write(System.lineSeparator());
        }
        return writer.toString();
    }

    public void saveConfig() throws IOException {
        if (Objects.isNull(this.configFile)) {
            throw new IOException("Cannot save configuration because there is no file set");
        }
        IOUtils.writeStringToFile((File)this.configFile, (String)this.toString(), (String)"UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfiguration(InputStream in) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                if (line.toLowerCase().startsWith("match ")) break;
                String key = this.before(line);
                if (key.startsWith("#") || !Utils.isNotBlank((String)key)) continue;
                String value = this.after(line);
                this.setGlobalConfig(key, value);
            }
            while (line != null && line.toLowerCase().startsWith("match ")) {
                String matchValue = this.after(line);
                while ((line = reader.readLine()) != null && !line.toLowerCase().startsWith("match ")) {
                    String key = this.before(line = line.trim());
                    if (key.startsWith("#") || !Utils.isNotBlank((String)key)) continue;
                    String value = this.after(line);
                    this.setPatternConfig(matchValue, key, value);
                }
            }
        }
    }

    private String before(String str) {
        String[] vals = str.trim().split("\\s+");
        if (vals.length > 0) {
            return vals[0];
        }
        throw new IllegalArgumentException(str + " does not contain elements separated by whitespace");
    }

    private String after(String str) {
        String key = this.before(str);
        int idx = str.indexOf(key);
        if (idx > -1) {
            return str.substring(idx + key.length()).trim();
        }
        throw new IllegalArgumentException(str + " does not contain elements separated by whitespace");
    }

    public String createAlgorithmList(String supportedList, String key, String ident, String hostname, String ... ignores) {
        List<String> supported = Arrays.asList(supportedList.split("."));
        String locallist = this.getPatternConfig(key, hostname, hostname);
        if (Utils.isBlank((String)locallist)) {
            locallist = this.getGlobalConfig(key);
        }
        if (Utils.isBlank((String)locallist)) {
            return supportedList;
        }
        ArrayList<String> results = new ArrayList<String>();
        for (String algorithm : locallist.split(",")) {
            if (!supported.contains(algorithm)) continue;
            results.add(algorithm);
        }
        return Utils.csv(results);
    }

    public String createAlgorithmList(ComponentFactory<?> factory, String key, String contextPreference, String ident, String hostname, String ... ignores) {
        String locallist = factory.filter(this.getPatternConfig(key, hostname, ident), new String[0]);
        if (Utils.isBlank((String)locallist)) {
            locallist = factory.filter(this.getGlobalConfig(key), new String[0]);
        }
        if (Utils.isBlank((String)locallist)) {
            locallist = factory.list(contextPreference, ignores);
        }
        return locallist;
    }

    public String getPatternConfig(String key, String ... values) {
        for (String value : values) {
            if (!Utils.isNotBlank((String)value)) continue;
            for (String pattern : this.patternConfigs.keySet()) {
                String result;
                if (!value.matches(pattern) || (result = this.patternConfigs.get(pattern).get(key)) == null) continue;
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Matched {} from pattern configuration {} [{}] with value {}", (Object[])new Object[]{key, value, pattern, result});
                }
                return result;
            }
            String result = this.getSystemProperty(this.formatKey(value, key));
            if (result == null) continue;
            return result;
        }
        return this.getGlobalConfig(key);
    }

    private String formatKey(String key1, String key2) {
        StringBuilder str = new StringBuilder();
        str.append(key1);
        str.append(".");
        str.append(key2);
        return str.toString();
    }

    private String getSystemProperty(String key) {
        String result = System.getProperty(key);
        if (result != null && Log.isDebugEnabled()) {
            Log.debug((String)"Matched {} from system property with value {}", (Object[])new Object[]{key, result});
        }
        return result;
    }

    public void setPatternConfig(String pattern, String key, String val) {
        if (!this.patternConfigs.containsKey(pattern)) {
            this.patternConfigs.put(pattern, new TreeMap(String.CASE_INSENSITIVE_ORDER));
        }
        this.patternConfigs.get(pattern).put(key, val);
    }

    public void setPatternConfig(String pattern, String key, boolean val) {
        this.setPatternConfig(pattern, key, String.valueOf(val));
    }

    public void setPatternConfig(String pattern, String key, int val) {
        this.setPatternConfig(pattern, key, String.valueOf(val));
    }

    public void setPatternConfig(String pattern, String key, long val) {
        this.setPatternConfig(pattern, key, String.valueOf(val));
    }

    public String getGlobalConfig(String key) {
        String result = this.globalConfig.get(key);
        if (result != null) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"Matched {} from global configuration with value {}", (Object[])new Object[]{key, result});
            }
            return result;
        }
        return this.getSystemProperty(this.formatKey("maverick", key));
    }

    public void setGlobalConfig(String key, String val) {
        this.globalConfig.put(key, val);
    }

    public void setGlobalConfig(String key, int val) {
        this.globalConfig.put(key, String.valueOf(val));
    }

    public void setGlobalConfig(String key, long val) {
        this.globalConfig.put(key, String.valueOf(val));
    }

    public void setGlobalConfig(String key, boolean value) {
        this.setGlobalConfig(key, String.valueOf(value));
    }

    public String getIdent(String remoteIdentification) {
        if (remoteIdentification.startsWith("SSH")) {
            String[] elements = remoteIdentification.split("-");
            if (elements.length == 3) {
                return elements[2].trim();
            }
            if (elements.length > 3) {
                String ident = elements[2];
                int idx = ident.indexOf(32);
                if (idx > -1) {
                    ident = ident.substring(0, idx);
                }
                return ident;
            }
        }
        Log.error((String)"Remote identification cannot be parsed to capture the remote nodes identity [{}]", (Object[])new Object[]{remoteIdentification});
        return "<unknown>";
    }

    public boolean getBoolean(String key, boolean defaultValue, String ... match) {
        String result = this.getPatternConfig(key, match);
        if (result == null) {
            return this.getBooleanOrDefault(key, defaultValue);
        }
        return this.parseBoolean(result);
    }

    private boolean parseBoolean(String val) {
        switch (val.toUpperCase()) {
            case "YES": 
            case "Y": 
            case "TRUE": {
                return true;
            }
        }
        return false;
    }

    public void setBoolean(String key, String pattern) {
        this.setPatternConfig(pattern, key, Boolean.TRUE.toString());
    }

    public void setBoolean(String key, String pattern, Boolean val) {
        this.setPatternConfig(pattern, key, val.toString());
    }

    public boolean getBooleanOrDefault(String key, boolean defaultValue) {
        String result = this.getGlobalConfig(key);
        if (result != null) {
            return this.parseBoolean(result);
        }
        return defaultValue;
    }

    public long getLong(String key, Long defaultValue, String ... match) {
        String result = this.getPatternConfig(key, match);
        if (result == null) {
            return this.getLongOrDefault(key, defaultValue);
        }
        return Long.parseLong(result);
    }

    private long getLongOrDefault(String key, long defaultValue) {
        String result = this.getGlobalConfig(key);
        if (result != null) {
            return Long.parseLong(result);
        }
        return defaultValue;
    }

    public int getInt(String key, int defaultValue, String ... match) {
        String result = this.getPatternConfig(key, match);
        if (result == null) {
            return this.getIntOrDefault(key, defaultValue);
        }
        return Integer.parseInt(result);
    }

    private int getIntOrDefault(String key, int defaultValue) {
        String result = this.getGlobalConfig(key);
        if (result != null) {
            return Integer.parseInt(result);
        }
        return defaultValue;
    }

    public long getByteSize(String key, String defaultValue, String ... match) {
        String result = this.getPatternConfig(key, match);
        if (result != null) {
            return IOUtils.fromByteSize((String)result);
        }
        return this.getByteSizeOrDefault(key, defaultValue);
    }

    private long getByteSizeOrDefault(String key, String defaultValue) {
        String result = this.getGlobalConfig(key);
        if (result != null) {
            return IOUtils.fromByteSize((String)result);
        }
        return IOUtils.fromByteSize((String)defaultValue);
    }

    public String getProperty(String key, String defaultValue, String ... match) {
        String result = this.getPatternConfig(key, match);
        if (result != null) {
            return result;
        }
        result = this.getGlobalConfig(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public void loadConfiguration(String cfg) throws IOException {
        this.loadConfiguration(IOUtils.toInputStream((String)cfg, (String)"UTF-8"));
    }

    static {
        try {
            DEFAULT.resetConfiguration();
        }
        catch (IOException e) {
            Log.error((String)"Failed to initialize AdaptiveConfiguration", (Throwable)e, (Object[])new Object[0]);
        }
    }
}

