/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.logger;

import com.sshtools.common.logger.FileWatchingCallback;
import com.sshtools.common.util.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class FileWatchingService
extends Thread {
    private static FileWatchingService instance = null;
    private AtomicBoolean stop = new AtomicBoolean(false);
    Map<Path, FileWatchingCallback> paths = new HashMap<Path, FileWatchingCallback>();
    WatchService service;

    public FileWatchingService() throws IOException {
        this.setName("FileWatchingService");
        this.setDaemon(true);
        this.service = FileSystems.getDefault().newWatchService();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                FileWatchingService.this.stopThread();
            }
        });
    }

    public static FileWatchingService getInstance() throws IOException {
        if (Objects.isNull(instance)) {
            instance = new FileWatchingService();
        }
        return instance;
    }

    public boolean isStopped() {
        return this.stop.get();
    }

    public void stopThread() {
        this.stop.set(true);
        IOUtils.closeStream((Closeable)this.service);
        this.interrupt();
    }

    public void register(Path path, FileWatchingCallback callback) throws IOException {
        this.paths.put(path, callback);
        path.getParent().register(this.service, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    public void doOnChange(Path path) {
        FileWatchingCallback callback = this.paths.get(path);
        if (Objects.nonNull(callback)) {
            callback.changed(path);
        }
    }

    @Override
    public void run() {
        try {
            while (!this.isStopped()) {
                WatchKey key;
                try {
                    key = this.service.poll(25L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (key == null) {
                    Thread.yield();
                    continue;
                }
                for (WatchEvent<?> event : key.pollEvents()) {
                    boolean valid;
                    WatchEvent.Kind<?> kind = event.kind();
                    WatchEvent<?> ev = event;
                    Path path = (Path)ev.context();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        Thread.yield();
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        this.doOnChange(path);
                    }
                    if (valid = key.reset()) continue;
                    break;
                }
                Thread.yield();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

