/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client;

import com.sshtools.client.PassphrasePrompt;
import com.sshtools.client.PublicKeyAuthenticator;
import com.sshtools.common.logger.Log;
import com.sshtools.common.publickey.InvalidPassphraseException;
import com.sshtools.common.publickey.SshKeyUtils;
import com.sshtools.common.publickey.SshPrivateKeyFile;
import com.sshtools.common.publickey.SshPrivateKeyFileFactory;
import com.sshtools.common.ssh.components.SshKeyPair;
import com.sshtools.common.ssh.components.SshPublicKey;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IdentityFileAuthenticator
extends PublicKeyAuthenticator {
    private List<Path> identities;
    private PassphrasePrompt passphrase;
    private Path currentPath;
    private SshPublicKey currentKey;
    private String lastPassphrase;

    public IdentityFileAuthenticator(Collection<Path> identities, PassphrasePrompt passphrase) {
        this.identities = new ArrayList<Path>(identities);
        this.passphrase = passphrase;
    }

    public IdentityFileAuthenticator(PassphrasePrompt passphrase) throws IOException {
        this.identities = IdentityFileAuthenticator.collectIdentities(true);
        this.passphrase = passphrase;
    }

    public String getPassphrase(String keyinfo) {
        return this.passphrase.getPasshrase(keyinfo);
    }

    public Path getCurrentPath() {
        return this.currentPath;
    }

    public SshPublicKey getCurrentKey() {
        return this.currentKey;
    }

    public static List<Path> collectIdentities(boolean onlyWellKnown) throws IOException {
        Path dir = Paths.get(System.getProperty("user.home"), ".ssh");
        if (onlyWellKnown) {
            return new ArrayList<Path>(Arrays.asList(dir.resolve("id_ed25519.pub"), dir.resolve("id_ed448.pub"), dir.resolve("id_rsa.pub"), dir.resolve("id_ecdsa.pub")));
        }
        PathMatcher filter = dir.getFileSystem().getPathMatcher("glob:**/*.pub");
        try (Stream<Path> stream = Files.list(dir);){
            List<Path> list = stream.filter(filter::matches).collect(Collectors.toList());
            return list;
        }
    }

    public synchronized void done(boolean success) {
        try {
            super.done(success);
        }
        finally {
            this.passphrase.completed(success, this.lastPassphrase, this);
        }
    }

    @Override
    protected SshPublicKey getNextKey() throws IOException {
        return this.currentKey;
    }

    @Override
    protected SshKeyPair getAuthenticatingKey() throws IOException, InvalidPassphraseException {
        Path name = this.currentPath.getName(this.currentPath.getNameCount() - 1);
        String keyinfo = name.toString();
        keyinfo = keyinfo.substring(0, keyinfo.length() - 4);
        String privatePath = this.currentPath.toAbsolutePath().toString();
        SshPrivateKeyFile file = SshPrivateKeyFileFactory.parse((Path)Paths.get(privatePath = privatePath.substring(0, privatePath.length() - 4), new String[0]));
        if (file.isPassphraseProtected()) {
            this.lastPassphrase = this.getPassphrase(keyinfo);
            return file.toKeyPair(this.lastPassphrase);
        }
        this.lastPassphrase = null;
        return file.toKeyPair(null);
    }

    @Override
    protected boolean hasCredentialsRemaining() {
        while (!this.identities.isEmpty()) {
            try {
                this.currentPath = this.identities.remove(0);
                if (!this.currentPath.toFile().exists()) continue;
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Trying identity file {}", (Object[])new Object[]{this.currentPath.toString()});
                }
                this.currentKey = SshKeyUtils.getPublicKey((Path)this.currentPath.toAbsolutePath());
                if (Log.isDebugEnabled()) {
                    Log.debug((String)"Authenticating with key {}", (Object[])new Object[]{SshKeyUtils.getFingerprint((SshPublicKey)this.currentKey)});
                }
                return true;
            }
            catch (IOException e) {
                Log.error((String)"Failed to parse identity file", (Throwable)e, (Object[])new Object[0]);
            }
        }
        return false;
    }
}

