/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.synergy.ssh;

import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.Channel;
import com.sshtools.common.ssh.ChannelEventListener;
import com.sshtools.common.ssh.ExecutorServiceProvider;
import com.sshtools.common.ssh.RequestFuture;
import com.sshtools.common.ssh.RequestFutureListener;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.common.util.IOUtils;
import com.sshtools.synergy.nio.ClientAcceptor;
import com.sshtools.synergy.nio.ListeningInterface;
import com.sshtools.synergy.ssh.ConnectionProtocol;
import com.sshtools.synergy.ssh.ForwardingChannel;
import com.sshtools.synergy.ssh.ForwardingChannelFactory;
import com.sshtools.synergy.ssh.SshContext;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class SocketListeningForwardingChannelFactoryImpl<T extends SshContext>
extends ClientAcceptor
implements ForwardingChannelFactory<T> {
    protected String addressToBind;
    protected int portToBind;
    protected ServerSocketChannel socketChannel;
    protected ConnectionProtocol<T> connection;
    protected SocketAddress addr;
    protected String channelType;
    protected ActiveTunnelManager<T> activeRemoteForwardings = new ActiveTunnelManager();

    public SocketListeningForwardingChannelFactoryImpl() {
        super(null);
    }

    @Override
    public ActiveTunnelManager<T> getActiveTunnelManager() {
        return this.activeRemoteForwardings;
    }

    @Override
    public boolean belongsTo(ConnectionProtocol<T> connection) {
        return this.connection != null && this.connection.equals(connection);
    }

    @Override
    public int bindInterface(String addressToBind, int portToBind, ConnectionProtocol<T> connection) throws IOException {
        return this.bindInterface(addressToBind, portToBind, connection, this.getChannelType());
    }

    @Override
    public int bindInterface(String addressToBind, int portToBind, ConnectionProtocol<?> connection, String channelType) throws IOException {
        this.addressToBind = addressToBind;
        this.portToBind = portToBind;
        this.connection = connection;
        this.channelType = channelType;
        this.addr = new InetSocketAddress(addressToBind, portToBind);
        this.socketChannel = ServerSocketChannel.open();
        try {
            this.socketChannel.configureBlocking(false);
            this.socketChannel.socket().setReuseAddress(true);
            if (connection.getContext().getReceiveBufferSize() > 0) {
                this.socketChannel.socket().setReceiveBufferSize(connection.getContext().getReceiveBufferSize());
            }
            ServerSocket socket = this.socketChannel.socket();
            socket.bind(this.addr, connection.getContext().getMaximumSocketsBacklogPerRemotelyForwardedConnection());
            connection.getContext().getEngine().registerAcceptor(this, this.socketChannel);
            this.portToBind = this.socketChannel.socket().getLocalPort();
            return this.portToBind;
        }
        catch (IOException e) {
            IOUtils.closeStream((Closeable)this.socketChannel);
            throw e;
        }
    }

    @Override
    public boolean finishAccept(SelectionKey key, ListeningInterface li) {
        block8: {
            try {
                final SocketChannel sc = this.socketChannel.accept();
                if (sc != null) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)(this.channelType + " forwarding socket accepted from " + ((InetSocketAddress)sc.socket().getRemoteSocketAddress()).getAddress().getHostAddress() + "/" + ((InetSocketAddress)sc.socket().getRemoteSocketAddress()).getAddress().getHostAddress() + ":" + ((InetSocketAddress)sc.socket().getRemoteSocketAddress()).getPort()), (Object[])new Object[0]);
                    }
                    sc.configureBlocking(false);
                    if (this.connection.getContext().getReceiveBufferSize() > 0) {
                        sc.socket().setReceiveBufferSize(this.connection.getContext().getReceiveBufferSize());
                    }
                    if (this.connection.getContext().getSendBufferSize() > 0) {
                        sc.socket().setSendBufferSize(this.connection.getContext().getSendBufferSize());
                    }
                    sc.socket().setKeepAlive(this.connection.getContext().getSocketOptionKeepAlive());
                    sc.socket().setTcpNoDelay(this.connection.getContext().getSocketOptionTcpNoDelay());
                    ForwardingChannel<ExecutorServiceProvider> channel = this.createChannel(this.channelType, this.connection.getTransport().getConnection(), this.addressToBind, this.portToBind, sc, this.connection.getContext());
                    channel.addEventListener(this.activeRemoteForwardings);
                    channel.getOpenFuture().addFutureListener(new RequestFutureListener(){

                        public void complete(RequestFuture future) {
                            if (!future.isSuccess()) {
                                if (Log.isDebugEnabled()) {
                                    Log.debug((String)"Channel could not be opened", (Object[])new Object[0]);
                                }
                                try {
                                    sc.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        }
                    });
                    this.connection.openChannel(channel);
                } else if (Log.isDebugEnabled()) {
                    Log.debug((String)"FORWARDING accept event fired but no socket was accepted", (Object[])new Object[0]);
                }
            }
            catch (IOException ex) {
                if (!Log.isDebugEnabled()) break block8;
                Log.debug((String)("Accept operation failed on " + this.addressToBind + ":" + this.portToBind), (Throwable)ex, (Object[])new Object[0]);
            }
        }
        return !this.socketChannel.isOpen();
    }

    protected abstract ForwardingChannel<T> createChannel(String var1, SshConnection var2, String var3, int var4, SocketChannel var5, T var6);

    @Override
    public void stopListening(boolean dropActiveTunnels) {
        this.stopAccepting();
        if (dropActiveTunnels) {
            this.activeRemoteForwardings.killAllTunnels();
        }
    }

    @Override
    public void stopAccepting() {
        try {
            this.socketChannel.close();
        }
        catch (Throwable e) {
            Log.error((String)"Error closing listening socket", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public static class ActiveTunnelManager<K extends SshContext>
    implements ChannelEventListener {
        List<Channel> activeTunnels = Collections.synchronizedList(new ArrayList());
        List<TunnelListener<K>> listeners = Collections.synchronizedList(new ArrayList());
        boolean killingTunnels = false;

        public void addListener(TunnelListener<K> listener) {
            this.listeners.add(listener);
        }

        public void removeListener(TunnelListener<K> listener) {
            this.listeners.remove(listener);
        }

        public List<Channel> getTunnels() {
            return this.activeTunnels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void killAllTunnels() {
            List<Channel> list = this.activeTunnels;
            synchronized (list) {
                this.killingTunnels = true;
                for (Channel channel : this.activeTunnels) {
                    try {
                        channel.close();
                    }
                    catch (Throwable throwable) {}
                }
                this.activeTunnels.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChannelOpen(Channel channel) {
            List<Channel> list = this.activeTunnels;
            synchronized (list) {
                if (!this.killingTunnels) {
                    this.activeTunnels.add(channel);
                }
                for (int i = this.listeners.size() - 1; i >= 0; --i) {
                    this.listeners.get(i).tunnelOpened((ForwardingChannel)channel);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChannelClose(Channel channel) {
            List<Channel> list = this.activeTunnels;
            synchronized (list) {
                if (!this.killingTunnels) {
                    this.activeTunnels.remove(channel);
                }
            }
        }

        public static interface TunnelListener<K extends SshContext> {
            public void tunnelOpened(ForwardingChannel<K> var1);
        }
    }
}

