/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.util;

import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.exceptions.AzureCloudException;
import com.microsoft.azure.vmagent.retry.NoRetryStrategy;
import com.microsoft.azure.vmagent.retry.RetryStrategy;
import com.microsoft.azure.vmagent.retry.RetryTask;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ExecutionEngine {
    public static <T> T executeWithNoRetry(Callable<T> task) throws AzureCloudException {
        return ExecutionEngine.executeWithRetry(task, new NoRetryStrategy());
    }

    public static <T> T executeWithRetry(Callable<T> task, RetryStrategy retryStrategy) throws AzureCloudException {
        Future<T> result = AzureVMCloud.getThreadPool().submit(new RetryTask<T>(task, retryStrategy));
        try {
            if (retryStrategy.getMaxTimeoutInSeconds() == 0) {
                return result.get();
            }
            return result.get(retryStrategy.getMaxTimeoutInSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            throw AzureCloudException.create("Operation timed out: ", timeoutException);
        }
        catch (Exception ex) {
            throw AzureCloudException.create(ex);
        }
    }

    public <T> Future<T> executeAsync(Callable<T> task, RetryStrategy retryStrategy) throws AzureCloudException {
        return AzureVMCloud.getThreadPool().submit(new RetryTask<T>(task, retryStrategy));
    }
}

