/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.retry;

import com.microsoft.azure.vmagent.exceptions.AzureCloudException;
import com.microsoft.azure.vmagent.retry.RetryStrategy;
import com.microsoft.azure.vmagent.util.AzureUtil;

public class ExponentialRetryStrategy
implements RetryStrategy {
    private static final int DEFAULT_MAX_RETRIES = 5;
    private static final int DEFAULT_MAX_WAIT_INTERVAL_IN_SECONDS = 10;
    private int currentRetryCount = 0;
    private int maxRetries = 5;
    private int maxWaitIntervalInSec = 10;

    public ExponentialRetryStrategy() {
    }

    public ExponentialRetryStrategy(int maxRetries, int maxWaitIntervalInSec) {
        this.maxRetries = maxRetries;
        this.maxWaitIntervalInSec = maxWaitIntervalInSec;
    }

    @Override
    public void handleRetry(Exception e) throws AzureCloudException {
        ++this.currentRetryCount;
        if (this.canRetry(this.currentRetryCount, e)) {
            try {
                Thread.sleep(this.getWaitPeriodInSeconds(this.currentRetryCount, e) * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean canRetry(int retryCount, Exception e) throws AzureCloudException {
        if (retryCount >= this.maxRetries) {
            throw AzureCloudException.create("Exceeded maximum retry count " + this.maxRetries, e);
        }
        return AzureUtil.isHostNotFound(e.getMessage()) || AzureUtil.isConflictError(e.getLocalizedMessage());
    }

    @Override
    public int getWaitPeriodInSeconds(int retryCount, Exception e) {
        return this.calculateWaitInterval(retryCount);
    }

    @Override
    public int getMaxTimeoutInSeconds() {
        return 0;
    }

    @Override
    public void reset() {
        this.currentRetryCount = 0;
        this.maxRetries = 5;
        this.maxWaitIntervalInSec = 10;
    }

    public int calculateWaitInterval(int retryCount) {
        int incrementDelta = (int)(Math.pow(2.0, retryCount) - 1.0);
        return Math.min(incrementDelta, this.maxWaitIntervalInSec);
    }
}

