/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.AzureVMCloud;
import com.microsoft.azure.vmagent.AzureVMCloudBaseRetentionStrategy;
import com.microsoft.azure.vmagent.AzureVMComputer;
import com.microsoft.azure.vmagent.AzureVMManagementServiceDelegate;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.util.CleanUpAction;
import com.microsoft.azure.vmagent.util.TemplateUtil;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Executor;
import hudson.model.ExecutorListener;
import hudson.model.Queue;
import hudson.slaves.AbstractCloudComputer;
import hudson.slaves.RetentionStrategy;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AzureVMCloudPoolRetentionStrategy
extends AzureVMCloudBaseRetentionStrategy
implements ExecutorListener {
    private static final long serialVersionUID = 1577788691L;
    private final long retentionMillis;
    private final int poolSize;
    private boolean singleUseAgents;
    private static final long IDLE_LIMIT_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private static final Logger LOGGER = Logger.getLogger(AzureVMManagementServiceDelegate.class.getName());
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public AzureVMCloudPoolRetentionStrategy(int retentionInHours, int poolSize) {
        retentionInHours = Math.max(retentionInHours, 0);
        this.retentionMillis = TimeUnit.HOURS.toMillis(retentionInHours);
        this.poolSize = Math.max(poolSize, 0);
    }

    public long check(final AzureVMComputer agentComputer) {
        AzureVMAgent agentNode = (AzureVMAgent)agentComputer.getNode();
        if (agentNode == null) {
            return 1L;
        }
        AzureVMCloud cloud = agentNode.getCloud();
        if (cloud == null) {
            LOGGER.log(Level.INFO, "Delete VM {0} for cloud not found", (Object)agentComputer);
            Computer.threadPoolForRemoting.submit(new Runnable(){

                @Override
                public void run() {
                    AzureVMCloudPoolRetentionStrategy.tryDeleteWhenIdle(agentComputer);
                }
            });
            return 1L;
        }
        AzureVMCloud currentCloud = cloud;
        AzureVMAgentTemplate currentTemplate = null;
        boolean isContainsTemplate = false;
        for (AzureVMAgentTemplate template : currentCloud.getVmTemplates()) {
            if (!(template.getRetentionStrategy() instanceof AzureVMCloudPoolRetentionStrategy) || !TemplateUtil.checkSame(template, agentNode.getTemplate())) continue;
            isContainsTemplate = true;
            currentTemplate = template;
            break;
        }
        if (!isContainsTemplate) {
            LOGGER.log(Level.INFO, "Delete VM {0} for template {1} not found", new Object[]{agentComputer, agentNode.getTemplate().getTemplateName()});
            Computer.threadPoolForRemoting.submit(new Runnable(){

                @Override
                public void run() {
                    AzureVMCloudPoolRetentionStrategy.tryDeleteWhenIdle(agentComputer);
                }
            });
            return 1L;
        }
        if (this.retentionMillis != 0L && System.currentTimeMillis() - agentNode.getCreationTime() > this.retentionMillis) {
            LOGGER.log(Level.INFO, "Delete VM {0} for timeout", (Object)agentComputer);
            Computer.threadPoolForRemoting.submit(new Runnable(){

                @Override
                public void run() {
                    AzureVMCloudPoolRetentionStrategy.tryDeleteWhenIdle(agentComputer);
                }
            });
            return 1L;
        }
        final int currentPoolSize = ((AzureVMCloudPoolRetentionStrategy)currentTemplate.getRetentionStrategy()).getPoolSize();
        Computer.threadPoolForRemoting.submit(new Runnable(){

            @Override
            public void run() {
                AzureVMCloudPoolRetentionStrategy.checkPoolSizeAndDelete(agentComputer, currentPoolSize);
            }
        });
        return 1L;
    }

    private static void tryDeleteWhenIdle(AzureVMComputer agentComputer) {
        block3: {
            AzureVMAgent agentNode = (AzureVMAgent)agentComputer.getNode();
            if (agentComputer.isIdle() && agentNode != null && System.currentTimeMillis() - agentComputer.getIdleStartMilliseconds() > IDLE_LIMIT_MILLIS) {
                try {
                    agentNode.blockCleanUpAction();
                    agentNode.deprovision(Messages._Idle_Timeout_Delete());
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, String.format("Exception occurred while calling timeout on node %s", agentComputer.getName()), e);
                    AzureVMAgent node = (AzureVMAgent)agentComputer.getNode();
                    if (node == null) break block3;
                    node.setCleanUpAction(CleanUpAction.DELETE, Messages._Failed_Initial_Shutdown_Or_Delete());
                }
            }
        }
    }

    private static synchronized void checkPoolSizeAndDelete(AzureVMComputer agentComputer, int poolSize) {
        int count = 0;
        List<Computer> computers = Arrays.asList(Jenkins.get().getComputers());
        for (Computer computer : computers) {
            if (!(computer instanceof AzureVMComputer)) continue;
            AzureVMAgent patternAgentNode = (AzureVMAgent)((AzureVMComputer)computer).getNode();
            AzureVMAgent templateAgentNode = (AzureVMAgent)agentComputer.getNode();
            if (patternAgentNode == null || templateAgentNode == null || !TemplateUtil.checkSame(patternAgentNode.getTemplate(), templateAgentNode.getTemplate())) continue;
            ++count;
        }
        if (count > poolSize) {
            LOGGER.log(Level.INFO, "Delete VM {0} for pool size exceed limit: {1}", new Object[]{agentComputer, count});
            AzureVMCloudPoolRetentionStrategy.tryDeleteWhenIdle(agentComputer);
            return;
        }
    }

    public long getRetentionInHours() {
        return TimeUnit.MILLISECONDS.toHours(this.retentionMillis);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void taskAccepted(Executor executor, Queue.Task task) {
    }

    public void taskCompleted(Executor executor, Queue.Task task, long durationMS) {
        this.done(executor);
    }

    public void taskCompletedWithProblems(Executor executor, Queue.Task task, long durationMS, Throwable problems) {
        this.done(executor);
    }

    public void done(Executor executor) {
        AbstractCloudComputer computer = (AbstractCloudComputer)executor.getOwner();
        if (!(computer instanceof AzureVMComputer)) {
            return;
        }
        this.done((AzureVMComputer)computer);
    }

    public void done(AzureVMComputer computer) {
        if (!this.isSingleUseAgents()) {
            return;
        }
        AzureVMAgent agent = (AzureVMAgent)computer.getNode();
        if (agent == null) {
            return;
        }
        computer.setAcceptingTasks(false);
        if (agent.isShutdownOnIdle()) {
            LOGGER.log(Level.FINE, "Tagging VM to shutdown when idle: {0}", computer.getName());
            agent.setCleanUpAction(CleanUpAction.SHUTDOWN, Messages._Build_Action_Shutdown_Agent());
        } else {
            LOGGER.log(Level.FINE, "Tagging VM to delete when idle: {0}", computer.getName());
            agent.setCleanUpAction(CleanUpAction.DELETE, Messages._Build_Action_Delete_Agent());
        }
    }

    public boolean isSingleUseAgents() {
        return this.singleUseAgents;
    }

    @DataBoundSetter
    public void setSingleUseAgents(boolean singleUseAgents) {
        this.singleUseAgents = singleUseAgents;
    }

    public void start(AzureVMComputer azureComputer) {
        LOGGER.log(Level.INFO, "Starting azureComputer {0}", azureComputer.getDisplayName());
        azureComputer.connect(false);
        this.resetShutdownVMStatus((AzureVMAgent)azureComputer.getNode());
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends Descriptor<RetentionStrategy<?>> {
        @NonNull
        public String getDisplayName() {
            return "Azure VM Pool Retention Strategy";
        }
    }

    @Extension
    public static class DescriptorVisibilityFilterImpl
    extends DescriptorVisibilityFilter {
        public boolean filter(@CheckForNull Object context, @NonNull Descriptor descriptor) {
            return !(descriptor instanceof DescriptorImpl);
        }
    }
}

