/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMComputer;
import hudson.model.Computer;
import hudson.slaves.RetentionStrategy;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;

public abstract class AzureVMCloudBaseRetentionStrategy
extends RetentionStrategy<AzureVMComputer>
implements Serializable {
    private static final transient long LAPSE_START_JENKINS = TimeUnit.MINUTES.toMillis(3L);

    public void resetShutdownVMStatus(final AzureVMAgent agent) {
        Computer computer = Jenkins.get().toComputer();
        if (computer != null && System.currentTimeMillis() - computer.getConnectTime() < LAPSE_START_JENKINS) {
            Computer.threadPoolForRemoting.submit(new Runnable(){

                @Override
                public void run() {
                    if (agent.getTemplate().isShutdownOnIdle() && !agent.isCleanUpBlocked()) {
                        agent.setEligibleForReuse(false);
                        agent.shutdown(agent.getCleanUpReason());
                        agent.blockCleanUpAction();
                    }
                }
            });
        }
    }
}

