/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.sftp.extensions;

import com.sshtools.common.logger.Log;
import com.sshtools.common.sftp.SftpSubsystem;
import com.sshtools.common.sftp.extensions.AbstractMD5Extension;
import com.sshtools.common.util.ByteArrayReader;

public class MD5HandleExtension
extends AbstractMD5Extension {
    public static final String EXTENSION_NAME = "md5-hash-handle";

    public MD5HandleExtension() {
        super(EXTENSION_NAME);
    }

    @Override
    public void processMessage(ByteArrayReader msg, int requestId, SftpSubsystem sftp) {
        try {
            byte[] handle = msg.readBinaryString();
            long startOffset = msg.readUINT64().longValue();
            long length = msg.readUINT64().longValue();
            byte[] quickCheckHash = msg.readBinaryString();
            byte[] hashValue = this.doMD5Hash(handle, startOffset, length, quickCheckHash, sftp);
            this.sendReply(requestId, hashValue, sftp);
        }
        catch (Exception e) {
            Log.error((String)"Failed to process EXT_MD5_HASH_HANDLE", (Throwable)e, (Object[])new Object[0]);
            sftp.sendStatusMessage(requestId, 4, e.getMessage());
            return;
        }
    }
}

