/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.util;

import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.resources.models.Provider;
import com.azure.resourcemanager.resources.models.ProviderResourceType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public final class LocationCache {
    private static Map<String, Set<String>> regions = new HashMap<String, Set<String>>();
    private static final long EXPIRE_TIME_IN_MILLIS = TimeUnit.HOURS.toMillis(24L);
    private static Map<String, Long> achieveTimeInMillis = new HashMap<String, Long>();
    private static final Logger LOGGER = Logger.getLogger(LocationCache.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getLocation(AzureResourceManager azureClient, String key) throws Exception {
        if (regions.containsKey(key) && !regions.get(key).isEmpty() && System.currentTimeMillis() < achieveTimeInMillis.get(key) + EXPIRE_TIME_IN_MILLIS) {
            return regions.get(key);
        }
        Class<LocationCache> clazz = LocationCache.class;
        synchronized (LocationCache.class) {
            if (regions.containsKey(key) && !regions.get(key).isEmpty() && System.currentTimeMillis() < achieveTimeInMillis.get(key) + EXPIRE_TIME_IN_MILLIS) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return regions.get(key);
            }
            Provider byName = (Provider)azureClient.providers().getByName("Microsoft.Compute");
            ProviderResourceType resourceType = byName.resourceTypes().stream().filter(type -> type.resourceType().equalsIgnoreCase("virtualMachines")).findFirst().orElse(null);
            if (resourceType == null) {
                throw new RuntimeException("Virtual machines provider not registered");
            }
            HashSet<String> locations = new HashSet<String>(resourceType.locations());
            achieveTimeInMillis.put(key, System.currentTimeMillis());
            regions.put(key, locations);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return locations;
        }
    }

    private LocationCache() {
    }
}

