/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent.builders;

import com.microsoft.azure.vmagent.ImageReferenceType;

public class AdvancedImageFluent<T extends AdvancedImageFluent<T>> {
    private String imageReferenceType = ImageReferenceType.REFERENCE.getName();
    private String image;
    private String osType = "Linux";
    private String imageId;
    private String imagePublisher;
    private String imageOffer;
    private String imageSku;
    private String imageVersion = "latest";
    private String galleryName;
    private String galleryImageDefinition;
    private String galleryImageVersion;
    private boolean galleryImageSpecialized;
    private String gallerySubscriptionId;
    private String galleryResourceGroup;
    private String agentLaunchMethod = "SSH";
    private boolean preInstallSsh = true;
    private String sshConfig;
    private String initScript;
    private String terminateScript;
    private boolean executeInitScriptAsRoot = true;
    private boolean doNotUseMachineIfInitFails = true;
    private boolean enableMSI = false;
    private boolean enableUAMI = false;
    private String uamiID = "";
    private String virtualNetworkName;
    private String virtualNetworkResourceGroupName;
    private String subnetName;
    private boolean usePrivateIP = false;
    private String nsgName;
    private String jvmOptions;
    private String noOfParallelJobs = "1";
    private boolean templateDisabled = false;

    public T withCustomImage(String imageUrl) {
        this.imageReferenceType = ImageReferenceType.CUSTOM.getName();
        this.image = imageUrl;
        return (T)this;
    }

    public T withCustomManagedImage(String imageId) {
        this.imageReferenceType = ImageReferenceType.CUSTOM_IMAGE.getName();
        this.imageId = imageId;
        return (T)this;
    }

    public T withReferenceImage(String imagePublisher, String imageOffer, String imageSku, String imageVersion) {
        this.imageReferenceType = ImageReferenceType.REFERENCE.getName();
        this.imagePublisher = imagePublisher;
        this.imageOffer = imageOffer;
        this.imageSku = imageSku;
        this.imageVersion = imageVersion;
        return (T)this;
    }

    public T withGalleryImage(String galleryName, String galleryImageDefinition, String galleryImageVersion, boolean galleryImageSpecialized, String gallerySubscriptionId, String galleryResourceGroup) {
        this.imageReferenceType = ImageReferenceType.GALLERY.getName();
        this.galleryName = galleryName;
        this.galleryImageDefinition = galleryImageDefinition;
        this.galleryImageVersion = galleryImageVersion;
        this.galleryImageSpecialized = galleryImageSpecialized;
        this.gallerySubscriptionId = gallerySubscriptionId;
        this.galleryResourceGroup = galleryResourceGroup;
        return (T)this;
    }

    public T withOsType(String osType) {
        this.osType = osType;
        return (T)this;
    }

    public T withLaunchMethod(String launchMethod) {
        this.agentLaunchMethod = launchMethod;
        return (T)this;
    }

    public T withPreInstallSsh(boolean preInstallSsh) {
        this.preInstallSsh = preInstallSsh;
        return (T)this;
    }

    public T withSshConfig(String sshConfig) {
        this.sshConfig = sshConfig;
        return (T)this;
    }

    public T withInitScript(String initScript) {
        this.initScript = initScript;
        return (T)this;
    }

    public T withTerminateScript(String terminateScript) {
        this.terminateScript = terminateScript;
        return (T)this;
    }

    public T withRunScriptAsRoot(boolean executeInitScriptAsRoot) {
        this.executeInitScriptAsRoot = executeInitScriptAsRoot;
        return (T)this;
    }

    public T withDoNotUseMachineIfInitFails(boolean doNotUseMachineIfInitFails) {
        this.doNotUseMachineIfInitFails = doNotUseMachineIfInitFails;
        return (T)this;
    }

    public T withEnableMSI(boolean enableMSI) {
        this.enableMSI = enableMSI;
        return (T)this;
    }

    public T withEnableUAMI(boolean enableUAMI) {
        this.enableUAMI = enableUAMI;
        return (T)this;
    }

    public T withGetUamiID(String uamiID) {
        this.uamiID = uamiID;
        return (T)this;
    }

    public T withVirtualNetworkName(String virtualNetworkName) {
        this.virtualNetworkName = virtualNetworkName;
        return (T)this;
    }

    public T withVirtualNetworkResourceGroupName(String virtualNetworkResourceGroupName) {
        this.virtualNetworkResourceGroupName = virtualNetworkResourceGroupName;
        return (T)this;
    }

    public T withSubnetName(String subnetName) {
        this.subnetName = subnetName;
        return (T)this;
    }

    public T withUsePrivateIP(boolean usePrivateIP) {
        this.usePrivateIP = usePrivateIP;
        return (T)this;
    }

    public T withNetworkSecurityGroupName(String nsgName) {
        this.nsgName = nsgName;
        return (T)this;
    }

    public T withJvmOptions(String jvmOptions) {
        this.jvmOptions = jvmOptions;
        return (T)this;
    }

    public T withNumberOfExecutors(String noOfParallelJobs) {
        this.noOfParallelJobs = noOfParallelJobs;
        return (T)this;
    }

    public T withDisableTemplate(boolean templateDisabled) {
        this.templateDisabled = templateDisabled;
        return (T)this;
    }

    public String getImageReferenceType() {
        return this.imageReferenceType;
    }

    public String getImage() {
        return this.image;
    }

    public String getOsType() {
        return this.osType;
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getImagePublisher() {
        return this.imagePublisher;
    }

    public String getImageOffer() {
        return this.imageOffer;
    }

    public String getImageSku() {
        return this.imageSku;
    }

    public String getImageVersion() {
        return this.imageVersion;
    }

    public String getGalleryName() {
        return this.galleryName;
    }

    public String getGalleryImageDefinition() {
        return this.galleryImageDefinition;
    }

    public String getGalleryImageVersion() {
        return this.galleryImageVersion;
    }

    public boolean getGalleryImageSpecialized() {
        return this.galleryImageSpecialized;
    }

    public String getGallerySubscriptionId() {
        return this.gallerySubscriptionId;
    }

    public String getGalleryResourceGroup() {
        return this.galleryResourceGroup;
    }

    public String getAgentLaunchMethod() {
        return this.agentLaunchMethod;
    }

    public boolean isPreInstallSsh() {
        return this.preInstallSsh;
    }

    public String getSshConfig() {
        return this.sshConfig;
    }

    public String getInitScript() {
        return this.initScript;
    }

    public String getTerminateScript() {
        return this.terminateScript;
    }

    public boolean isExecuteInitScriptAsRoot() {
        return this.executeInitScriptAsRoot;
    }

    public boolean isDoNotUseMachineIfInitFails() {
        return this.doNotUseMachineIfInitFails;
    }

    public boolean isEnableMSI() {
        return this.enableMSI;
    }

    public boolean isEnableUAMI() {
        return this.enableUAMI;
    }

    public String getUamiID() {
        return this.uamiID;
    }

    public String getVirtualNetworkName() {
        return this.virtualNetworkName;
    }

    public String getVirtualNetworkResourceGroupName() {
        return this.virtualNetworkResourceGroupName;
    }

    public String getSubnetName() {
        return this.subnetName;
    }

    public boolean isUsePrivateIP() {
        return this.usePrivateIP;
    }

    public String getNsgName() {
        return this.nsgName;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    public String getNoOfParallelJobs() {
        return this.noOfParallelJobs;
    }

    public boolean isTemplateDisabled() {
        return this.templateDisabled;
    }
}

