/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.exception.ManagementError;
import com.azure.resourcemanager.AzureResourceManager;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.VirtualMachine;
import com.azure.resourcemanager.resources.models.Deployment;
import com.azure.resourcemanager.resources.models.DeploymentOperation;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.azure.resourcemanager.resources.models.StatusMessage;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.microsoft.azure.util.AzureCredentials;
import com.microsoft.azure.util.AzureImdsCredentials;
import com.microsoft.azure.vmagent.AzureTagPair;
import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMAgentPostBuildAction;
import com.microsoft.azure.vmagent.AzureVMAgentTemplate;
import com.microsoft.azure.vmagent.AzureVMCloudRetensionStrategy;
import com.microsoft.azure.vmagent.AzureVMCloudVerificationTask;
import com.microsoft.azure.vmagent.AzureVMComputer;
import com.microsoft.azure.vmagent.AzureVMDeploymentInfo;
import com.microsoft.azure.vmagent.AzureVMManagementServiceDelegate;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.exceptions.AzureCloudException;
import com.microsoft.azure.vmagent.remote.AzureVMAgentSSHLauncher;
import com.microsoft.azure.vmagent.util.AzureUtil;
import com.microsoft.azure.vmagent.util.CleanUpAction;
import com.microsoft.azure.vmagent.util.FailureStage;
import com.microsoft.azure.vmagent.util.PoolLock;
import com.microsoft.jenkins.credentials.AzureResourceManagerCache;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Functions;
import hudson.Main;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.logging.LogRecorder;
import hudson.logging.LogRecorderManager;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.slaves.SlaveComputer;
import hudson.util.ComboBoxModel;
import hudson.util.FormApply;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.StreamTaskListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.cloudstats.CloudStatistics;
import org.jenkinsci.plugins.cloudstats.ProvisioningActivity;
import org.jenkinsci.plugins.cloudstats.TrackedPlannedNode;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;

public class AzureVMCloud
extends Cloud {
    public static final Logger LOGGER = Logger.getLogger(AzureVMCloud.class.getName());
    private static final int DEFAULT_SSH_CONNECT_RETRY_COUNT = 3;
    private static final int SHH_CONNECT_RETRY_INTERNAL_SECONDS = 20;
    private final String credentialsId;
    private final int maxVirtualMachinesLimit;
    private String resourceGroupReferenceType;
    private String newResourceGroupName;
    private final String existingResourceGroupName;
    private transient String resourceGroupName;
    private List<AzureVMAgentTemplate> vmTemplates;
    @Deprecated
    private transient List<AzureVMAgentTemplate> instTemplates;
    private final int deploymentTimeout;
    private static ExecutorService threadPool;
    private transient String configurationStatus;
    @CheckForNull
    private transient Map<String, Integer> approximateVirtualMachineCountsByTemplate;
    private transient AzureResourceManager azureClient;
    private List<AzureTagPair> cloudTags;
    private transient Map<AzureVMAgent, AtomicInteger> agentLocks = new HashMap<AzureVMAgent, AtomicInteger>();

    @DataBoundConstructor
    public AzureVMCloud(String name, String azureCredentialsId, String maxVirtualMachinesLimit, String deploymentTimeout, String resourceGroupReferenceType, String newResourceGroupName, String existingResourceGroupName, List<AzureVMAgentTemplate> vmTemplates) {
        super(AzureVMCloud.getOrGenerateCloudName(name, azureCredentialsId, AzureVMCloud.getResourceGroupName(resourceGroupReferenceType, newResourceGroupName, existingResourceGroupName)));
        this.credentialsId = azureCredentialsId;
        this.resourceGroupReferenceType = resourceGroupReferenceType;
        this.newResourceGroupName = newResourceGroupName;
        this.existingResourceGroupName = existingResourceGroupName;
        this.resourceGroupName = AzureVMCloud.getResourceGroupName(resourceGroupReferenceType, newResourceGroupName, existingResourceGroupName);
        this.maxVirtualMachinesLimit = StringUtils.isBlank((CharSequence)maxVirtualMachinesLimit) || !maxVirtualMachinesLimit.matches("\\d+") ? 10 : Integer.parseInt(maxVirtualMachinesLimit);
        this.deploymentTimeout = StringUtils.isBlank((CharSequence)deploymentTimeout) || !deploymentTimeout.matches("\\d+") ? 1200 : Integer.parseInt(deploymentTimeout);
        this.configurationStatus = "unverified";
        this.setVmTemplates(vmTemplates == null ? Collections.emptyList() : vmTemplates);
        this.cloudTags = new ArrayList<AzureTagPair>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readResolve() {
        if (StringUtils.isBlank((CharSequence)this.newResourceGroupName) && StringUtils.isBlank((CharSequence)this.existingResourceGroupName) && StringUtils.isNotBlank((CharSequence)this.resourceGroupName)) {
            this.newResourceGroupName = this.resourceGroupName;
            this.resourceGroupReferenceType = "new";
        }
        this.resourceGroupName = AzureVMCloud.getResourceGroupName(this.resourceGroupReferenceType, this.newResourceGroupName, this.existingResourceGroupName);
        this.configurationStatus = "unverified";
        if (this.cloudTags == null) {
            this.cloudTags = new ArrayList<AzureTagPair>();
        }
        AzureVMCloud azureVMCloud = this;
        synchronized (azureVMCloud) {
            if (this.instTemplates != null && this.vmTemplates == null) {
                this.vmTemplates = this.instTemplates;
                this.instTemplates = null;
            }
            if (this.agentLocks == null) {
                this.agentLocks = new HashMap<AzureVMAgent, AtomicInteger>();
            }
            this.ensureVmTemplateList();
            for (AzureVMAgentTemplate template : this.vmTemplates) {
                template.addAzureCloudReference(this);
            }
        }
        return this;
    }

    public boolean canProvision(Cloud.CloudState cloudState) {
        AzureVMAgentTemplate template = this.getAzureAgentTemplate(cloudState.getLabel());
        if (template == null) {
            return false;
        }
        if (template.isTemplateDisabled()) {
            LOGGER.log(Level.INFO, "AzureVMCloud: canProvision: template {0} is marked has disabled, cannot provision agents", template.getTemplateName());
            return false;
        }
        return template.getTemplateProvisionStrategy().isEnabled();
    }

    public static synchronized ExecutorService getThreadPool() {
        if (threadPool == null) {
            threadPool = Executors.newCachedThreadPool();
        }
        return threadPool;
    }

    public Boolean isResourceGroupReferenceTypeEquals(String type) {
        if (this.resourceGroupReferenceType == null && type.equalsIgnoreCase("new")) {
            return true;
        }
        return type != null && type.equalsIgnoreCase(this.resourceGroupReferenceType);
    }

    public int getMaxVirtualMachinesLimit() {
        return this.maxVirtualMachinesLimit;
    }

    public static String getResourceGroupName(String type, String newName, String existingName) {
        if (StringUtils.isBlank((CharSequence)type) && StringUtils.isNotBlank((CharSequence)newName) || StringUtils.isNotBlank((CharSequence)type) && type.equalsIgnoreCase("new")) {
            return newName;
        }
        return existingName;
    }

    public String getCloudName() {
        return this.name;
    }

    public static String getOrGenerateCloudName(String name, String credentialId, String resourceGroupName) {
        return StringUtils.isBlank((CharSequence)name) ? AzureUtil.getCloudName(credentialId, resourceGroupName) : name;
    }

    public String getNewResourceGroupName() {
        return this.newResourceGroupName;
    }

    public String getExistingResourceGroupName() {
        return this.existingResourceGroupName;
    }

    public String getResourceGroupReferenceType() {
        return this.resourceGroupReferenceType;
    }

    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    public int getDeploymentTimeout() {
        return this.deploymentTimeout;
    }

    public String getAzureCredentialsId() {
        return this.credentialsId;
    }

    private void ensureVmTemplateList() {
        if (this.vmTemplates == null) {
            this.vmTemplates = new CopyOnWriteArrayList<AzureVMAgentTemplate>();
        }
    }

    public final void setVmTemplates(List<AzureVMAgentTemplate> newTemplates) {
        for (AzureVMAgentTemplate newTemplate : newTemplates) {
            newTemplate.addAzureCloudReference(this);
        }
        this.vmTemplates = new CopyOnWriteArrayList<AzureVMAgentTemplate>(newTemplates);
    }

    public void addTemplate(AzureVMAgentTemplate template) {
        template.addAzureCloudReference(this);
        this.ensureVmTemplateList();
        this.vmTemplates.add(template);
    }

    public void removeTemplate(AzureVMAgentTemplate t) {
        this.vmTemplates.remove(t);
    }

    public List<AzureTagPair> getCloudTags() {
        return this.cloudTags;
    }

    @DataBoundSetter
    public void setCloudTags(List<AzureTagPair> cloudTags) {
        this.cloudTags = cloudTags;
    }

    public List<AzureVMAgentTemplate> getVmTemplates() {
        this.ensureVmTemplateList();
        return Collections.unmodifiableList(this.vmTemplates);
    }

    public String getConfigurationStatus() {
        return this.configurationStatus;
    }

    public void setConfigurationStatus(String status) {
        this.configurationStatus = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getApproximateVirtualMachineCount() {
        AzureVMCloud azureVMCloud = this;
        synchronized (azureVMCloud) {
            int count = 0;
            if (this.approximateVirtualMachineCountsByTemplate != null) {
                for (Integer templateCount : this.approximateVirtualMachineCountsByTemplate.values()) {
                    count += templateCount.intValue();
                }
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    int getApproximateVirtualMachineCountForTemplate(AzureVMAgentTemplate template) {
        String templateName = template.getTemplateName();
        AzureVMCloud azureVMCloud = this;
        synchronized (azureVMCloud) {
            Integer templateCount;
            if (this.approximateVirtualMachineCountsByTemplate != null && (templateCount = this.approximateVirtualMachineCountsByTemplate.get(templateName)) != null) {
                return templateCount;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    void adjustApproximateVirtualMachineCount(int delta, AzureVMAgentTemplate template) {
        String templateName = template.getTemplateName();
        AzureVMCloud azureVMCloud = this;
        synchronized (azureVMCloud) {
            int currentCount = this.getApproximateVirtualMachineCountForTemplate(template);
            int newCount = currentCount + delta;
            if (this.approximateVirtualMachineCountsByTemplate == null) {
                if (newCount != 0) {
                    this.setCurrentVirtualMachineCount(Collections.singletonMap(templateName, newCount));
                }
            } else if (newCount == 0) {
                this.approximateVirtualMachineCountsByTemplate.remove(templateName);
                if (this.approximateVirtualMachineCountsByTemplate.isEmpty()) {
                    this.approximateVirtualMachineCountsByTemplate = null;
                }
            } else {
                this.approximateVirtualMachineCountsByTemplate.put(templateName, newCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Restricted(value={NoExternalUse.class})
    void setCurrentVirtualMachineCount(Map<String, Integer> countsIndexedByTemplateName) {
        AzureVMCloud azureVMCloud = this;
        synchronized (azureVMCloud) {
            if (countsIndexedByTemplateName == null || countsIndexedByTemplateName.isEmpty()) {
                this.approximateVirtualMachineCountsByTemplate = null;
            } else if (this.approximateVirtualMachineCountsByTemplate == null) {
                this.approximateVirtualMachineCountsByTemplate = new TreeMap<String, Integer>(countsIndexedByTemplateName);
            } else {
                this.approximateVirtualMachineCountsByTemplate.clear();
                this.approximateVirtualMachineCountsByTemplate.putAll(countsIndexedByTemplateName);
            }
        }
    }

    public AzureVMAgentTemplate getAzureAgentTemplate(Label label) {
        LOGGER.log(Level.FINE, "AzureVMCloud: getAzureAgentTemplate: Retrieving agent template with label {0}", label);
        for (AzureVMAgentTemplate agentTemplate : this.vmTemplates) {
            LOGGER.log(Level.FINE, "AzureVMCloud: getAzureAgentTemplate: Found agent template {0}", agentTemplate.getTemplateName());
            if (agentTemplate.getUsageMode() == Node.Mode.NORMAL) {
                if (label != null && !label.matches(agentTemplate.getLabelDataSet())) continue;
                LOGGER.log(Level.FINE, "AzureVMCloud: getAzureAgentTemplate: {0} matches!", agentTemplate.getTemplateName());
                return agentTemplate;
            }
            if (agentTemplate.getUsageMode() != Node.Mode.EXCLUSIVE || label == null || !label.matches(agentTemplate.getLabelDataSet())) continue;
            LOGGER.log(Level.FINE, "AzureVMCloud: getAzureAgentTemplate: {0} matches!", agentTemplate.getTemplateName());
            return agentTemplate;
        }
        return null;
    }

    public AzureVMAgentTemplate getTemplate(String name) {
        return this.getAzureAgentTemplate(name);
    }

    public AzureVMAgentTemplate getAzureAgentTemplate(String name) {
        return this.getVmTemplates().stream().filter(t -> name.equals(t.getTemplateName())).findFirst().orElse(null);
    }

    public AzureVMAgent createProvisionedAgent(ProvisioningActivity.Id provisioningId, AzureVMAgentTemplate template, String vmName, String deploymentName) throws AzureCloudException {
        int maxTries;
        LOGGER.log(Level.INFO, "Waiting for deployment {0} with VM {1} to be completed", new Object[]{deploymentName, vmName});
        int sleepTimeInSeconds = 5;
        int timeoutInSeconds = this.getDeploymentTimeout();
        int triesLeft = maxTries = timeoutInSeconds / 5;
        do {
            --triesLeft;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                AzureResourceManager newAzureClient = template.retrieveAzureCloudReference().getAzureClient();
                Deployment dep = (Deployment)newAzureClient.deployments().getByResourceGroup(template.getResourceGroupName(), deploymentName);
                if (dep == null) {
                    throw AzureCloudException.create(String.format("Could not find deployment %s", deploymentName));
                }
                PagedIterable ops = dep.deploymentOperations().list();
                for (DeploymentOperation op : ops) {
                    if (op.targetResource() == null) continue;
                    String resource = op.targetResource().resourceName();
                    String type = op.targetResource().resourceType();
                    String state = op.provisioningState();
                    if (!op.targetResource().resourceType().contains("virtualMachine") || !resource.equalsIgnoreCase(vmName)) continue;
                    if (!(state.equalsIgnoreCase("creating") || state.equalsIgnoreCase("succeeded") || state.equalsIgnoreCase("running"))) {
                        String statusCode = op.statusCode();
                        Object statusMessage = op.statusMessage();
                        String finalStatusMessage = AzureVMCloud.getStatusMessage(statusCode, statusMessage);
                        throw AzureCloudException.create(String.format("Deployment %s: %s:%s - %s", state, type, resource, finalStatusMessage));
                    }
                    if (state.equalsIgnoreCase("succeeded")) {
                        LOGGER.log(Level.FINE, "VM available: {0}", resource);
                        VirtualMachine vm = (VirtualMachine)newAzureClient.virtualMachines().getByResourceGroup(this.resourceGroupName, resource);
                        OperatingSystemTypes osType = vm.storageProfile().osDisk().osType();
                        AzureVMAgent newAgent = this.getServiceDelegate().parseResponse(provisioningId, vmName, deploymentName, template, osType);
                        this.getServiceDelegate().setVirtualMachineDetails(newAgent, template);
                        return newAgent;
                    }
                    LOGGER.log(Level.FINE, "Deployment {0} not yet finished ({1}): {2}:{3} - waited {4} seconds", new Object[]{deploymentName, state, type, resource, (maxTries - triesLeft) * 5});
                }
            }
            catch (AzureCloudException e) {
                throw e;
            }
            catch (Exception e) {
                throw AzureCloudException.create(e);
            }
        } while (triesLeft > 0);
        throw AzureCloudException.create(String.format("Deployment %s failed, max timeout reached (%d seconds)", deploymentName, timeoutInSeconds));
    }

    private static String getStatusMessage(String statusCode, Object statusMessage) {
        Object finalStatusMessage = statusCode;
        if (statusMessage != null) {
            if (statusMessage instanceof StatusMessage) {
                ManagementError error = ((StatusMessage)statusMessage).error();
                finalStatusMessage = (String)finalStatusMessage + " - " + error.getMessage();
            } else {
                finalStatusMessage = (String)finalStatusMessage + " - " + String.valueOf(statusMessage);
            }
        }
        return finalStatusMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<NodeProvisioner.PlannedNode> provision(Cloud.CloudState cloudState, int workLoad) {
        LOGGER.log(Level.FINE, "Starting for label {0} workLoad {1}", new Object[]{cloudState.getLabel(), workLoad});
        if (Jenkins.get().isQuietingDown()) {
            LOGGER.log(Level.FINE, "Skipping provision as Jenkins is in quiet-down");
            return Collections.emptyList();
        }
        AzureVMAgentTemplate template = this.getAzureAgentTemplate(cloudState.getLabel());
        int numberOfAgents = (workLoad + template.getNoOfParallelJobs() - 1) / template.getNoOfParallelJobs();
        ArrayList<NodeProvisioner.PlannedNode> plannedNodes = new ArrayList<NodeProvisioner.PlannedNode>(numberOfAgents);
        if (!template.getTemplateProvisionStrategy().isVerifiedPass()) {
            AzureVMCloudVerificationTask.verify(this.name, template.getTemplateName());
        }
        if (template.getTemplateProvisionStrategy().isVerifiedFailed()) {
            LOGGER.log(Level.INFO, "Template {0} has just verified failed", template.getTemplateName());
            if (StringUtils.isNotBlank((CharSequence)template.getTemplateStatusDetails())) {
                LOGGER.log(Level.INFO, template.getTemplateStatusDetails());
            }
            return new ArrayList<NodeProvisioner.PlannedNode>();
        }
        LOGGER.log(Level.FINE, "Checking for node reuse options");
        for (Computer agentComputer : Jenkins.get().getComputers()) {
            AzureVMAgent agentNode;
            if (numberOfAgents == 0) break;
            if (!(agentComputer instanceof AzureVMComputer)) continue;
            AzureVMComputer azureComputer = (AzureVMComputer)agentComputer;
            if (!agentComputer.isOffline() || (agentNode = (AzureVMAgent)azureComputer.getNode()) == null || !AzureVMCloud.isNodeEligibleForReuse(agentNode, template)) continue;
            LOGGER.log(Level.FINE, "Agent computer eligible for reuse {0}", agentComputer.getName());
            try {
                if (!AzureVMManagementServiceDelegate.virtualMachineExists(agentNode)) continue;
                --numberOfAgents;
                plannedNodes.add(new NodeProvisioner.PlannedNode(agentNode.getNodeName(), Computer.threadPoolForRemoting.submit(() -> {
                    AzureVMAgent azureVMAgent;
                    Object agentLock = this.getLockForAgent(agentNode);
                    try {
                        Object object = agentLock;
                        synchronized (object) {
                            SlaveComputer computer = agentNode.getComputer();
                            if (computer != null && computer.isOnline()) {
                                AzureVMAgent azureVMAgent2 = agentNode;
                                // MONITOREXIT @DISABLED, blocks:[0, 5, 10] lbl8 : MonitorExitStatement: MONITOREXIT : var5_5
                                this.releaseLockForAgent(agentNode);
                                return azureVMAgent2;
                            }
                            LOGGER.log(Level.INFO, "Found existing node, starting VM {0}", agentNode.getNodeName());
                        }
                    }
                    catch (Throwable throwable) {
                        this.releaseLockForAgent(agentNode);
                        throw throwable;
                    }
                    {
                        try {
                            this.getServiceDelegate().startVirtualMachine(agentNode);
                            this.getServiceDelegate().setVirtualMachineDetails(agentNode, template);
                            Jenkins.get().addNode((Node)agentNode);
                            azureComputer.setTemporaryOfflineCause(null);
                            if (agentNode.getAgentLaunchMethod().equalsIgnoreCase("SSH")) {
                                this.retrySshConnect(azureComputer);
                            } else {
                                this.waitUntilJNLPNodeIsOnline(agentNode);
                            }
                            LOGGER.info(String.format("Remove suspended status for node: %s", agentNode.getNodeName()));
                            azureComputer.setAcceptingTasks(true);
                            agentNode.clearCleanUpAction();
                            agentNode.setEligibleForReuse(false);
                        }
                        catch (Exception e) {
                            throw AzureCloudException.create(e);
                        }
                        template.getTemplateProvisionStrategy().success();
                        azureVMAgent = agentNode;
                    }
                    this.releaseLockForAgent(agentNode);
                    return azureVMAgent;
                }), template.getNoOfParallelJobs()));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, String.format("Failed to reuse agent computer %s", agentComputer.getName()), e);
                azureComputer.setAcceptingTasks(false);
                agentNode.setCleanUpAction(CleanUpAction.DEFAULT, Messages._Shutdown_Agent_Failed_To_Revive());
            }
        }
        if (numberOfAgents > 0) {
            if (template.getMaximumDeploymentSize() > 0 && numberOfAgents > template.getMaximumDeploymentSize()) {
                LOGGER.log(Level.FINE, "Reduced template {0} deployment from {1} to {2} nodes, due to its maximumDeploymentSize", new Object[]{template.getTemplateName(), numberOfAgents, template.getMaximumDeploymentSize()});
                numberOfAgents = template.getMaximumDeploymentSize();
            }
            try {
                int adjustedNumberOfAgents;
                AzureVMCloud azureVMCloud = this;
                synchronized (azureVMCloud) {
                    adjustedNumberOfAgents = this.calculateNumberOfAgentsToRequest(template, numberOfAgents);
                    this.adjustApproximateVirtualMachineCount(adjustedNumberOfAgents, template);
                }
                if (adjustedNumberOfAgents == 0) {
                    return plannedNodes;
                }
                this.doProvision(adjustedNumberOfAgents, plannedNodes, template);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, String.format("Failure provisioning agents about '%s'", template.getLabels()), e);
            }
        }
        LOGGER.log(Level.INFO, "{0} planned node(s)", plannedNodes.size());
        return plannedNodes;
    }

    @Restricted(value={NoExternalUse.class})
    int calculateNumberOfAgentsToRequest(AzureVMAgentTemplate template, int desiredNumberOfAgents) {
        int currentVMsForTemplate = Math.max(0, this.getApproximateVirtualMachineCountForTemplate(template));
        int maxVMsForTemplate = template.getMaxVirtualMachinesLimit() > 0 ? template.getMaxVirtualMachinesLimit() : Integer.MAX_VALUE;
        int currentVMsForCloud = Math.max(0, this.getApproximateVirtualMachineCount());
        int maxVMsForCloud = this.getMaxVirtualMachinesLimit() > 0 ? this.getMaxVirtualMachinesLimit() : Integer.MAX_VALUE;
        int maxBeforeTemplateLimit = Math.max(0, maxVMsForTemplate - currentVMsForTemplate);
        int maxBeforeCloudLimit = Math.max(0, maxVMsForCloud - currentVMsForCloud);
        int adjustedNumberOfAgents = Math.min(Math.min(maxBeforeTemplateLimit, maxBeforeCloudLimit), desiredNumberOfAgents);
        String templateMsg = desiredNumberOfAgents > maxBeforeTemplateLimit ? ", have template limit of {3} but have {4} VMs already so we can have {5} more" : ", currently have {4} VMs of this template";
        String cloudMsg = desiredNumberOfAgents > maxBeforeCloudLimit ? ", have cloud limit of {6} but have {7} VMs already so we can only have {8} more" : ", currently have {7} VMs in cloud";
        Object[] logParams = new Object[]{template.getTemplateName(), desiredNumberOfAgents, adjustedNumberOfAgents, maxVMsForTemplate, currentVMsForTemplate, maxBeforeTemplateLimit, maxVMsForCloud, currentVMsForCloud, maxBeforeCloudLimit};
        if (adjustedNumberOfAgents == 0) {
            LOGGER.log(Level.INFO, "Wanted to create {1} nodes from template {0} but cannot create any" + templateMsg + cloudMsg, logParams);
        } else if (adjustedNumberOfAgents < desiredNumberOfAgents) {
            LOGGER.log(Level.INFO, "Wanted to create {1} nodes from template {0} but can only create {2}" + templateMsg + cloudMsg, logParams);
        } else {
            LOGGER.log(Level.INFO, "Creating {1} nodes from template {0}" + templateMsg + cloudMsg, logParams);
        }
        return adjustedNumberOfAgents;
    }

    public void doProvision(int numberOfNewAgents, List<NodeProvisioner.PlannedNode> plannedNodes, AzureVMAgentTemplate template) {
        this.doProvision(numberOfNewAgents, plannedNodes, template, false);
    }

    public void doProvision(final int numberOfNewAgents, List<NodeProvisioner.PlannedNode> plannedNodes, final AzureVMAgentTemplate template, final boolean isProvisionOutside) {
        Callable<AzureVMDeploymentInfo> callableTask = new Callable<AzureVMDeploymentInfo>(){

            @Override
            public AzureVMDeploymentInfo call() throws AzureCloudException {
                try {
                    return template.provisionAgents((TaskListener)new StreamTaskListener((OutputStream)System.out, Charset.defaultCharset()), numberOfNewAgents);
                }
                catch (AzureCloudException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw AzureCloudException.create(e);
                }
            }
        };
        final Future<AzureVMDeploymentInfo> deploymentFuture = AzureVMCloud.getThreadPool().submit(callableTask);
        int i = 0;
        while (i < numberOfNewAgents) {
            final int index = i++;
            final ProvisioningActivity.Id provisioningId = new ProvisioningActivity.Id(this.name, template.getTemplateName());
            plannedNodes.add((NodeProvisioner.PlannedNode)new TrackedPlannedNode(provisioningId, template.getNoOfParallelJobs(), Computer.threadPoolForRemoting.submit(new Callable<Node>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Node call() throws AzureCloudException {
                    try {
                        AzureVMAgent agent;
                        AzureVMDeploymentInfo info;
                        PoolLock.provisionLock(template);
                        if (isProvisionOutside) {
                            CloudStatistics.ProvisioningListener.get().onStarted(provisioningId);
                        }
                        try {
                            info = (AzureVMDeploymentInfo)deploymentFuture.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            this.handleFailure(template, null, e, FailureStage.DEPLOYMENT);
                            throw AzureCloudException.create(e);
                        }
                        String deploymentName = info.getDeploymentName();
                        String vmBaseName = info.getVmBaseName();
                        String vmName = String.format("%s%d", vmBaseName, index);
                        try {
                            agent = AzureVMCloud.this.createProvisionedAgent(provisioningId, template, vmName, deploymentName);
                        }
                        catch (AzureCloudException e) {
                            LOGGER.log(Level.SEVERE, String.format("Failure creating provisioned agent '%s'", vmName), e);
                            this.handleFailure(template, vmName, e, FailureStage.PROVISIONING);
                            throw e;
                        }
                        try {
                            LOGGER.log(Level.FINE, "Adding agent {0} to Jenkins nodes", agent.getNodeName());
                            try {
                                agent.blockCleanUpAction();
                                Jenkins.get().addNode((Node)agent);
                                Computer computer = agent.toComputer();
                                if (agent.getAgentLaunchMethod().equalsIgnoreCase("SSH") && computer != null) {
                                    computer.connect(false).get();
                                } else if (agent.getAgentLaunchMethod().equalsIgnoreCase("JNLP")) {
                                    AzureVMCloud.this.waitUntilJNLPNodeIsOnline(agent);
                                }
                            }
                            finally {
                                agent.clearCleanUpAction();
                            }
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, String.format("Failure to in post-provisioning for '%s'", vmName), e);
                            this.handleFailure(template, vmName, e, FailureStage.POSTPROVISIONING);
                            try {
                                Jenkins.get().removeNode((Node)agent);
                            }
                            catch (IOException nodeRemoveEx) {
                                LOGGER.log(Level.SEVERE, String.format("Failure removing Jenkins node for '%s'", vmName), nodeRemoveEx);
                            }
                            throw AzureCloudException.create(e);
                        }
                        if (isProvisionOutside) {
                            CloudStatistics.ProvisioningListener.get().onComplete(provisioningId, (Node)agent);
                        }
                        template.getTemplateProvisionStrategy().success();
                        AzureVMAgent azureVMAgent = agent;
                        return azureVMAgent;
                    }
                    catch (AzureCloudException e) {
                        if (isProvisionOutside) {
                            CloudStatistics.ProvisioningListener.get().onFailure(provisioningId, (Throwable)e);
                        }
                        throw e;
                    }
                    finally {
                        PoolLock.provisionUnlock(template);
                    }
                }

                private void handleFailure(AzureVMAgentTemplate template2, String vmName, Exception e, FailureStage stage) {
                    if (vmName != null) {
                        try {
                            AzureVMCloud.this.getServiceDelegate().terminateVirtualMachine(vmName, template2.getResourceGroupName(), template2.getUsePrivateIP());
                        }
                        catch (AzureCloudException terminateEx) {
                            LOGGER.log(Level.SEVERE, String.format("Failure terminating previous failed agent '%s'", vmName), terminateEx);
                        }
                    }
                    template2.retrieveAzureCloudReference().adjustApproximateVirtualMachineCount(-1, template2);
                    template2.handleTemplateProvisioningFailure(e.getMessage(), stage);
                }
            })));
        }
    }

    private void retrySshConnect(AzureVMComputer azureComputer) throws ExecutionException, InterruptedException {
        int count = 0;
        while (true) {
            try {
                azureComputer.connect(false).get();
                return;
            }
            catch (InterruptedException | ExecutionException e) {
                if (count >= 3) {
                    throw e;
                }
                LOGGER.warning(String.format("Fail to connect %s with SSH for %s", azureComputer.getName(), e.getMessage()));
                ++count;
                TimeUnit.SECONDS.sleep(20L);
                continue;
            }
            break;
        }
    }

    private void waitUntilJNLPNodeIsOnline(final AzureVMAgent agent) throws AzureCloudException {
        LOGGER.log(Level.INFO, "Azure Cloud: waitUntilOnline: for agent {0}", agent.getDisplayName());
        Callable<String> callableTask = new Callable<String>(){

            @Override
            public String call() {
                try {
                    Computer computer = agent.toComputer();
                    if (computer != null) {
                        computer.waitUntilOnline();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return "success";
            }
        };
        Future<String> future = AzureVMCloud.getThreadPool().submit(callableTask);
        try {
            int timeoutInMinutes = 30;
            String result = future.get(30L, TimeUnit.MINUTES);
            LOGGER.log(Level.INFO, "Azure Cloud: waitUntilOnline: node {0} is alive, result {1}", new Object[]{agent.getDisplayName(), result});
        }
        catch (Exception ex) {
            throw AzureCloudException.create(String.format("Azure Cloud: waitUntilOnline: Failure waiting {0} till online", agent.getDisplayName()), ex);
        }
        finally {
            future.cancel(true);
        }
    }

    private static boolean isNodeEligibleForReuse(AzureVMAgent agentNode, AzureVMAgentTemplate agentTemplate) {
        if (!agentNode.isEligibleForReuse()) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)agentNode.getLabelString()) && agentNode.getMode() == Node.Mode.NORMAL) {
            return true;
        }
        return StringUtils.isNotBlank((CharSequence)agentNode.getLabelString()) && agentNode.getLabelString().equalsIgnoreCase(agentTemplate.getLabels());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getLockForAgent(AzureVMAgent agent) {
        Map<AzureVMAgent, AtomicInteger> map = this.agentLocks;
        synchronized (map) {
            AtomicInteger lockCount = this.agentLocks.computeIfAbsent(agent, a -> new AtomicInteger(0));
            lockCount.incrementAndGet();
            return lockCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLockForAgent(AzureVMAgent agent) {
        Map<AzureVMAgent, AtomicInteger> map = this.agentLocks;
        synchronized (map) {
            AtomicInteger lockCount = this.agentLocks.get((Object)agent);
            if (lockCount != null && lockCount.decrementAndGet() == 0) {
                this.agentLocks.remove((Object)agent);
            }
        }
    }

    public AzureResourceManager getAzureClient() {
        if (this.azureClient == null && this.credentialsId != null) {
            this.azureClient = AzureResourceManagerCache.get((String)this.credentialsId);
        }
        return this.azureClient;
    }

    public AzureVMManagementServiceDelegate getServiceDelegate() {
        return AzureVMManagementServiceDelegate.getInstance(this.getAzureClient(), this.credentialsId);
    }

    @Restricted(value={NoExternalUse.class})
    public AzureVMAgentTemplate.DescriptorImpl getTemplateDescriptor() {
        return (AzureVMAgentTemplate.DescriptorImpl)Jenkins.get().getDescriptorOrDie(AzureVMAgentTemplate.class);
    }

    boolean templateNameExists(String templateName) {
        return this.vmTemplates.stream().anyMatch(template -> templateName.equals(template.getTemplateName()));
    }

    public String checkName(String name) throws Failure {
        if (name == null) {
            throw new Failure("Query parameter 'name' is required");
        }
        String trimmedName = name.trim();
        Jenkins.checkGoodName((String)trimmedName);
        if (this.templateNameExists(name)) {
            throw new Failure(Messages.templateAlreadyExists(name));
        }
        return trimmedName;
    }

    @POST
    public synchronized void doCreate(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String name, @QueryParameter String mode, @QueryParameter String from) throws IOException, ServletException {
        Jenkins j = Jenkins.get();
        j.checkPermission(Jenkins.ADMINISTER);
        if (mode != null && mode.equals("on")) {
            name = this.checkName(name);
            if (Util.fixEmpty((String)from) == null) {
                throw new Failure(Messages.specifyTemplateToCopyFrom());
            }
            AzureVMAgentTemplate src = this.getVmTemplates().stream().filter(template -> template.getTemplateName().equals(from)).findFirst().orElseThrow(() -> new Failure(Messages.templateNotFound(from)));
            String xml = Jenkins.XSTREAM.toXML((Object)src);
            xml = xml.replace("<templateName>" + src.getTemplateName() + "</templateName>", "<templateName>" + name + "</templateName>");
            AzureVMAgentTemplate result = (AzureVMAgentTemplate)Jenkins.XSTREAM.fromXML(xml);
            this.addTemplate(result);
            rsp.sendRedirect2(Functions.getNearestAncestorUrl((StaplerRequest2)req, (Object)((Object)this)) + "/" + result.getUrl());
        } else {
            this.handleNewVmAgentTemplatePage(name, req, rsp);
        }
    }

    @POST
    public HttpResponse doDoCreate(StaplerRequest2 req) throws Descriptor.FormException, IOException, ServletException {
        Jenkins j = Jenkins.get();
        j.checkPermission(Jenkins.ADMINISTER);
        AzureVMAgentTemplate newTemplate = (AzureVMAgentTemplate)this.getTemplateDescriptor().newInstance(req, req.getSubmittedForm());
        if (StringUtils.isBlank((CharSequence)newTemplate.getTemplateName())) {
            throw new Descriptor.FormException("Template name is mandatory", "templateName");
        }
        boolean templateNameExists = this.templateNameExists(newTemplate.getTemplateName());
        if (templateNameExists) {
            throw new Descriptor.FormException("Agent template name must be unique", "templateName");
        }
        this.addTemplate(newTemplate);
        j.save();
        return FormApply.success((String)"templates");
    }

    private void handleNewVmAgentTemplatePage(String name, StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        this.checkName(name);
        JSONObject formData = req.getSubmittedForm();
        formData.put("templateName", (Object)name);
        formData.remove("mode");
        req.setAttribute("instance", (Object)formData);
        req.getView((Object)this, "_new.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
    }

    public Cloud reconfigure(@NonNull StaplerRequest2 req, JSONObject form) throws Descriptor.FormException {
        AzureVMCloud newInstance = (AzureVMCloud)super.reconfigure(req, form);
        newInstance.setVmTemplates(this.vmTemplates);
        return newInstance;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        private static final String LOG_RECORDER_NAME = "Azure VM Agent (Auto)";

        public String getLogRecorderName() {
            return LOG_RECORDER_NAME;
        }

        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Jenkins.XSTREAM2.addCompatibilityAlias("com.microsoft.azure.AzureVMCloud", AzureVMCloud.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("com.microsoft.azure.AzureVMAgent", AzureVMAgent.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("com.microsoft.azure.remote.AzureVMAgentSSHLauncher", AzureVMAgentSSHLauncher.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("com.microsoft.azure.AzureVMAgentTemplate", AzureVMAgentTemplate.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("com.microsoft.azure.AzureVMCloudRetensionStrategy", AzureVMCloudRetensionStrategy.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("com.microsoft.azure.AzureVMAgentPostBuildAction", AzureVMAgentPostBuildAction.class);
            Jenkins.XSTREAM2.addCompatibilityAlias("com.microsoft.azure.Messages", Messages.class);
        }

        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addLogRecorder(Jenkins h) throws IOException {
            if (Main.isUnitTest) {
                return;
            }
            if (!h.hasPermission(Jenkins.ADMINISTER)) {
                return;
            }
            LogRecorderManager manager = h.getLog();
            LogRecorder recorder = new LogRecorder(LOG_RECORDER_NAME);
            List logRecorders = manager.getRecorders();
            if (!logRecorders.contains(recorder)) {
                String packageName = AzureVMAgent.class.getPackage().getName();
                recorder.getLoggers().add(new LogRecorder.Target(packageName, Level.WARNING));
                logRecorders.add(recorder);
                recorder.save();
            }
        }

        @POST
        public ComboBoxModel doFillCopyNewTemplateFromItems(@QueryParameter String cloudName) {
            ComboBoxModel model = new ComboBoxModel();
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            AzureVMCloud cloud = this.getAzureCloud(cloudName);
            if (cloud != null) {
                for (AzureVMAgentTemplate template : cloud.getVmTemplates()) {
                    model.add((Object)template.getTemplateName());
                }
            }
            return model;
        }

        private AzureVMCloud getAzureCloud(String cloudName) {
            Cloud cloud = Jenkins.get().getCloud(cloudName);
            if (cloud instanceof AzureVMCloud) {
                return (AzureVMCloud)cloud;
            }
            return null;
        }

        @NonNull
        public String getDisplayName() {
            return "Azure VM Agents";
        }

        public String getDefaultserviceManagementURL() {
            return "https://management.core.windows.net/";
        }

        public int getDefaultMaxVMLimit() {
            return 10;
        }

        public int getDefaultDeploymentTimeout() {
            return 1200;
        }

        public String getDefaultResourceGroupName() {
            return "jenkins";
        }

        @RequirePOST
        public FormValidation doVerifyConfiguration(@QueryParameter String azureCredentialsId, @QueryParameter String deploymentTimeout, @QueryParameter String resourceGroupReferenceType, @QueryParameter String newResourceGroupName, @QueryParameter String existingResourceGroupName) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                AzureResourceManager azureClient;
                String resourceGroupName = AzureVMCloud.getResourceGroupName(resourceGroupReferenceType, newResourceGroupName, existingResourceGroupName);
                if (StringUtils.isBlank((CharSequence)resourceGroupName)) {
                    resourceGroupName = "jenkins";
                }
                if ((azureClient = AzureResourceManagerCache.get((String)azureCredentialsId)) == null) {
                    return FormValidation.error((String)"Cannot get Azure client");
                }
                String validationResult = AzureVMManagementServiceDelegate.getInstance(azureClient, azureCredentialsId).verifyConfiguration(resourceGroupName, "existing".equals(resourceGroupReferenceType), deploymentTimeout);
                if (!validationResult.equalsIgnoreCase("Success")) {
                    return FormValidation.error((String)validationResult);
                }
                return FormValidation.ok((String)Messages.Azure_Config_Success());
            }
            catch (Exception e) {
                return FormValidation.error((Throwable)e, (String)"Failed to verify configuration");
            }
        }

        @POST
        public ListBoxModel doFillAzureCredentialsIdItems(@QueryParameter String azureCredentialsId) {
            StandardListBoxModel model = new StandardListBoxModel();
            Jenkins context = Jenkins.get();
            if (!context.hasPermission(Jenkins.ADMINISTER)) {
                return model.includeCurrentValue(azureCredentialsId);
            }
            return model.includeAs(ACL.SYSTEM, (ItemGroup)context, AzureCredentials.class).includeAs(ACL.SYSTEM, (ItemGroup)context, AzureImdsCredentials.class);
        }

        @POST
        public ListBoxModel doFillExistingResourceGroupNameItems(@QueryParameter String azureCredentialsId) {
            Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
            ListBoxModel model = new ListBoxModel();
            model.add("--- Select Resource Group ---", "");
            if (StringUtils.isBlank((CharSequence)azureCredentialsId)) {
                return model;
            }
            try {
                AzureResourceManager azureClient = AzureResourceManagerCache.get((String)azureCredentialsId);
                if (azureClient == null) {
                    return model;
                }
                HashSet<String> resourceGroupNames = new HashSet<String>();
                for (ResourceGroup resourceGroup : azureClient.resourceGroups().list()) {
                    resourceGroupNames.add(resourceGroup.name());
                }
                resourceGroupNames.stream().sorted(String::compareToIgnoreCase).forEach(arg_0 -> ((ListBoxModel)model).add(arg_0));
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Cannot list resource group name: ", e);
            }
            return model;
        }
    }
}

