/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.vmagent;

import com.microsoft.azure.vmagent.AzureVMAgent;
import com.microsoft.azure.vmagent.AzureVMComputer;
import com.microsoft.azure.vmagent.Messages;
import com.microsoft.azure.vmagent.util.CleanUpAction;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class AzureVMAgentPostBuildAction
extends Recorder {
    private final String agentPostBuildAction;
    private static final Logger LOGGER = Logger.getLogger(AzureVMAgentPostBuildAction.class.getName());

    @DataBoundConstructor
    public AzureVMAgentPostBuildAction(String agentPostBuildAction) {
        this.agentPostBuildAction = agentPostBuildAction;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Computer computer = Computer.currentComputer();
        Node node = computer.getNode();
        if (!(node instanceof AzureVMAgent)) {
            return true;
        }
        AzureVMAgent agent = (AzureVMAgent)node;
        AzureVMComputer azureComputer = (AzureVMComputer)computer;
        LOGGER.log(Level.INFO, "AzureVMAgentPostBuildAction: perform: build action {0} for agent {1}", new Object[]{this.agentPostBuildAction, agent.getNodeName()});
        if (azureComputer.isSetOfflineByUser()) {
            LOGGER.log(Level.INFO, "AzureVMAgentPostBuildAction: perform: agent {0} was taken offline by user, skipping postbuild", agent.getNodeName());
            return true;
        }
        azureComputer.setAcceptingTasks(false);
        if (Messages.Build_Action_Shutdown_Agent().equalsIgnoreCase(this.agentPostBuildAction)) {
            agent.setCleanUpAction(CleanUpAction.SHUTDOWN, Messages._Build_Action_Shutdown_Agent());
        } else if (Messages.Build_Action_Delete_Agent_If_Not_Success().equalsIgnoreCase(this.agentPostBuildAction) && build.getResult() != Result.SUCCESS) {
            agent.setCleanUpAction(CleanUpAction.DELETE, Messages._Build_Action_Delete_Agent_If_Not_Success());
        } else if (Messages.Build_Action_Delete_Agent().equalsIgnoreCase(this.agentPostBuildAction)) {
            agent.setCleanUpAction(CleanUpAction.DELETE, Messages._Build_Action_Delete_Agent());
        }
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    @Extension
    public static final class AzureAgentPostBuildDescriptor
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> arg0) {
            return true;
        }

        public ListBoxModel doFillAgentPostBuildActionItems() {
            ListBoxModel model = new ListBoxModel();
            model.add(Messages.Build_Action_Shutdown_Agent());
            model.add(Messages.Build_Action_Delete_Agent());
            model.add(Messages.Build_Action_Delete_Agent_If_Not_Success());
            return model;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.Azure_Agent_Post_Build_Action();
        }
    }
}

