/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ssh.components;

import com.sshtools.common.config.AdaptiveConfiguration;
import com.sshtools.common.ssh.SecurityLevel;
import com.sshtools.common.ssh.components.SecurityManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class DefaultSecurityManager
implements SecurityManager {
    AdaptiveConfiguration config;
    static Map<String, SecurityLevel> DEFAULTS = new HashMap<String, SecurityLevel>();

    public DefaultSecurityManager() {
        this(Paths.get("security.cfg", new String[0]));
    }

    public DefaultSecurityManager(Path path) {
        this.config = new AdaptiveConfiguration(path.toFile());
    }

    @Override
    public SecurityLevel getSecurityLevel(String algorithm) {
        return this.toSecurityLevel(this.config.getProperty(algorithm, "WEAK", new String[0]));
    }

    private SecurityLevel toSecurityLevel(String val) {
        return SecurityLevel.valueOf(val);
    }
}

