/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.publickey.authorized;

import com.sshtools.common.net.CIDRNetwork;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

public class Patterns {
    public static boolean matchesWithCIDR(Collection<String> patterns, String value) throws IOException {
        if (patterns == null || patterns.isEmpty()) {
            return false;
        }
        boolean positiveMatch = false;
        boolean negativeMatch = false;
        for (String pattern : patterns) {
            CIDRNetwork cidr;
            if (pattern.startsWith("!") && !negativeMatch) {
                if (pattern.contains("/")) {
                    cidr = new CIDRNetwork(pattern);
                    negativeMatch = cidr.isValidAddressForNetwork(value);
                    continue;
                }
                if (!value.matches(Patterns.convertToRegex(pattern.substring(1)))) continue;
                negativeMatch = true;
                continue;
            }
            if (positiveMatch) continue;
            if (pattern.contains("/")) {
                cidr = new CIDRNetwork(pattern);
                positiveMatch = cidr.isValidAddressForNetwork(value);
                continue;
            }
            if (!value.matches(Patterns.convertToRegex(pattern))) continue;
            positiveMatch = true;
        }
        return !negativeMatch && positiveMatch;
    }

    public static boolean matches(Collection<String> patterns, String value) {
        if (patterns == null || patterns.isEmpty()) {
            return false;
        }
        boolean positiveMatch = false;
        boolean negativeMatch = false;
        for (String pattern : patterns) {
            if (pattern.startsWith("!") && !negativeMatch) {
                if (!value.matches(Patterns.convertToRegex(pattern.substring(1)))) continue;
                negativeMatch = true;
                continue;
            }
            if (positiveMatch || !value.matches(Patterns.convertToRegex(pattern))) continue;
            positiveMatch = true;
        }
        return !negativeMatch && positiveMatch;
    }

    static String convertToRegex(String pattern) {
        pattern = pattern.replace(".", "\\.");
        pattern = pattern.replace("*", ".*");
        pattern = pattern.replace("?", ".");
        return pattern;
    }

    public static void main(String[] args) throws IOException {
        System.out.println("Expecting true: " + Patterns.matchesWithCIDR(Arrays.asList("!*.dialup.example.com", "*.example.com"), "foo.example.com"));
        System.out.println("Expecting false: " + Patterns.matchesWithCIDR(Arrays.asList("!*.dialup.example.com", "*.example.com"), "foo.dialup.example.com"));
        System.out.println("Expecting false: " + Patterns.matchesWithCIDR(Arrays.asList("!*.dialup.example.com", "*.example.com"), "foo.com"));
    }
}

