/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.knownhosts;

import com.sshtools.common.knownhosts.KnownHostsKeyVerification;
import com.sshtools.common.logger.Log;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.ssh.components.SshPublicKey;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;

public class KnownHostsFile
extends KnownHostsKeyVerification {
    private Path file;

    public static Path defaultKnownHostsFile() {
        return Paths.get(System.getProperty("user.home"), ".ssh", "known_hosts");
    }

    public KnownHostsFile(File file) throws SshException {
        this(file.toPath());
    }

    public KnownHostsFile(Path file) throws SshException {
        this.file = file;
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            this.load(in);
        }
        catch (IOException e) {
            throw new SshException(e);
        }
    }

    public void store() throws IOException {
        try (BufferedWriter out = Files.newBufferedWriter(this.file, Charset.forName("UTF-8"), new OpenOption[0]);){
            out.write(this.toString());
        }
    }

    public Path getFile() {
        return this.file;
    }

    public File getKnownHostsFile() {
        return this.file.toFile();
    }

    @Override
    public boolean isHostFileWriteable() {
        return Files.isReadable(this.file);
    }

    public KnownHostsFile() throws SshException {
        this(KnownHostsFile.defaultKnownHostsFile());
    }

    @Override
    protected void onInvalidHostEntry(String entry) throws SshException {
    }

    @Override
    protected void onHostKeyMismatch(String host, List<SshPublicKey> allowedHostKey, SshPublicKey actualHostKey) throws SshException {
    }

    @Override
    protected void onUnknownHost(String host, SshPublicKey key) throws SshException {
    }

    @Override
    protected void onRevokedKey(String host, SshPublicKey key) {
    }

    @Override
    protected void onHostKeyUpdated(Set<String> names, SshPublicKey key) {
        this.save();
    }

    @Override
    protected void onHostKeyAdded(Set<String> names, SshPublicKey key) {
        this.save();
    }

    @Override
    protected void onHostKeyRemoved(Set<String> names, SshPublicKey key) {
        this.save();
    }

    protected void save() {
        try {
            this.store();
        }
        catch (IOException e) {
            Log.error((String)"Failed to store known_hosts file", (Throwable)e, (Object[])new Object[0]);
        }
    }
}

