/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.SshClient;
import com.sshtools.client.SshClientContext;
import com.sshtools.client.sftp.SftpClientTask;
import com.sshtools.client.tasks.AbstractFileTask;
import com.sshtools.common.ssh.SshConnection;
import com.sshtools.synergy.ssh.Connection;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Optional;

public class UploadFileContentTask
extends AbstractFileTask {
    final Path remote;
    final String content;
    final Charset encoding;

    private UploadFileContentTask(UploadFileContentTaskBuilder builder) {
        super(builder);
        this.remote = builder.remote.orElseThrow(() -> new IllegalStateException("Remote remote must be supplied."));
        this.content = String.valueOf(builder.content.orElseThrow(() -> new IllegalStateException("Content must be supplied.")));
        this.encoding = builder.encoding.orElse(Charset.defaultCharset());
    }

    @Deprecated(forRemoval=true, since="3.1.0")
    public UploadFileContentTask(SshClient ssh, String content, String encoding, String path) {
        this(ssh.getConnection(), content, encoding, path);
    }

    @Deprecated(forRemoval=true, since="3.1.0")
    public UploadFileContentTask(Connection<SshClientContext> con, String content, String encoding, String path) {
        this(((UploadFileContentTaskBuilder)UploadFileContentTaskBuilder.create().withConnection((SshConnection)con)).withContent(content).withEncoding(encoding).withRemotePath(path));
    }

    public void doTask() {
        this.doTaskUntilDone(new SftpClientTask(this.con, self -> {
            byte[] bytes = this.content.getBytes(this.encoding);
            self.put(new ByteArrayInputStream(bytes), this.remote.toString(), this.progress.orElse(null), 0L, bytes.length);
        }));
    }

    public static final class UploadFileContentTaskBuilder
    extends AbstractFileTask.AbstractFileTaskBuilder<UploadFileContentTaskBuilder, UploadFileContentTask> {
        private Optional<Path> remote = Optional.empty();
        private Optional<Object> content = Optional.empty();
        private Optional<Charset> encoding = Optional.empty();

        private UploadFileContentTaskBuilder() {
        }

        public static UploadFileContentTaskBuilder create() {
            return new UploadFileContentTaskBuilder();
        }

        public UploadFileContentTaskBuilder withEncoding(String encoding) {
            if (encoding == null) {
                this.encoding = Optional.empty();
                return this;
            }
            return this.withEncoding(Charset.forName(encoding));
        }

        public UploadFileContentTaskBuilder withEncoding(Charset encoding) {
            this.encoding = Optional.of(encoding);
            return this;
        }

        public UploadFileContentTaskBuilder withRemotePath(Optional<String> remote) {
            return this.withRemote((Path)remote.map(x$0 -> Path.of(x$0, new String[0])).orElse(null));
        }

        public UploadFileContentTaskBuilder withRemote(Path remote) {
            return this.withRemote(Optional.of(remote));
        }

        public UploadFileContentTaskBuilder withRemote(Optional<Path> remote) {
            this.remote = remote;
            return this;
        }

        public UploadFileContentTaskBuilder withRemotePath(String remote) {
            return this.withRemotePath(Optional.of(remote));
        }

        public UploadFileContentTaskBuilder withContent(Object content) {
            this.content = Optional.of(content);
            return this;
        }

        @Override
        public UploadFileContentTask build() {
            return new UploadFileContentTask(this);
        }
    }
}

