/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.ChunkInputStream;
import com.sshtools.client.SshClient;
import com.sshtools.client.sftp.SftpClient;
import com.sshtools.client.sftp.SftpHandle;
import com.sshtools.client.sftp.SftpMessage;
import com.sshtools.client.sftp.TransferCancelledException;
import com.sshtools.client.tasks.AbstractOptimisedTask;
import com.sshtools.client.tasks.FileTransferProgress;
import com.sshtools.common.files.AbstractFile;
import com.sshtools.common.files.AbstractFileRandomAccess;
import com.sshtools.common.logger.Log;
import com.sshtools.common.permissions.PermissionDeniedException;
import com.sshtools.common.sftp.SftpFileAttributes;
import com.sshtools.common.sftp.SftpStatusException;
import com.sshtools.common.ssh.ChannelOpenException;
import com.sshtools.common.ssh.SshException;
import com.sshtools.common.util.ByteArrayWriter;
import com.sshtools.common.util.FileUtils;
import com.sshtools.common.util.UnsignedInteger32;
import com.sshtools.common.util.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public final class PushTask
extends AbstractOptimisedTask<String, AbstractFile> {
    private final List<AbstractFile> files;
    private final String remoteFolder;

    PushTask(PushTaskBuilder builder) {
        super(builder);
        this.remoteFolder = builder.remoteFolder.map(Utils::translatePathString).orElse(null);
        this.files = new ArrayList<AbstractFile>();
        this.files.addAll(builder.files);
        for (Path file : Collections.unmodifiableList(new ArrayList<Path>(builder.paths))) {
            try {
                AbstractFile resolved = this.primarySftpClient.getCurrentWorkingDirectory().resolveFile(file.toString());
                if (!resolved.exists()) {
                    throw new FileNotFoundException(String.format("%s does not exist", file.getFileName()));
                }
                this.files.add(resolved);
            }
            catch (PermissionDeniedException | IOException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
    }

    @Override
    protected void transferFiles(String targetFolder) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException, ChannelOpenException {
        SftpFileAttributes remoteAttrs = this.primarySftpClient.stat(targetFolder);
        if (!remoteAttrs.isDirectory()) {
            throw new IOException("Remote directory must be a directory!");
        }
        this.verboseMessage("The paths will be transferred to {0}", targetFolder);
        for (AbstractFile file : this.files) {
            this.transferFile(file, targetFolder);
        }
    }

    @Override
    protected String configureTargetFolder() throws IOException, SshException, PermissionDeniedException, SftpStatusException {
        String target = Utils.isNotBlank((String)this.remoteFolder) ? this.primarySftpClient.getAbsolutePath(this.remoteFolder) : this.primarySftpClient.getAbsolutePath(".");
        return target;
    }

    private void transferFile(AbstractFile localFile, String remoteFolder) throws SftpStatusException, SshException, TransferCancelledException, IOException, PermissionDeniedException, ChannelOpenException {
        this.verboseMessage("Total to transfer is {0} bytes", localFile.length());
        if (this.chunks <= 1) {
            this.sendFileViaSFTP(localFile, "", remoteFolder);
        } else {
            this.checkErrors(this.sendChunks(localFile, remoteFolder));
        }
        this.verifyIntegrity(Paths.get(localFile.getAbsolutePath(), new String[0]), remoteFolder + "/" + localFile.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<Throwable> sendChunks(AbstractFile localFile, String remoteFolder) throws PermissionDeniedException, IOException, SftpStatusException, SshException {
        ExecutorService executor = Executors.newFixedThreadPool(this.chunks);
        try {
            List<Throwable> errors;
            block29: {
                SftpHandle transaction;
                long blocksize;
                String targetFilePath = remoteFolder + "/" + localFile.getName();
                if (!this.primarySftpClient.exists(targetFilePath)) {
                    this.verboseMessage("Pre-creating file {0}/{1}", remoteFolder, localFile.getName(), this.chunks);
                    this.primarySftpClient.openFile(targetFilePath, 10).close();
                }
                if (this.progress.isPresent()) {
                    ((FileTransferProgress)this.progress.get()).started(localFile.length(), localFile.getName());
                }
                String remotePath = FileUtils.checkEndsWithSlash((String)this.primarySftpClient.pwd()) + localFile.getName();
                ByteArrayWriter msg = new ByteArrayWriter();
                msg.writeString(remotePath);
                List progressChunks = Collections.synchronizedList(new ArrayList());
                errors = Collections.synchronizedList(new ArrayList());
                AtomicLong total = new AtomicLong();
                try {
                    UnsignedInteger32 requestId = this.primarySftpClient.getSubsystemChannel().sendExtensionMessage("create-multipart-file@sshtools.com", msg.toByteArray());
                    SftpMessage ext = this.primarySftpClient.getSubsystemChannel().getExtendedReply(requestId, remotePath);
                    byte[] handle = ext.readBinaryString();
                    blocksize = ext.readInt();
                    int method = ext.read();
                    transaction = this.primarySftpClient.getSubsystemChannel().getFile(remotePath).handle(handle);
                    this.verboseMessage("Remote server supports multipart extensions with minimum part size of {0} bytes", blocksize);
                    if (localFile.length() <= blocksize) {
                        this.verboseMessage("Minimum blocksize for push not met reverting to put", new Object[0]);
                        try {
                            this.sendFileViaSFTP(localFile, remotePath, remoteFolder);
                            break block29;
                        }
                        catch (TransferCancelledException e) {
                            List<Throwable> list = errors;
                            executor.shutdown();
                            try {
                                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                                return list;
                            }
                            catch (InterruptedException e1) {
                                throw new InterruptedIOException();
                            }
                            finally {
                                ((FileTransferProgress)this.progress.get()).completed();
                            }
                        }
                    }
                }
                catch (SftpStatusException e) {
                    long chunkLength = localFile.length() / (long)this.chunks;
                    long finalLength = localFile.length() - (long)(this.chunks - 1) * chunkLength;
                    this.verboseMessage("Falling back to pure random access support which may or may not be supported.", new Object[0]);
                    this.printChunkMessages(chunkLength);
                    for (int i = 0; i < this.chunks; ++i) {
                        int chunk = i + 1;
                        long pointer = (long)i * chunkLength;
                        executor.submit(() -> {
                            try {
                                FileTransferProgress tmp = (FileTransferProgress)this.chunkProgress.apply(localFile);
                                AbstractOptimisedTask.FileTransferProgressWrapper wrapper = new AbstractOptimisedTask.FileTransferProgressWrapper(tmp, this.progress, total);
                                progressChunks.add(wrapper);
                                boolean lastChunk = chunk == this.chunks;
                                long thisLength = lastChunk ? finalLength : chunkLength;
                                this.sendChunk(localFile, pointer, thisLength, chunk, lastChunk, wrapper, remoteFolder);
                            }
                            catch (Throwable e2) {
                                errors.add(e2);
                            }
                        });
                    }
                    break block29;
                }
                {
                    long totalBlocks = localFile.length() / blocksize;
                    if (localFile.length() % blocksize > 0L) {
                        ++totalBlocks;
                    }
                    long blocksPerChunk = totalBlocks / (long)this.chunks;
                    long chunkLength = blocksPerChunk * blocksize;
                    long finalLength = localFile.length() - (long)(this.chunks - 1) * chunkLength;
                    this.printChunkMessages(chunkLength);
                    for (int i = 0; i < this.chunks; ++i) {
                        int chunk = i + 1;
                        long pointer = (long)i * chunkLength;
                        executor.submit(() -> {
                            try {
                                FileTransferProgress tmp = (FileTransferProgress)this.chunkProgress.apply(localFile);
                                AbstractOptimisedTask.FileTransferProgressWrapper wrapper = new AbstractOptimisedTask.FileTransferProgressWrapper(tmp, this.progress, total);
                                progressChunks.add(wrapper);
                                boolean lastChunk = chunk == this.chunks;
                                long thisLength = lastChunk ? finalLength : chunkLength;
                                this.sendPart(localFile, pointer, thisLength, chunk, lastChunk, wrapper, transaction, String.format("part%d", chunk), remoteFolder);
                            }
                            catch (Throwable e) {
                                errors.add(e);
                            }
                        });
                    }
                }
            }
            List<Throwable> list = errors;
            return list;
        }
        finally {
            executor.shutdown();
            try {
                executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e1) {
                throw new InterruptedIOException();
            }
            finally {
                ((FileTransferProgress)this.progress.get()).completed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFileViaSFTP(AbstractFile localFile, String remotePath, String remoteFolder) throws IOException, SshException, PermissionDeniedException, SftpStatusException, TransferCancelledException {
        SshClient ssh = (SshClient)this.clients.removeFirst();
        SftpClient.SftpClientBuilder bldr = SftpClient.SftpClientBuilder.create().withClient(ssh);
        if (this.blocksize > 0) {
            bldr.withBlockSize(this.blocksize);
        }
        if (this.outstandingRequests > 0) {
            bldr.withAsyncRequests(this.outstandingRequests);
        }
        try (SftpClient sftp = bldr.build();){
            sftp.lcd(this.primarySftpClient.getCurrentWorkingDirectory().getAbsolutePath());
            sftp.cd(remoteFolder);
            sftp.put(localFile.getAbsolutePath(), remotePath, (FileTransferProgress)this.progress.orElse(null));
        }
        finally {
            LinkedList linkedList = this.clients;
            synchronized (linkedList) {
                this.clients.addLast(ssh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChunk(AbstractFile localFile, final long pointer, long chunkLength, Integer chunkNumber, boolean lastChunk, final FileTransferProgress progress, String remoteFolder) throws IOException, SftpStatusException, SshException, TransferCancelledException, ChannelOpenException, PermissionDeniedException {
        SshClient ssh;
        LinkedList linkedList = this.clients;
        synchronized (linkedList) {
            ssh = (SshClient)this.clients.removeFirst();
        }
        try (Object file = localFile.openFile(false);){
            file.seek(pointer);
            try (SftpClient sftp = SftpClient.SftpClientBuilder.create().withClient(ssh).withBlockSize(this.blocksize).withAsyncRequests(this.outstandingRequests).withRemotePath(remoteFolder).withLocalPath(this.primarySftpClient.lpwd()).build();){
                try {
                    sftp.put(new ChunkInputStream((AbstractFileRandomAccess)file, chunkLength), localFile.getName(), new FileTransferProgress(){

                        @Override
                        public void started(long bytesTotal, String file) {
                            progress.started(bytesTotal, file);
                        }

                        @Override
                        public boolean isCancelled() {
                            return progress.isCancelled();
                        }

                        @Override
                        public void progressed(long bytesSoFar) {
                            progress.progressed(bytesSoFar - pointer);
                        }

                        @Override
                        public void completed() {
                            progress.completed();
                        }
                    }, pointer, chunkLength);
                }
                catch (SftpStatusException e) {
                    if (e.getStatus() == 2) {
                        FileNotFoundException fnfe = new FileNotFoundException(localFile.getName() + " (chunk " + chunkNumber + " @ " + pointer + ", with " + chunkLength + " bytes)");
                        fnfe.initCause(e);
                        throw fnfe;
                    }
                    throw e;
                }
            }
        }
        catch (IOException ioe) {
            if (ioe.getCause() instanceof TransferCancelledException) {
                throw (TransferCancelledException)ioe.getCause();
            }
            throw ioe;
        }
        finally {
            LinkedList linkedList2 = this.clients;
            synchronized (linkedList2) {
                this.clients.addLast(ssh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPart(AbstractFile localFile, final long pointer, long chunkLength, Integer chunkNumber, boolean lastChunk, final FileTransferProgress progress, SftpHandle transaction, String partId, String remoteFolder) throws IOException, SftpStatusException, SshException, TransferCancelledException, ChannelOpenException, PermissionDeniedException {
        SshClient ssh;
        LinkedList linkedList = this.clients;
        synchronized (linkedList) {
            ssh = (SshClient)this.clients.removeFirst();
        }
        try (Object file = localFile.openFile(false);){
            file.seek(pointer);
            try (SftpClient sftp = SftpClient.SftpClientBuilder.create().withClient(ssh).withRemotePath(remoteFolder).withLocalPath(this.primarySftpClient.lpwd()).build();){
                ByteArrayWriter msg = new ByteArrayWriter();
                msg.writeBinaryString(transaction.getHandle());
                msg.writeString(partId);
                msg.writeUINT64(pointer);
                msg.writeUINT64(chunkLength);
                try (SftpHandle handle = sftp.getSubsystemChannel().getHandle(sftp.getSubsystemChannel().sendExtensionMessage("open-part-file@sshtools.com", msg.toByteArray()), transaction.getFile());){
                    handle.performOptimizedWrite(localFile.getName(), this.blocksize, this.outstandingRequests, new ChunkInputStream((AbstractFileRandomAccess)file, chunkLength), this.buffersize, new FileTransferProgress(){

                        @Override
                        public void started(long bytesTotal, String file) {
                            progress.started(bytesTotal, file);
                        }

                        @Override
                        public boolean isCancelled() {
                            return progress.isCancelled();
                        }

                        @Override
                        public void progressed(long bytesSoFar) {
                            progress.progressed(bytesSoFar - pointer);
                        }

                        @Override
                        public void completed() {
                            progress.completed();
                        }
                    }, pointer);
                }
                catch (TransferCancelledException | SftpStatusException | SshException e) {
                    Log.error((String)"Part upload failed", (Throwable)e, (Object[])new Object[0]);
                    throw e;
                }
            }
        }
        catch (IOException ioe) {
            if (ioe.getCause() instanceof TransferCancelledException) {
                throw (TransferCancelledException)ioe.getCause();
            }
            throw ioe;
        }
        finally {
            LinkedList linkedList2 = this.clients;
            synchronized (linkedList2) {
                this.clients.addLast(ssh);
            }
        }
    }

    public static class PushTaskBuilder
    extends AbstractOptimisedTask.AbstractOptimisedTaskBuilder<PushTaskBuilder, PushTask, AbstractFile> {
        private Optional<Path> remoteFolder = Optional.empty();
        private List<Path> paths = new ArrayList<Path>();
        private List<AbstractFile> files = new ArrayList<AbstractFile>();

        private PushTaskBuilder() {
        }

        public static PushTaskBuilder create() {
            return new PushTaskBuilder();
        }

        public PushTaskBuilder addFilePaths(Collection<String> filePaths) {
            this.paths.addAll(filePaths.stream().map(x$0 -> Path.of(x$0, new String[0])).collect(Collectors.toList()));
            return this;
        }

        public PushTaskBuilder addAbstactFiles(Collection<AbstractFile> filePaths) {
            this.files.addAll(filePaths);
            return this;
        }

        public PushTaskBuilder addPaths(Collection<Path> paths) {
            this.paths.addAll(paths);
            return this;
        }

        public PushTaskBuilder addFiles(Collection<File> files) {
            this.paths.addAll(files.stream().map(File::toPath).collect(Collectors.toList()));
            return this;
        }

        public PushTaskBuilder withFilePaths(Collection<String> files) {
            this.paths.clear();
            return this.addFilePaths(files);
        }

        public PushTaskBuilder withPaths(Collection<Path> paths) {
            this.paths.clear();
            return this.addPaths(paths);
        }

        public PushTaskBuilder withAbstractFiles(Collection<AbstractFile> paths) {
            this.files.clear();
            return this.addAbstactFiles(paths);
        }

        public PushTaskBuilder withFiles(File ... files) {
            this.paths.clear();
            return this.addFiles(Arrays.asList(files));
        }

        public PushTaskBuilder withPaths(Path ... paths) {
            this.paths.clear();
            return this.addPaths(Arrays.asList(paths));
        }

        public PushTaskBuilder withAbstractFiles(AbstractFile ... paths) {
            return this.withAbstractFiles(Arrays.asList(paths));
        }

        public PushTaskBuilder withFilesPaths(String ... filePaths) {
            this.paths.clear();
            return this.addFilePaths(Arrays.asList(filePaths));
        }

        public PushTaskBuilder withRemoteFolder(String remoteFolder) {
            return this.withRemoteFolder(remoteFolder == null || remoteFolder.equals("") ? Optional.empty() : Optional.of(Path.of(remoteFolder, new String[0])));
        }

        public PushTaskBuilder withRemoteFolder(Path remoteFolder) {
            return this.withRemoteFolder(Optional.of(remoteFolder));
        }

        public PushTaskBuilder withRemoteFolder(Optional<Path> remoteFolder) {
            this.remoteFolder = remoteFolder;
            return this;
        }

        @Override
        public PushTask build() {
            return new PushTask(this);
        }
    }
}

