/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.client.tasks;

import com.sshtools.client.SshClient;
import com.sshtools.client.tasks.Task;
import com.sshtools.common.ssh.SshConnection;
import java.util.Optional;
import java.util.function.Function;

public abstract class AbstractConnectionTask
extends Task {
    protected final Optional<Function<Integer, SshClient>> clientSupplier;

    protected AbstractConnectionTask(AbstractConnectionTaskBuilder<?, ?> builder) {
        super(builder.connection.orElseGet(() -> builder.clientSupplier.orElseThrow(() -> new IllegalArgumentException("No connection or client supplied.")).apply(0).getConnection()));
        this.clientSupplier = builder.clientSupplier;
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    protected AbstractConnectionTask(SshClient ssh) {
        super(ssh);
        this.clientSupplier = Optional.empty();
    }

    @Deprecated(since="3.1.0", forRemoval=true)
    protected AbstractConnectionTask(SshConnection con) {
        super(con);
        this.clientSupplier = Optional.empty();
    }

    public static abstract class AbstractConnectionTaskBuilder<B extends AbstractConnectionTaskBuilder<B, T>, T extends AbstractConnectionTask> {
        protected Optional<Function<Integer, SshClient>> clientSupplier = Optional.empty();
        protected Optional<SshConnection> connection = Optional.empty();

        public B withClient(SshClient client) {
            return this.withClients(idx -> client);
        }

        public B withConnection(SshConnection connection) {
            this.connection = Optional.of(connection);
            return (B)this;
        }

        public B withClients(Function<Integer, SshClient> clientSupplier) {
            this.clientSupplier = Optional.of(clientSupplier);
            return (B)this;
        }

        public abstract T build();
    }
}

