/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.keyvault.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.CoreUtils;
import com.azure.resourcemanager.keyvault.KeyVaultManager;
import com.azure.resourcemanager.keyvault.fluent.KeyVaultManagementClient;
import com.azure.resourcemanager.keyvault.fluent.ManagedHsmsClient;
import com.azure.resourcemanager.keyvault.fluent.models.ManagedHsmInner;
import com.azure.resourcemanager.keyvault.implementation.ManagedHsmImpl;
import com.azure.resourcemanager.keyvault.models.ManagedHsm;
import com.azure.resourcemanager.keyvault.models.ManagedHsmProperties;
import com.azure.resourcemanager.keyvault.models.ManagedHsms;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.GroupableResourcesImpl;
import java.util.UUID;
import reactor.core.publisher.Mono;

public class ManagedHsmsImpl
extends GroupableResourcesImpl<ManagedHsm, ManagedHsmImpl, ManagedHsmInner, ManagedHsmsClient, KeyVaultManager>
implements ManagedHsms {
    private final String tenantId;

    public ManagedHsmsImpl(KeyVaultManager manager, String tenantId) {
        super((Object)((KeyVaultManagementClient)manager.serviceClient()).getManagedHsms(), (Manager)manager);
        this.tenantId = tenantId;
    }

    protected ManagedHsmImpl wrapModel(String name) {
        ManagedHsmInner inner = new ManagedHsmInner().withProperties(new ManagedHsmProperties());
        inner.properties().withTenantId(UUID.fromString(this.tenantId));
        return new ManagedHsmImpl(name, inner, (KeyVaultManager)this.manager());
    }

    protected Mono<ManagedHsmInner> getInnerAsync(String resourceGroupName, String name) {
        return ((ManagedHsmsClient)this.inner()).getByResourceGroupAsync(resourceGroupName, name);
    }

    protected Mono<Void> deleteInnerAsync(String resourceGroupName, String name) {
        return ((ManagedHsmsClient)this.inner()).deleteAsync(resourceGroupName, name);
    }

    protected ManagedHsmImpl wrapModel(ManagedHsmInner inner) {
        if (inner == null) {
            return null;
        }
        return new ManagedHsmImpl(inner.name(), inner, (KeyVaultManager)this.manager());
    }

    public PagedIterable<ManagedHsm> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(this.listByResourceGroupAsync(resourceGroupName));
    }

    public PagedFlux<ManagedHsm> listByResourceGroupAsync(String resourceGroupName) {
        if (CoreUtils.isNullOrEmpty((CharSequence)resourceGroupName)) {
            return new PagedFlux(() -> Mono.error((Throwable)new IllegalArgumentException("Parameter 'resourceGroupName' is required and cannot be null.")));
        }
        return this.wrapPageAsync(((ManagedHsmsClient)this.inner()).listByResourceGroupAsync(resourceGroupName));
    }
}

