/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography.models;

import com.azure.core.util.CoreUtils;
import com.azure.security.keyvault.keys.cryptography.models.EncryptionAlgorithm;
import java.util.Objects;

public final class DecryptParameters {
    private final EncryptionAlgorithm algorithm;
    private final byte[] ciphertext;
    private final byte[] iv;
    private final byte[] additionalAuthenticatedData;
    private final byte[] authenticationTag;

    public static DecryptParameters createA128CbcParameters(byte[] ciphertext, byte[] iv) {
        return new DecryptParameters(EncryptionAlgorithm.A128CBC, ciphertext, iv, null, null);
    }

    public static DecryptParameters createA128CbcPadParameters(byte[] ciphertext, byte[] iv) {
        return new DecryptParameters(EncryptionAlgorithm.A128CBCPAD, ciphertext, iv, null, null);
    }

    public static DecryptParameters createA128GcmParameters(byte[] ciphertext, byte[] iv, byte[] authenticationTag) {
        return DecryptParameters.createA128GcmParameters(ciphertext, iv, authenticationTag, null);
    }

    public static DecryptParameters createA128GcmParameters(byte[] ciphertext, byte[] iv, byte[] authenticationTag, byte[] additionalAuthenticatedData) {
        return new DecryptParameters(EncryptionAlgorithm.A128GCM, ciphertext, iv, authenticationTag, additionalAuthenticatedData);
    }

    public static DecryptParameters createA192CbcParameters(byte[] ciphertext, byte[] iv) {
        return new DecryptParameters(EncryptionAlgorithm.A192CBC, ciphertext, iv, null, null);
    }

    public static DecryptParameters createA192CbcPadParameters(byte[] ciphertext, byte[] iv) {
        return new DecryptParameters(EncryptionAlgorithm.A192CBCPAD, ciphertext, iv, null, null);
    }

    public static DecryptParameters createA192GcmParameters(byte[] ciphertext, byte[] iv, byte[] authenticationTag) {
        return DecryptParameters.createA192GcmParameters(ciphertext, iv, authenticationTag, null);
    }

    public static DecryptParameters createA192GcmParameters(byte[] ciphertext, byte[] iv, byte[] authenticationTag, byte[] additionalAuthenticatedData) {
        return new DecryptParameters(EncryptionAlgorithm.A192GCM, ciphertext, iv, authenticationTag, additionalAuthenticatedData);
    }

    public static DecryptParameters createA256CbcParameters(byte[] ciphertext, byte[] iv) {
        return new DecryptParameters(EncryptionAlgorithm.A256CBC, ciphertext, iv, null, null);
    }

    public static DecryptParameters createA256CbcPadParameters(byte[] ciphertext, byte[] iv) {
        return new DecryptParameters(EncryptionAlgorithm.A256CBCPAD, ciphertext, iv, null, null);
    }

    public static DecryptParameters createA256GcmParameters(byte[] ciphertext, byte[] iv, byte[] authenticationTag) {
        return DecryptParameters.createA256GcmParameters(ciphertext, iv, authenticationTag, null);
    }

    public static DecryptParameters createA256GcmParameters(byte[] ciphertext, byte[] iv, byte[] authenticationTag, byte[] additionalAuthenticatedData) {
        return new DecryptParameters(EncryptionAlgorithm.A256GCM, ciphertext, iv, authenticationTag, additionalAuthenticatedData);
    }

    public static DecryptParameters createRsa15Parameters(byte[] ciphertext) {
        return new DecryptParameters(EncryptionAlgorithm.RSA1_5, ciphertext, null, null, null);
    }

    public static DecryptParameters createRsaOaepParameters(byte[] ciphertext) {
        return new DecryptParameters(EncryptionAlgorithm.RSA_OAEP, ciphertext, null, null, null);
    }

    public static DecryptParameters createRsaOaep256Parameters(byte[] ciphertext) {
        return new DecryptParameters(EncryptionAlgorithm.RSA_OAEP_256, ciphertext, null, null, null);
    }

    DecryptParameters(EncryptionAlgorithm algorithm, byte[] ciphertext, byte[] iv, byte[] authenticationTag, byte[] additionalAuthenticatedData) {
        Objects.requireNonNull(algorithm, "Encryption algorithm cannot be null.");
        Objects.requireNonNull(ciphertext, "Cipher text content to be decrypted cannot be null.");
        if (algorithm == EncryptionAlgorithm.A128GCM || algorithm == EncryptionAlgorithm.A192GCM || algorithm == EncryptionAlgorithm.A256GCM) {
            Objects.requireNonNull(authenticationTag, "Authentication tag cannot be null for GCM decryption.");
        }
        this.algorithm = algorithm;
        this.ciphertext = CoreUtils.clone((byte[])ciphertext);
        this.iv = CoreUtils.clone((byte[])iv);
        this.additionalAuthenticatedData = CoreUtils.clone((byte[])additionalAuthenticatedData);
        this.authenticationTag = CoreUtils.clone((byte[])authenticationTag);
    }

    public EncryptionAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getCipherText() {
        return CoreUtils.clone((byte[])this.ciphertext);
    }

    public byte[] getIv() {
        return CoreUtils.clone((byte[])this.iv);
    }

    public byte[] getAdditionalAuthenticatedData() {
        return CoreUtils.clone((byte[])this.additionalAuthenticatedData);
    }

    public byte[] getAuthenticationTag() {
        return CoreUtils.clone((byte[])this.authenticationTag);
    }
}

