/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

class ErrorResponse
implements JsonSerializable<ErrorResponse> {
    private Integer statusCode;
    private String statusMessage;
    protected String error;
    protected String errorDescription;
    protected long[] errorCodes;
    protected String subError;
    protected String traceId;
    protected String timestamp;
    protected String correlation_id;
    private String claims;

    ErrorResponse() {
    }

    static ErrorResponse fromJson(JsonReader jsonReader) throws IOException {
        ErrorResponse entity = new ErrorResponse();
        return (ErrorResponse)jsonReader.readObject(reader -> {
            block20: while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                switch (fieldName) {
                    case "error": {
                        entity.error = reader.getString();
                        continue block20;
                    }
                    case "error_description": {
                        entity.errorDescription = reader.getString();
                        continue block20;
                    }
                    case "error_codes": {
                        entity.errorCodes = reader.readArray(JsonReader::getLong).stream().mapToLong(Long::longValue).toArray();
                        continue block20;
                    }
                    case "suberror": {
                        entity.subError = reader.getString();
                        continue block20;
                    }
                    case "trace_id": {
                        entity.traceId = reader.getString();
                        continue block20;
                    }
                    case "timestamp": {
                        entity.timestamp = reader.getString();
                        continue block20;
                    }
                    case "correlation_id": {
                        entity.correlation_id = reader.getString();
                        continue block20;
                    }
                    case "claims": {
                        entity.claims = reader.getString();
                        continue block20;
                    }
                }
                reader.skipChildren();
            }
            return entity;
        });
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("statusCode", (Number)this.statusCode);
        jsonWriter.writeStringField("statusMessage", this.statusMessage);
        jsonWriter.writeStringField("error", this.error);
        jsonWriter.writeStringField("error_description", this.errorDescription);
        if (this.errorCodes != null) {
            jsonWriter.writeStartArray("error_codes");
            for (long code : this.errorCodes) {
                jsonWriter.writeNumber((Number)code);
            }
            jsonWriter.writeEndArray();
        } else {
            jsonWriter.writeNullField("error_codes");
        }
        jsonWriter.writeStringField("suberror", this.subError);
        jsonWriter.writeStringField("trace_id", this.traceId);
        jsonWriter.writeStringField("timestamp", this.timestamp);
        jsonWriter.writeStringField("correlation_id", this.correlation_id);
        jsonWriter.writeStringField("claims", this.claims);
        jsonWriter.writeEndObject();
        return jsonWriter;
    }

    Integer statusCode() {
        return this.statusCode;
    }

    String statusMessage() {
        return this.statusMessage;
    }

    String error() {
        return this.error;
    }

    String errorDescription() {
        return this.errorDescription;
    }

    long[] errorCodes() {
        return this.errorCodes;
    }

    String subError() {
        return this.subError;
    }

    String traceId() {
        return this.traceId;
    }

    String timestamp() {
        return this.timestamp;
    }

    String correlation_id() {
        return this.correlation_id;
    }

    String claims() {
        return this.claims;
    }

    void statusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    void statusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    void error(String error) {
        this.error = error;
    }

    void errorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    void errorCodes(long[] errorCodes) {
        this.errorCodes = errorCodes;
    }

    void subError(String subError) {
        this.subError = subError;
    }

    void traceId(String traceId) {
        this.traceId = traceId;
    }

    void timestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    void correlation_id(String correlation_id) {
        this.correlation_id = correlation_id;
    }

    void claims(String claims) {
        this.claims = claims;
    }
}

