/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.containerinstance.models.ResourceLimits;
import com.azure.resourcemanager.containerinstance.models.ResourceRequests;
import java.io.IOException;

public final class ResourceRequirements
implements JsonSerializable<ResourceRequirements> {
    private ResourceRequests requests;
    private ResourceLimits limits;
    private static final ClientLogger LOGGER = new ClientLogger(ResourceRequirements.class);

    public ResourceRequests requests() {
        return this.requests;
    }

    public ResourceRequirements withRequests(ResourceRequests requests) {
        this.requests = requests;
        return this;
    }

    public ResourceLimits limits() {
        return this.limits;
    }

    public ResourceRequirements withLimits(ResourceLimits limits) {
        this.limits = limits;
        return this;
    }

    public void validate() {
        if (this.requests() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property requests in model ResourceRequirements"));
        }
        this.requests().validate();
        if (this.limits() != null) {
            this.limits().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("requests", (JsonSerializable)this.requests);
        jsonWriter.writeJsonField("limits", (JsonSerializable)this.limits);
        return jsonWriter.writeEndObject();
    }

    public static ResourceRequirements fromJson(JsonReader jsonReader) throws IOException {
        return (ResourceRequirements)jsonReader.readObject(reader -> {
            ResourceRequirements deserializedResourceRequirements = new ResourceRequirements();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("requests".equals(fieldName)) {
                    deserializedResourceRequirements.requests = ResourceRequests.fromJson(reader);
                    continue;
                }
                if ("limits".equals(fieldName)) {
                    deserializedResourceRequirements.limits = ResourceLimits.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedResourceRequirements;
        });
    }
}

