/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ImageRegistryCredential
implements JsonSerializable<ImageRegistryCredential> {
    private String server;
    private String username;
    private String password;
    private String identity;
    private String identityUrl;
    private static final ClientLogger LOGGER = new ClientLogger(ImageRegistryCredential.class);

    public String server() {
        return this.server;
    }

    public ImageRegistryCredential withServer(String server) {
        this.server = server;
        return this;
    }

    public String username() {
        return this.username;
    }

    public ImageRegistryCredential withUsername(String username) {
        this.username = username;
        return this;
    }

    public String password() {
        return this.password;
    }

    public ImageRegistryCredential withPassword(String password) {
        this.password = password;
        return this;
    }

    public String identity() {
        return this.identity;
    }

    public ImageRegistryCredential withIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public String identityUrl() {
        return this.identityUrl;
    }

    public ImageRegistryCredential withIdentityUrl(String identityUrl) {
        this.identityUrl = identityUrl;
        return this;
    }

    public void validate() {
        if (this.server() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property server in model ImageRegistryCredential"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("server", this.server);
        jsonWriter.writeStringField("username", this.username);
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeStringField("identity", this.identity);
        jsonWriter.writeStringField("identityUrl", this.identityUrl);
        return jsonWriter.writeEndObject();
    }

    public static ImageRegistryCredential fromJson(JsonReader jsonReader) throws IOException {
        return (ImageRegistryCredential)jsonReader.readObject(reader -> {
            ImageRegistryCredential deserializedImageRegistryCredential = new ImageRegistryCredential();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("server".equals(fieldName)) {
                    deserializedImageRegistryCredential.server = reader.getString();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedImageRegistryCredential.username = reader.getString();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedImageRegistryCredential.password = reader.getString();
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedImageRegistryCredential.identity = reader.getString();
                    continue;
                }
                if ("identityUrl".equals(fieldName)) {
                    deserializedImageRegistryCredential.identityUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImageRegistryCredential;
        });
    }
}

