/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.privatedns.implementation;

import com.azure.resourcemanager.privatedns.PrivateDnsZoneManager;
import com.azure.resourcemanager.privatedns.fluent.PrivateDnsManagementClient;
import com.azure.resourcemanager.privatedns.fluent.PrivateZonesClient;
import com.azure.resourcemanager.privatedns.fluent.models.PrivateZoneInner;
import com.azure.resourcemanager.privatedns.implementation.PrivateDnsZoneImpl;
import com.azure.resourcemanager.privatedns.models.PrivateDnsZone;
import com.azure.resourcemanager.privatedns.models.PrivateDnsZones;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import reactor.core.publisher.Mono;

public final class PrivateDnsZonesImpl
extends TopLevelModifiableResourcesImpl<PrivateDnsZone, PrivateDnsZoneImpl, PrivateZoneInner, PrivateZonesClient, PrivateDnsZoneManager>
implements PrivateDnsZones {
    public PrivateDnsZonesImpl(PrivateDnsZoneManager manager) {
        super((InnerSupportsListing)((PrivateDnsManagementClient)manager.serviceClient()).getPrivateZones(), (Manager)manager);
    }

    @Override
    public void deleteById(String id) {
        this.deleteByIdAsync(id).block();
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        return this.deleteByIdAsync(id, null);
    }

    @Override
    public void deleteById(String id, String etagValue) {
        this.deleteByIdAsync(id, etagValue).block();
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id, String etagValue) {
        return this.deleteByResourceGroupNameAsync(ResourceUtils.groupFromResourceId((String)id), ResourceUtils.nameFromResourceId((String)id), etagValue);
    }

    @Override
    public void deleteByResourceGroupName(String resourceGroupName, String name) {
        this.deleteByResourceGroupNameAsync(resourceGroupName, name).block();
    }

    @Override
    public Mono<Void> deleteByResourceGroupNameAsync(String resourceGroupName, String name) {
        return this.deleteByResourceGroupNameAsync(resourceGroupName, name, null);
    }

    @Override
    public void deleteByResourceGroupName(String resourceGroupName, String name, String etagValue) {
        this.deleteByResourceGroupNameAsync(resourceGroupName, name, etagValue).block();
    }

    @Override
    public Mono<Void> deleteByResourceGroupNameAsync(String resourceGroupName, String name, String etagValue) {
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)this.manager()).serviceClient()).getPrivateZones().deleteAsync(resourceGroupName, name, etagValue);
    }

    protected PrivateDnsZoneImpl wrapModel(String name) {
        return new PrivateDnsZoneImpl(name, new PrivateZoneInner(), (PrivateDnsZoneManager)this.manager());
    }

    protected PrivateDnsZoneImpl wrapModel(PrivateZoneInner inner) {
        if (inner == null) {
            return null;
        }
        return new PrivateDnsZoneImpl(inner.name(), inner, (PrivateDnsZoneManager)this.manager());
    }

    public PrivateDnsZoneImpl define(String name) {
        return this.setDefaults(this.wrapModel(name));
    }

    private PrivateDnsZoneImpl setDefaults(PrivateDnsZoneImpl privateDnsZone) {
        ((PrivateZoneInner)((Object)privateDnsZone.innerModel())).withLocation("global");
        return privateDnsZone;
    }
}

