/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.privatedns.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.privatedns.PrivateDnsZoneManager;
import com.azure.resourcemanager.privatedns.fluent.PrivateDnsManagementClient;
import com.azure.resourcemanager.privatedns.fluent.models.RecordSetInner;
import com.azure.resourcemanager.privatedns.implementation.PrivateDnsZoneImpl;
import com.azure.resourcemanager.privatedns.models.PrivateDnsRecordSets;
import com.azure.resourcemanager.privatedns.models.RecordType;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import reactor.core.publisher.Mono;

abstract class PrivateDnsRecordSetsBaseImpl<PrivateRecordSetT, PrivateRecordSetImplT extends PrivateRecordSetT>
extends ReadableWrappersImpl<PrivateRecordSetT, PrivateRecordSetImplT, RecordSetInner>
implements PrivateDnsRecordSets<PrivateRecordSetT> {
    protected final PrivateDnsZoneImpl privateDnsZone;
    protected final RecordType recordType;

    PrivateDnsRecordSetsBaseImpl(PrivateDnsZoneImpl parent, RecordType recordType) {
        this.privateDnsZone = parent;
        this.recordType = recordType;
    }

    public PagedIterable<PrivateRecordSetT> list() {
        return this.listIntern(null, null);
    }

    @Override
    public PagedIterable<PrivateRecordSetT> list(String recordSetNameSuffix) {
        return this.listIntern(recordSetNameSuffix, null);
    }

    @Override
    public PagedIterable<PrivateRecordSetT> list(int pageSize) {
        return this.listIntern(null, pageSize);
    }

    @Override
    public PagedIterable<PrivateRecordSetT> list(String recordSetNameSuffix, int pageSize) {
        return this.listIntern(recordSetNameSuffix, pageSize);
    }

    public PagedFlux<PrivateRecordSetT> listAsync() {
        return this.listInternAsync(null, null);
    }

    @Override
    public PagedFlux<PrivateRecordSetT> listAsync(String recordSetNameSuffix) {
        return this.listInternAsync(recordSetNameSuffix, null);
    }

    @Override
    public PagedFlux<PrivateRecordSetT> listAsync(int pageSize) {
        return this.listInternAsync(null, pageSize);
    }

    @Override
    public PagedFlux<PrivateRecordSetT> listAsync(String recordSetNameSuffix, int pageSize) {
        return this.listInternAsync(recordSetNameSuffix, pageSize);
    }

    public PrivateRecordSetT getByName(String name) {
        return (PrivateRecordSetT)this.getByNameAsync(name).block();
    }

    public Mono<PrivateRecordSetT> getByNameAsync(String name) {
        PrivateDnsRecordSetsBaseImpl privateDnsRecordSetsBaseImpl = this;
        return ((PrivateDnsManagementClient)((PrivateDnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().getAsync(this.parent().resourceGroupName(), this.parent().name(), this.recordType, name).map(x$0 -> privateDnsRecordSetsBaseImpl.wrapModel(x$0));
    }

    public PrivateDnsZoneImpl parent() {
        return this.privateDnsZone;
    }

    protected PagedIterable<PrivateRecordSetT> listIntern(String recordSetNameSuffix, Integer pageSize) {
        return new PagedIterable(this.listInternAsync(recordSetNameSuffix, pageSize));
    }

    protected PagedFlux<PrivateRecordSetT> listInternAsync(String recordSetNameSuffix, Integer pageSize) {
        return this.wrapPageAsync(((PrivateDnsManagementClient)((PrivateDnsZoneManager)this.parent().manager()).serviceClient()).getRecordSets().listByTypeAsync(this.parent().resourceGroupName(), this.parent().name(), this.recordType, pageSize, recordSetNameSuffix));
    }
}

