/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.msi.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class FederatedIdentityCredentialProperties
implements JsonSerializable<FederatedIdentityCredentialProperties> {
    private String issuer;
    private String subject;
    private List<String> audiences;
    private static final ClientLogger LOGGER = new ClientLogger(FederatedIdentityCredentialProperties.class);

    public String issuer() {
        return this.issuer;
    }

    public FederatedIdentityCredentialProperties withIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public String subject() {
        return this.subject;
    }

    public FederatedIdentityCredentialProperties withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public List<String> audiences() {
        return this.audiences;
    }

    public FederatedIdentityCredentialProperties withAudiences(List<String> audiences) {
        this.audiences = audiences;
        return this;
    }

    public void validate() {
        if (this.issuer() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property issuer in model FederatedIdentityCredentialProperties"));
        }
        if (this.subject() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property subject in model FederatedIdentityCredentialProperties"));
        }
        if (this.audiences() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property audiences in model FederatedIdentityCredentialProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("issuer", this.issuer);
        jsonWriter.writeStringField("subject", this.subject);
        jsonWriter.writeArrayField("audiences", this.audiences, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static FederatedIdentityCredentialProperties fromJson(JsonReader jsonReader) throws IOException {
        return (FederatedIdentityCredentialProperties)jsonReader.readObject(reader -> {
            FederatedIdentityCredentialProperties deserializedFederatedIdentityCredentialProperties = new FederatedIdentityCredentialProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("issuer".equals(fieldName)) {
                    deserializedFederatedIdentityCredentialProperties.issuer = reader.getString();
                    continue;
                }
                if ("subject".equals(fieldName)) {
                    deserializedFederatedIdentityCredentialProperties.subject = reader.getString();
                    continue;
                }
                if ("audiences".equals(fieldName)) {
                    List audiences;
                    deserializedFederatedIdentityCredentialProperties.audiences = audiences = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFederatedIdentityCredentialProperties;
        });
    }
}

