/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayMigrationType;
import java.io.IOException;

public final class VirtualNetworkGatewayMigrationParameters
implements JsonSerializable<VirtualNetworkGatewayMigrationParameters> {
    private VirtualNetworkGatewayMigrationType migrationType;
    private String resourceUrl;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualNetworkGatewayMigrationParameters.class);

    public VirtualNetworkGatewayMigrationType migrationType() {
        return this.migrationType;
    }

    public VirtualNetworkGatewayMigrationParameters withMigrationType(VirtualNetworkGatewayMigrationType migrationType) {
        this.migrationType = migrationType;
        return this;
    }

    public String resourceUrl() {
        return this.resourceUrl;
    }

    public VirtualNetworkGatewayMigrationParameters withResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
        return this;
    }

    public void validate() {
        if (this.migrationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property migrationType in model VirtualNetworkGatewayMigrationParameters"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("migrationType", this.migrationType == null ? null : this.migrationType.toString());
        jsonWriter.writeStringField("resourceUrl", this.resourceUrl);
        return jsonWriter.writeEndObject();
    }

    public static VirtualNetworkGatewayMigrationParameters fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualNetworkGatewayMigrationParameters)jsonReader.readObject(reader -> {
            VirtualNetworkGatewayMigrationParameters deserializedVirtualNetworkGatewayMigrationParameters = new VirtualNetworkGatewayMigrationParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("migrationType".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayMigrationParameters.migrationType = VirtualNetworkGatewayMigrationType.fromString(reader.getString());
                    continue;
                }
                if ("resourceUrl".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayMigrationParameters.resourceUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualNetworkGatewayMigrationParameters;
        });
    }
}

