/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ExclusionManagedRuleGroup;
import java.io.IOException;
import java.util.List;

public final class ExclusionManagedRuleSet
implements JsonSerializable<ExclusionManagedRuleSet> {
    private String ruleSetType;
    private String ruleSetVersion;
    private List<ExclusionManagedRuleGroup> ruleGroups;
    private static final ClientLogger LOGGER = new ClientLogger(ExclusionManagedRuleSet.class);

    public String ruleSetType() {
        return this.ruleSetType;
    }

    public ExclusionManagedRuleSet withRuleSetType(String ruleSetType) {
        this.ruleSetType = ruleSetType;
        return this;
    }

    public String ruleSetVersion() {
        return this.ruleSetVersion;
    }

    public ExclusionManagedRuleSet withRuleSetVersion(String ruleSetVersion) {
        this.ruleSetVersion = ruleSetVersion;
        return this;
    }

    public List<ExclusionManagedRuleGroup> ruleGroups() {
        return this.ruleGroups;
    }

    public ExclusionManagedRuleSet withRuleGroups(List<ExclusionManagedRuleGroup> ruleGroups) {
        this.ruleGroups = ruleGroups;
        return this;
    }

    public void validate() {
        if (this.ruleSetType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ruleSetType in model ExclusionManagedRuleSet"));
        }
        if (this.ruleSetVersion() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property ruleSetVersion in model ExclusionManagedRuleSet"));
        }
        if (this.ruleGroups() != null) {
            this.ruleGroups().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleSetType", this.ruleSetType);
        jsonWriter.writeStringField("ruleSetVersion", this.ruleSetVersion);
        jsonWriter.writeArrayField("ruleGroups", this.ruleGroups, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ExclusionManagedRuleSet fromJson(JsonReader jsonReader) throws IOException {
        return (ExclusionManagedRuleSet)jsonReader.readObject(reader -> {
            ExclusionManagedRuleSet deserializedExclusionManagedRuleSet = new ExclusionManagedRuleSet();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("ruleSetType".equals(fieldName)) {
                    deserializedExclusionManagedRuleSet.ruleSetType = reader.getString();
                    continue;
                }
                if ("ruleSetVersion".equals(fieldName)) {
                    deserializedExclusionManagedRuleSet.ruleSetVersion = reader.getString();
                    continue;
                }
                if ("ruleGroups".equals(fieldName)) {
                    List ruleGroups;
                    deserializedExclusionManagedRuleSet.ruleGroups = ruleGroups = reader.readArray(reader1 -> ExclusionManagedRuleGroup.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExclusionManagedRuleSet;
        });
    }
}

