/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkGroupProperties;
import com.azure.resourcemanager.network.models.GroupMemberType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class ConfigurationGroup
implements JsonSerializable<ConfigurationGroup> {
    private String id;
    private NetworkGroupProperties innerProperties;

    public String id() {
        return this.id;
    }

    public ConfigurationGroup withId(String id) {
        this.id = id;
        return this;
    }

    private NetworkGroupProperties innerProperties() {
        return this.innerProperties;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public ConfigurationGroup withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkGroupProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public GroupMemberType memberType() {
        return this.innerProperties() == null ? null : this.innerProperties().memberType();
    }

    public ConfigurationGroup withMemberType(GroupMemberType memberType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkGroupProperties();
        }
        this.innerProperties().withMemberType(memberType);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ConfigurationGroup fromJson(JsonReader jsonReader) throws IOException {
        return (ConfigurationGroup)jsonReader.readObject(reader -> {
            ConfigurationGroup deserializedConfigurationGroup = new ConfigurationGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedConfigurationGroup.id = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedConfigurationGroup.innerProperties = NetworkGroupProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConfigurationGroup;
        });
    }
}

