/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class BgpCommunity
implements JsonSerializable<BgpCommunity> {
    private String serviceSupportedRegion;
    private String communityName;
    private String communityValue;
    private List<String> communityPrefixes;
    private Boolean isAuthorizedToUse;
    private String serviceGroup;

    public String serviceSupportedRegion() {
        return this.serviceSupportedRegion;
    }

    public BgpCommunity withServiceSupportedRegion(String serviceSupportedRegion) {
        this.serviceSupportedRegion = serviceSupportedRegion;
        return this;
    }

    public String communityName() {
        return this.communityName;
    }

    public BgpCommunity withCommunityName(String communityName) {
        this.communityName = communityName;
        return this;
    }

    public String communityValue() {
        return this.communityValue;
    }

    public BgpCommunity withCommunityValue(String communityValue) {
        this.communityValue = communityValue;
        return this;
    }

    public List<String> communityPrefixes() {
        return this.communityPrefixes;
    }

    public BgpCommunity withCommunityPrefixes(List<String> communityPrefixes) {
        this.communityPrefixes = communityPrefixes;
        return this;
    }

    public Boolean isAuthorizedToUse() {
        return this.isAuthorizedToUse;
    }

    public BgpCommunity withIsAuthorizedToUse(Boolean isAuthorizedToUse) {
        this.isAuthorizedToUse = isAuthorizedToUse;
        return this;
    }

    public String serviceGroup() {
        return this.serviceGroup;
    }

    public BgpCommunity withServiceGroup(String serviceGroup) {
        this.serviceGroup = serviceGroup;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("serviceSupportedRegion", this.serviceSupportedRegion);
        jsonWriter.writeStringField("communityName", this.communityName);
        jsonWriter.writeStringField("communityValue", this.communityValue);
        jsonWriter.writeArrayField("communityPrefixes", this.communityPrefixes, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("isAuthorizedToUse", this.isAuthorizedToUse);
        jsonWriter.writeStringField("serviceGroup", this.serviceGroup);
        return jsonWriter.writeEndObject();
    }

    public static BgpCommunity fromJson(JsonReader jsonReader) throws IOException {
        return (BgpCommunity)jsonReader.readObject(reader -> {
            BgpCommunity deserializedBgpCommunity = new BgpCommunity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("serviceSupportedRegion".equals(fieldName)) {
                    deserializedBgpCommunity.serviceSupportedRegion = reader.getString();
                    continue;
                }
                if ("communityName".equals(fieldName)) {
                    deserializedBgpCommunity.communityName = reader.getString();
                    continue;
                }
                if ("communityValue".equals(fieldName)) {
                    deserializedBgpCommunity.communityValue = reader.getString();
                    continue;
                }
                if ("communityPrefixes".equals(fieldName)) {
                    List communityPrefixes;
                    deserializedBgpCommunity.communityPrefixes = communityPrefixes = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("isAuthorizedToUse".equals(fieldName)) {
                    deserializedBgpCommunity.isAuthorizedToUse = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("serviceGroup".equals(fieldName)) {
                    deserializedBgpCommunity.serviceGroup = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBgpCommunity;
        });
    }
}

