/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AzureReachabilityReportLatencyInfo
implements JsonSerializable<AzureReachabilityReportLatencyInfo> {
    private OffsetDateTime timestamp;
    private Integer score;

    public OffsetDateTime timestamp() {
        return this.timestamp;
    }

    public AzureReachabilityReportLatencyInfo withTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Integer score() {
        return this.score;
    }

    public AzureReachabilityReportLatencyInfo withScore(Integer score) {
        this.score = score;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("timeStamp", this.timestamp == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.timestamp));
        jsonWriter.writeNumberField("score", (Number)this.score);
        return jsonWriter.writeEndObject();
    }

    public static AzureReachabilityReportLatencyInfo fromJson(JsonReader jsonReader) throws IOException {
        return (AzureReachabilityReportLatencyInfo)jsonReader.readObject(reader -> {
            AzureReachabilityReportLatencyInfo deserializedAzureReachabilityReportLatencyInfo = new AzureReachabilityReportLatencyInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("timeStamp".equals(fieldName)) {
                    deserializedAzureReachabilityReportLatencyInfo.timestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("score".equals(fieldName)) {
                    deserializedAzureReachabilityReportLatencyInfo.score = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureReachabilityReportLatencyInfo;
        });
    }
}

