/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayHttpListenerPropertiesFormat;
import com.azure.resourcemanager.network.models.ApplicationGatewayCustomError;
import com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ApplicationGatewayHttpListener
extends SubResource {
    private ApplicationGatewayHttpListenerPropertiesFormat innerProperties;
    private String name;
    private String etag;
    private String type;

    private ApplicationGatewayHttpListenerPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public ApplicationGatewayHttpListener withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public ApplicationGatewayHttpListener withId(String id) {
        super.withId(id);
        return this;
    }

    public SubResource frontendIpConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().frontendIpConfiguration();
    }

    public ApplicationGatewayHttpListener withFrontendIpConfiguration(SubResource frontendIpConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayHttpListenerPropertiesFormat();
        }
        this.innerProperties().withFrontendIpConfiguration(frontendIpConfiguration);
        return this;
    }

    public SubResource frontendPort() {
        return this.innerProperties() == null ? null : this.innerProperties().frontendPort();
    }

    public ApplicationGatewayHttpListener withFrontendPort(SubResource frontendPort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayHttpListenerPropertiesFormat();
        }
        this.innerProperties().withFrontendPort(frontendPort);
        return this;
    }

    public ApplicationGatewayProtocol protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    public ApplicationGatewayHttpListener withProtocol(ApplicationGatewayProtocol protocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayHttpListenerPropertiesFormat();
        }
        this.innerProperties().withProtocol(protocol);
        return this;
    }

    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    public ApplicationGatewayHttpListener withHostname(String hostname) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayHttpListenerPropertiesFormat();
        }
        this.innerProperties().withHostname(hostname);
        return this;
    }

    public SubResource sslCertificate() {
        return this.innerProperties() == null ? null : this.innerProperties().sslCertificate();
    }

    public ApplicationGatewayHttpListener withSslCertificate(SubResource sslCertificate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayHttpListenerPropertiesFormat();
        }
        this.innerProperties().withSslCertificate(sslCertificate);
        return this;
    }

    public SubResource sslProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().sslProfile();
    }

    public ApplicationGatewayHttpListener withSslProfile(SubResource sslProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayHttpListenerPropertiesFormat();
        }
        this.innerProperties().withSslProfile(sslProfile);
        return this;
    }

    public Boolean requireServerNameIndication() {
        return this.innerProperties() == null ? null : this.innerProperties().requireServerNameIndication();
    }

    public ApplicationGatewayHttpListener withRequireServerNameIndication(Boolean requireServerNameIndication) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayHttpListenerPropertiesFormat();
        }
        this.innerProperties().withRequireServerNameIndication(requireServerNameIndication);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<ApplicationGatewayCustomError> customErrorConfigurations() {
        return this.innerProperties() == null ? null : this.innerProperties().customErrorConfigurations();
    }

    public ApplicationGatewayHttpListener withCustomErrorConfigurations(List<ApplicationGatewayCustomError> customErrorConfigurations) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayHttpListenerPropertiesFormat();
        }
        this.innerProperties().withCustomErrorConfigurations(customErrorConfigurations);
        return this;
    }

    public SubResource firewallPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().firewallPolicy();
    }

    public ApplicationGatewayHttpListener withFirewallPolicy(SubResource firewallPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayHttpListenerPropertiesFormat();
        }
        this.innerProperties().withFirewallPolicy(firewallPolicy);
        return this;
    }

    public List<String> hostNames() {
        return this.innerProperties() == null ? null : this.innerProperties().hostNames();
    }

    public ApplicationGatewayHttpListener withHostNames(List<String> hostNames) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayHttpListenerPropertiesFormat();
        }
        this.innerProperties().withHostNames(hostNames);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayHttpListener fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayHttpListener)((Object)jsonReader.readObject(reader -> {
            ApplicationGatewayHttpListener deserializedApplicationGatewayHttpListener = new ApplicationGatewayHttpListener();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedApplicationGatewayHttpListener.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedApplicationGatewayHttpListener.innerProperties = ApplicationGatewayHttpListenerPropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedApplicationGatewayHttpListener.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedApplicationGatewayHttpListener.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedApplicationGatewayHttpListener.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayHttpListener;
        }));
    }
}

