/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VpnSiteLinkInner;
import com.azure.resourcemanager.network.models.AddressSpace;
import com.azure.resourcemanager.network.models.BgpSettings;
import com.azure.resourcemanager.network.models.DeviceProperties;
import com.azure.resourcemanager.network.models.O365PolicyProperties;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class VpnSiteProperties
implements JsonSerializable<VpnSiteProperties> {
    private SubResource virtualWan;
    private DeviceProperties deviceProperties;
    private String ipAddress;
    private String siteKey;
    private AddressSpace addressSpace;
    private BgpSettings bgpProperties;
    private ProvisioningState provisioningState;
    private Boolean isSecuritySite;
    private List<VpnSiteLinkInner> vpnSiteLinks;
    private O365PolicyProperties o365Policy;

    public SubResource virtualWan() {
        return this.virtualWan;
    }

    public VpnSiteProperties withVirtualWan(SubResource virtualWan) {
        this.virtualWan = virtualWan;
        return this;
    }

    public DeviceProperties deviceProperties() {
        return this.deviceProperties;
    }

    public VpnSiteProperties withDeviceProperties(DeviceProperties deviceProperties) {
        this.deviceProperties = deviceProperties;
        return this;
    }

    public String ipAddress() {
        return this.ipAddress;
    }

    public VpnSiteProperties withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public String siteKey() {
        return this.siteKey;
    }

    public VpnSiteProperties withSiteKey(String siteKey) {
        this.siteKey = siteKey;
        return this;
    }

    public AddressSpace addressSpace() {
        return this.addressSpace;
    }

    public VpnSiteProperties withAddressSpace(AddressSpace addressSpace) {
        this.addressSpace = addressSpace;
        return this;
    }

    public BgpSettings bgpProperties() {
        return this.bgpProperties;
    }

    public VpnSiteProperties withBgpProperties(BgpSettings bgpProperties) {
        this.bgpProperties = bgpProperties;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Boolean isSecuritySite() {
        return this.isSecuritySite;
    }

    public VpnSiteProperties withIsSecuritySite(Boolean isSecuritySite) {
        this.isSecuritySite = isSecuritySite;
        return this;
    }

    public List<VpnSiteLinkInner> vpnSiteLinks() {
        return this.vpnSiteLinks;
    }

    public VpnSiteProperties withVpnSiteLinks(List<VpnSiteLinkInner> vpnSiteLinks) {
        this.vpnSiteLinks = vpnSiteLinks;
        return this;
    }

    public O365PolicyProperties o365Policy() {
        return this.o365Policy;
    }

    public VpnSiteProperties withO365Policy(O365PolicyProperties o365Policy) {
        this.o365Policy = o365Policy;
        return this;
    }

    public void validate() {
        if (this.deviceProperties() != null) {
            this.deviceProperties().validate();
        }
        if (this.addressSpace() != null) {
            this.addressSpace().validate();
        }
        if (this.bgpProperties() != null) {
            this.bgpProperties().validate();
        }
        if (this.vpnSiteLinks() != null) {
            this.vpnSiteLinks().forEach(e -> e.validate());
        }
        if (this.o365Policy() != null) {
            this.o365Policy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("virtualWan", (JsonSerializable)this.virtualWan);
        jsonWriter.writeJsonField("deviceProperties", (JsonSerializable)this.deviceProperties);
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        jsonWriter.writeStringField("siteKey", this.siteKey);
        jsonWriter.writeJsonField("addressSpace", (JsonSerializable)this.addressSpace);
        jsonWriter.writeJsonField("bgpProperties", (JsonSerializable)this.bgpProperties);
        jsonWriter.writeBooleanField("isSecuritySite", this.isSecuritySite);
        jsonWriter.writeArrayField("vpnSiteLinks", this.vpnSiteLinks, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("o365Policy", (JsonSerializable)this.o365Policy);
        return jsonWriter.writeEndObject();
    }

    public static VpnSiteProperties fromJson(JsonReader jsonReader) throws IOException {
        return (VpnSiteProperties)jsonReader.readObject(reader -> {
            VpnSiteProperties deserializedVpnSiteProperties = new VpnSiteProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("virtualWan".equals(fieldName)) {
                    deserializedVpnSiteProperties.virtualWan = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("deviceProperties".equals(fieldName)) {
                    deserializedVpnSiteProperties.deviceProperties = DeviceProperties.fromJson(reader);
                    continue;
                }
                if ("ipAddress".equals(fieldName)) {
                    deserializedVpnSiteProperties.ipAddress = reader.getString();
                    continue;
                }
                if ("siteKey".equals(fieldName)) {
                    deserializedVpnSiteProperties.siteKey = reader.getString();
                    continue;
                }
                if ("addressSpace".equals(fieldName)) {
                    deserializedVpnSiteProperties.addressSpace = AddressSpace.fromJson(reader);
                    continue;
                }
                if ("bgpProperties".equals(fieldName)) {
                    deserializedVpnSiteProperties.bgpProperties = BgpSettings.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedVpnSiteProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("isSecuritySite".equals(fieldName)) {
                    deserializedVpnSiteProperties.isSecuritySite = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("vpnSiteLinks".equals(fieldName)) {
                    List vpnSiteLinks;
                    deserializedVpnSiteProperties.vpnSiteLinks = vpnSiteLinks = reader.readArray(reader1 -> VpnSiteLinkInner.fromJson(reader1));
                    continue;
                }
                if ("o365Policy".equals(fieldName)) {
                    deserializedVpnSiteProperties.o365Policy = O365PolicyProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVpnSiteProperties;
        });
    }
}

