/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.TopologyResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class TopologyInner
implements JsonSerializable<TopologyInner> {
    private String id;
    private OffsetDateTime createdDateTime;
    private OffsetDateTime lastModified;
    private List<TopologyResource> resources;

    public String id() {
        return this.id;
    }

    public OffsetDateTime createdDateTime() {
        return this.createdDateTime;
    }

    public OffsetDateTime lastModified() {
        return this.lastModified;
    }

    public List<TopologyResource> resources() {
        return this.resources;
    }

    public TopologyInner withResources(List<TopologyResource> resources) {
        this.resources = resources;
        return this;
    }

    public void validate() {
        if (this.resources() != null) {
            this.resources().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("resources", this.resources, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TopologyInner fromJson(JsonReader jsonReader) throws IOException {
        return (TopologyInner)jsonReader.readObject(reader -> {
            TopologyInner deserializedTopologyInner = new TopologyInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedTopologyInner.id = reader.getString();
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedTopologyInner.createdDateTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastModified".equals(fieldName)) {
                    deserializedTopologyInner.lastModified = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("resources".equals(fieldName)) {
                    List resources;
                    deserializedTopologyInner.resources = resources = reader.readArray(reader1 -> TopologyResource.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTopologyInner;
        });
    }
}

