/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationSecurityGroupInner;
import com.azure.resourcemanager.network.fluent.models.SecurityRulePropertiesFormat;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityRuleAccess;
import com.azure.resourcemanager.network.models.SecurityRuleDirection;
import com.azure.resourcemanager.network.models.SecurityRuleProtocol;
import java.io.IOException;
import java.util.List;

public final class SecurityRuleInner
extends SubResource {
    private SecurityRulePropertiesFormat innerProperties;
    private String name;
    private String etag;
    private String type;

    private SecurityRulePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public SecurityRuleInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public SecurityRuleInner withType(String type) {
        this.type = type;
        return this;
    }

    public SecurityRuleInner withId(String id) {
        super.withId(id);
        return this;
    }

    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    public SecurityRuleInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    public SecurityRuleProtocol protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    public SecurityRuleInner withProtocol(SecurityRuleProtocol protocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withProtocol(protocol);
        return this;
    }

    public String sourcePortRange() {
        return this.innerProperties() == null ? null : this.innerProperties().sourcePortRange();
    }

    public SecurityRuleInner withSourcePortRange(String sourcePortRange) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withSourcePortRange(sourcePortRange);
        return this;
    }

    public String destinationPortRange() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationPortRange();
    }

    public SecurityRuleInner withDestinationPortRange(String destinationPortRange) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withDestinationPortRange(destinationPortRange);
        return this;
    }

    public String sourceAddressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceAddressPrefix();
    }

    public SecurityRuleInner withSourceAddressPrefix(String sourceAddressPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withSourceAddressPrefix(sourceAddressPrefix);
        return this;
    }

    public List<String> sourceAddressPrefixes() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceAddressPrefixes();
    }

    public SecurityRuleInner withSourceAddressPrefixes(List<String> sourceAddressPrefixes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withSourceAddressPrefixes(sourceAddressPrefixes);
        return this;
    }

    public List<ApplicationSecurityGroupInner> sourceApplicationSecurityGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceApplicationSecurityGroups();
    }

    public SecurityRuleInner withSourceApplicationSecurityGroups(List<ApplicationSecurityGroupInner> sourceApplicationSecurityGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withSourceApplicationSecurityGroups(sourceApplicationSecurityGroups);
        return this;
    }

    public String destinationAddressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationAddressPrefix();
    }

    public SecurityRuleInner withDestinationAddressPrefix(String destinationAddressPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withDestinationAddressPrefix(destinationAddressPrefix);
        return this;
    }

    public List<String> destinationAddressPrefixes() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationAddressPrefixes();
    }

    public SecurityRuleInner withDestinationAddressPrefixes(List<String> destinationAddressPrefixes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withDestinationAddressPrefixes(destinationAddressPrefixes);
        return this;
    }

    public List<ApplicationSecurityGroupInner> destinationApplicationSecurityGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationApplicationSecurityGroups();
    }

    public SecurityRuleInner withDestinationApplicationSecurityGroups(List<ApplicationSecurityGroupInner> destinationApplicationSecurityGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withDestinationApplicationSecurityGroups(destinationApplicationSecurityGroups);
        return this;
    }

    public List<String> sourcePortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().sourcePortRanges();
    }

    public SecurityRuleInner withSourcePortRanges(List<String> sourcePortRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withSourcePortRanges(sourcePortRanges);
        return this;
    }

    public List<String> destinationPortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationPortRanges();
    }

    public SecurityRuleInner withDestinationPortRanges(List<String> destinationPortRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withDestinationPortRanges(destinationPortRanges);
        return this;
    }

    public SecurityRuleAccess access() {
        return this.innerProperties() == null ? null : this.innerProperties().access();
    }

    public SecurityRuleInner withAccess(SecurityRuleAccess access) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withAccess(access);
        return this;
    }

    public Integer priority() {
        return this.innerProperties() == null ? null : Integer.valueOf(this.innerProperties().priority());
    }

    public SecurityRuleInner withPriority(Integer priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    public SecurityRuleDirection direction() {
        return this.innerProperties() == null ? null : this.innerProperties().direction();
    }

    public SecurityRuleInner withDirection(SecurityRuleDirection direction) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withDirection(direction);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static SecurityRuleInner fromJson(JsonReader jsonReader) throws IOException {
        return (SecurityRuleInner)((Object)jsonReader.readObject(reader -> {
            SecurityRuleInner deserializedSecurityRuleInner = new SecurityRuleInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSecurityRuleInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSecurityRuleInner.innerProperties = SecurityRulePropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSecurityRuleInner.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedSecurityRuleInner.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSecurityRuleInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSecurityRuleInner;
        }));
    }
}

