/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.RoutePropertiesFormat;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RouteNextHopType;
import java.io.IOException;

public final class RouteInner
extends SubResource {
    private RoutePropertiesFormat innerProperties;
    private String name;
    private String etag;
    private String type;

    private RoutePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public RouteInner withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public RouteInner withType(String type) {
        this.type = type;
        return this;
    }

    public RouteInner withId(String id) {
        super.withId(id);
        return this;
    }

    public String addressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().addressPrefix();
    }

    public RouteInner withAddressPrefix(String addressPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutePropertiesFormat();
        }
        this.innerProperties().withAddressPrefix(addressPrefix);
        return this;
    }

    public RouteNextHopType nextHopType() {
        return this.innerProperties() == null ? null : this.innerProperties().nextHopType();
    }

    public RouteInner withNextHopType(RouteNextHopType nextHopType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutePropertiesFormat();
        }
        this.innerProperties().withNextHopType(nextHopType);
        return this;
    }

    public String nextHopIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().nextHopIpAddress();
    }

    public RouteInner withNextHopIpAddress(String nextHopIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutePropertiesFormat();
        }
        this.innerProperties().withNextHopIpAddress(nextHopIpAddress);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public Boolean hasBgpOverride() {
        return this.innerProperties() == null ? null : this.innerProperties().hasBgpOverride();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static RouteInner fromJson(JsonReader jsonReader) throws IOException {
        return (RouteInner)((Object)jsonReader.readObject(reader -> {
            RouteInner deserializedRouteInner = new RouteInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRouteInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRouteInner.innerProperties = RoutePropertiesFormat.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRouteInner.name = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedRouteInner.etag = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRouteInner.type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRouteInner;
        }));
    }
}

